/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.spi;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.config.ModuleConfig;
import com.digiwin.athena.km_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.km_deployer_service.service.km.TenantService;
import com.digiwin.athena.km_deployer_service.util.RSAUtils;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class IamService {
    private static final Logger log = LoggerFactory.getLogger(IamService.class);
    @Autowired
    private ModuleConfig moduleConfig;
    @Value(value="${appToken}")
    private String appToken;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private RedisCache redisCache;
    private static final String IV_STRING = "ghUb#er57HBh(u%g";
    private static final String CHARSET = "UTF-8";
    private static final String INTEGRATION_ACCOUNT = "integration";
    @Value(value="${iamIntegrationToken:integration}")
    private String integrationToken;

    public String integrationLogin(String tenantId) {
        String domain = this.moduleConfig.getIam().getDomain();
        String uri = domain + "/api/iam/v2/identity/login";
        try {
            HashMap keyMap = IamService.getKeyPairMap();
            if (keyMap != null) {
                String clientPublicKey = (String)keyMap.get("publicKey");
                String privateKey = (String)keyMap.get("privateKey");
                String serverPublicKey = IamService.getServerPublicky((String)domain, (String)this.appToken);
                String encryptPublicKey = RSAUtils.encryptByPublicKey((String)clientPublicKey, (String)serverPublicKey);
                String encryptAesKey = IamService.getAesPublicky((String)domain, (String)encryptPublicKey, (String)this.appToken);
                String aesKey = new String(RSAUtils.decryptByPrivateKey((byte[])org.apache.commons.codec.binary.Base64.decodeBase64((String)encryptAesKey), (String)privateKey));
                String passwordHash = IamService.aesEncryptByBase64((String)this.integrationToken, (String)aesKey);
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                headers.add("digi-middleware-auth-app", this.appToken);
                HashMap<String, String> requestEntity = new HashMap<String, String>(3);
                requestEntity.put("identityType", "token");
                requestEntity.put("tenantId", tenantId);
                requestEntity.put("userId", "integration");
                requestEntity.put("passwordHash", passwordHash);
                requestEntity.put("clientEncryptPublicKey", encryptPublicKey);
                HttpEntity httpEntity = new HttpEntity(requestEntity, (MultiValueMap)headers);
                ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, Map.class, new Object[0]);
                return String.valueOf(((Map)response.getBody()).get("token"));
            }
        }
        catch (Exception ex) {
            log.error("\u767b\u5f55\u5931\u8d25\uff1a{}", (Object)ex.getMessage(), (Object)ex);
        }
        return null;
    }

    public String getIsvCode(String tenantId) {
        String integrationToken = this.integrationLogin(tenantId);
        String tbbServiceUrl = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/tenant/current";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("digi-middleware-auth-user", integrationToken);
        String response = ((HttpRequest)HttpUtil.createPost((String)tbbServiceUrl).addHeaders(headers)).execute().body();
        JSONObject reponseJson = JSON.parseObject((String)response);
        return reponseJson.getJSONObject("tenant").getString("customerId");
    }

    private static String getServerPublicky(String domain, String appToken) {
        String uri = domain + "/api/iam/v2/identity/publickey";
        try {
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-app", appToken);
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(uri, HttpMethod.GET, httpEntity, Map.class, new Object[0]);
            return String.valueOf(((Map)response.getBody()).get("publicKey"));
        }
        catch (Exception e) {
            log.error("\u767b\u5f55\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            return "";
        }
    }

    private static String getAesPublicky(String domain, String encryptPublicKey, String appToken) {
        String uri = domain + "/api/iam/v2/identity/aeskey";
        try {
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-app", appToken);
            HashMap<String, String> requestEntity = new HashMap<String, String>(1);
            requestEntity.put("clientEncryptPublicKey", encryptPublicKey);
            HttpEntity httpEntity = new HttpEntity(requestEntity, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(uri, HttpMethod.POST, httpEntity, Map.class, new Object[0]);
            return String.valueOf(((Map)response.getBody()).get("encryptAesKey"));
        }
        catch (Exception e) {
            log.error("\u767b\u5f55\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            return "";
        }
    }

    public static HashMap<String, String> getKeyPairMap() throws NoSuchAlgorithmException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(1024);
        KeyPair keyPair = generator.generateKeyPair();
        String privateKey = new String(org.apache.commons.codec.binary.Base64.encodeBase64((byte[])keyPair.getPrivate().getEncoded()));
        String publicKey = new String(org.apache.commons.codec.binary.Base64.encodeBase64((byte[])keyPair.getPublic().getEncoded()));
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put("privateKey", privateKey);
        keyMap.put("publicKey", publicKey);
        return keyMap;
    }

    public static String aesEncryptByBase64(String src, String aesKey) {
        try {
            SecretKeySpec key = new SecretKeySpec(aesKey.getBytes("UTF-8"), "AES");
            byte[] initParam = "ghUb#er57HBh(u%g".getBytes("UTF-8");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(initParam);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)key, ivParameterSpec);
            byte[] cleartext = src.getBytes("UTF-8");
            byte[] ciphertextBytes = cipher.doFinal(cleartext);
            Base64.Encoder encoder = Base64.getEncoder();
            return encoder.encodeToString(ciphertextBytes);
        }
        catch (Exception ex) {
            log.error("AES\u52a0\u5bc6\u5931\u8d25[{}]", (Object)src);
            return src;
        }
    }

    public String getVisualToken(String appCode, String iamToken) {
        String urlIam = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/user/tenant/application";
        String response = ((HttpRequest)((HttpRequest)HttpUtil.createGet((String)urlIam).header("Content-Type", "application/json")).header("Digi-middleware-auth-user", iamToken)).execute().body();
        String secretKey = "";
        JSONArray objects = JSONArray.parseArray((String)response);
        for (Object jSONObjectTemp : objects) {
            JSONObject objectApp = (JSONObject)jSONObjectTemp;
            String appCodeResult = objectApp.getString("id");
            if (!appCode.equals(appCodeResult)) continue;
            secretKey = objectApp.getString("secretKey");
            break;
        }
        String url = this.moduleConfig.getIam().getDomain() + "/api/iam/v2/identity/login";
        HttpHeaders httpHeaders = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        httpHeaders.setContentType(type);
        httpHeaders.add("digi-middleware-auth-app", this.appToken);
        JSONObject body = new JSONObject();
        body.put("secretKey", (Object)secretKey);
        body.put("identityType", (Object)"secretKey");
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
        log.info("getTenantToken request:{}", (Object)httpEntity);
        JSONObject response1 = (JSONObject)this.restTemplate.postForObject(url, (Object)httpEntity, JSONObject.class, new Object[0]);
        log.info("getTenantToken response:{}", (Object)response1);
        return response1.getString("token");
    }

    public Long getAppSid(String appCode, String tenantId) {
        String token = this.integrationLogin(tenantId);
        String iamUrl = this.moduleConfig.getIam().getDomain() + StrUtil.format((CharSequence)"/api/iam/v2/dev/app/id/{}", (Object[])new Object[]{appCode});
        String response = ((HttpRequest)((HttpRequest)HttpUtil.createGet((String)iamUrl).header("digi-middleware-auth-user", token)).header("digi-middleware-auth-app", this.appToken)).execute().body();
        JSONObject responseObj = JSON.parseObject((String)response);
        Boolean success = responseObj.getBoolean("success");
        if (!success.booleanValue()) {
            log.error("\u83b7\u53d6\u5e94\u7528sid\u5931\u8d25\uff0c\u8fd4\u56de:{}", (Object)response);
            throw new BusinessException("\u83b7\u53d6\u5e94\u7528sid\u5931\u8d25\uff0c\u521b\u5efa\u5e94\u7528\u6a21\u7ec4\u5931\u8d25!");
        }
        String appSid = responseObj.getJSONObject("data").getString("sid");
        return Long.parseLong(appSid);
    }
}

