/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.template;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.domain.asa.model.BaseModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.CollectionModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.ActivityModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.AppRelationModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.CustomConfigModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.DataDescriptionModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.DataFeatureSetModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.DataStateModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.FlowGraphModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.PageViewModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.ProjectModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.RulesModelVo;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.TaskModel;
import com.digiwin.athena.km_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.km_deployer_service.template.ITemplate;
import com.digiwin.athena.km_deployer_service.util.FileUtils;
import com.github.benmanes.caffeine.cache.Cache;
import java.io.File;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

public class AbstractTemplate<T extends BaseModel>
implements ITemplate {
    private static final Logger log = LoggerFactory.getLogger(AbstractTemplate.class);
    @Autowired
    private Cache<String, String> templateCaffeineCache;
    protected String collectName;
    @Value(value="classpath:template/yourFile.json")
    private Resource templateResource;
    protected final Map<String, List<Function<CustomConfigModel, T>>> TEMPLATE_HOLDER = new HashMap(10);
    protected static final Map<String, Object> TEMPLATE_TYPE_PATH = new HashMap();
    protected static final Map<String, Class> TEMPLATE_MODEL_CLAZZ;

    protected void initTemplateFunction(String dataType, List<String> templateFilePaths) {
        for (String templateType : TEMPLATE_TYPE_PATH.keySet()) {
            Object templateTypeBasePath = TEMPLATE_TYPE_PATH.get(templateType);
            ArrayList<Function<CustomConfigModel, BaseModel>> templateFunctionList = new ArrayList<Function<CustomConfigModel, BaseModel>>();
            if (templateTypeBasePath instanceof String) {
                for (String templateFilePath : templateFilePaths) {
                    int subPathIndex = templateFilePath.indexOf(templateTypeBasePath.toString());
                    if (subPathIndex == -1) continue;
                    String relativePath = templateFilePath.substring(subPathIndex);
                    Function<CustomConfigModel, BaseModel> templateFunction = model -> this.templateVarProcess(relativePath, model, (Class)TEMPLATE_MODEL_CLAZZ.get(dataType));
                    templateFunctionList.add(templateFunction);
                }
            } else if (templateTypeBasePath instanceof List) {
                List templateTypeBasePaths = (List)templateTypeBasePath;
                for (String basePath : templateTypeBasePaths) {
                    for (String templateFilePath : templateFilePaths) {
                        int subPathIndex = templateFilePath.indexOf(basePath);
                        if (subPathIndex == -1) continue;
                        String relativePath = templateFilePath.substring(subPathIndex);
                        Function<CustomConfigModel, BaseModel> templateFunction = model -> this.templateVarProcess(relativePath, model, (Class)TEMPLATE_MODEL_CLAZZ.get(dataType));
                        templateFunctionList.add(templateFunction);
                    }
                }
            }
            this.TEMPLATE_HOLDER.put(templateType, templateFunctionList);
        }
        log.info(String.valueOf(((List)this.TEMPLATE_HOLDER.get("COLLECT_ITEM_STEP_TEMPLATE")).size()));
    }

    public String getCollectName() {
        return this.collectName;
    }

    public List generate(CustomConfigModel model) {
        ArrayList result = new ArrayList();
        if (this.TEMPLATE_HOLDER.containsKey(model.getTemplateType())) {
            ((List)this.TEMPLATE_HOLDER.get(model.getTemplateType())).forEach(func -> result.add(func.apply(model)));
        }
        return result;
    }

    public void fillCustomConfigModel(CustomConfigModel defConfigModel, JSONObject assistantSceneItemStep) {
    }

    protected T basicProjectProcess(String filePath, CustomConfigModel model, Class<T> cls) {
        String content = this.processProjectTemplate(filePath, model);
        return (T)this.initModel(content, model, cls);
    }

    protected String processProjectTemplate(String filePath, CustomConfigModel model) {
        String processJson = this.getProcessJson(filePath);
        return processJson.replace("#{applicationCode}", model.getAssistantCode()).replace("#{sceneCode}", model.getSceneCode()).replace("#{sceneName}", model.getSceneName());
    }

    protected T templateVarProcess(String filePath, CustomConfigModel model, Class<T> cls) {
        String processJson = this.getProcessJson(filePath);
        String content = processJson.replace("#{applicationCode}", model.getAssistantCode()).replace("#{applicationName}", model.getAssistantName()).replace("#{sceneCode}", model.getSceneCode()).replace("#{sceneName}", model.getSceneName());
        if (null != model.getItemStepCode()) {
            content = content.replace("#{itemStepCode}", model.getItemStepCode()).replace("#{itemStepName}", model.getItemStepName());
        }
        if (null != model.getAbilityCode()) {
            content = content.replace("#{abilityCode}", model.getAbilityCode());
        }
        if (null != model.getAbilityType()) {
            content = content.replace("#{abilityType}", model.getAbilityType());
        }
        if (-1 != model.getItemStepsLength()) {
            content = content.replace("#(itemStepsLength)", String.valueOf(model.getItemStepsLength()));
            content = content.replace("#(itemStepsLength+1)", String.valueOf(model.getItemStepsLength() + 1));
        }
        if (-1 != model.getItemStepNum()) {
            content = content.replace("#(itemStepNum)", String.valueOf(model.getItemStepNum())).replace("#(itemStepNum+1)", String.valueOf(model.getItemStepNum() + 1));
        }
        content = null != model.getSceneLang() && null != model.getSceneLang().getJSONObject("name") ? content.replace("#{sceneName_zhTW}", model.getSceneLang().getJSONObject("name").getString("zh_TW")).replace("#{sceneName_enUS}", model.getSceneLang().getJSONObject("name").getString("en_US")).replace("#{sceneName_zhCN}", model.getSceneLang().getJSONObject("name").getString("zh_CN")) : content.replace("#{sceneName_zhTW}", model.getSceneName()).replace("#{sceneName_enUS}", model.getSceneName()).replace("#{sceneName_zhCN}", model.getSceneName());
        if (null != model.getItemStepLang() && null != model.getItemStepLang().getJSONObject("name")) {
            content = content.replace("#{itemStepName_zhTW}", model.getItemStepLang().getJSONObject("name").getString("zh_TW")).replace("#{itemStepName_enUS}", model.getItemStepLang().getJSONObject("name").getString("en_US")).replace("#{itemStepName_zhCN}", model.getItemStepLang().getJSONObject("name").getString("zh_CN"));
        } else if (null != model.getItemStepName()) {
            content = content.replace("#{itemStepName_zhTW}", model.getItemStepName()).replace("#{itemStepName_enUS}", model.getItemStepName()).replace("#{itemStepName_zhCN}", model.getItemStepName());
        }
        return (T)this.initModel(content, model, cls);
    }

    protected T basicProcess(String filePath, CustomConfigModel model, Class<T> cls) {
        String content = this.processTemplate(filePath, model);
        return (T)this.initModel(content, model, cls);
    }

    protected String processTemplate(String filePath, CustomConfigModel model) {
        String processJson = this.getProcessJson(filePath);
        return processJson.replace("#{applicationCode}", model.getAssistantCode()).replace("#{sceneCode}", model.getSceneCode()).replace("#{sceneName}", model.getSceneName()).replace("#{itemStepCode}", model.getItemStepCode()).replace("#{itemStepName}", model.getItemStepName());
    }

    protected T initModel(String fileContent, CustomConfigModel model, Class<T> cls) {
        BaseModel result;
        try {
            BaseModel t = (BaseModel)cls.newInstance();
            if (t instanceof CollectionModel) {
                List rulesModels = (List)JSON.parseObject((String)fileContent, List.class);
                CollectionModel collectionModel = (CollectionModel)t;
                collectionModel.setCollection(rulesModels);
                result = t;
            } else {
                result = (BaseModel)JSON.parseObject((String)fileContent, cls);
            }
        }
        catch (Exception e) {
            throw new BusinessException("AbstractTemplate.initModel.newInstance error ");
        }
        return (T)result;
    }

    protected String getProcessJson(String filePath) {
        String processJson = (String)this.templateCaffeineCache.getIfPresent((Object)filePath);
        if (StringUtils.isNotEmpty((CharSequence)processJson)) {
            return processJson;
        }
        processJson = (String)FileUtils.readObjectFromFilePath((String)filePath, String.class);
        if (StringUtils.isNotEmpty((CharSequence)processJson)) {
            this.templateCaffeineCache.put((Object)filePath, (Object)processJson);
        }
        return processJson;
    }

    public void addHeader(CustomConfigModel model, Map<String, Object> config) {
        Map headersMap = model.getHeaders();
        if (null != headersMap && !headersMap.isEmpty()) {
            Map headers = (Map)config.get("headers");
            headers.putAll(headersMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initTemplateList(String collectName, String dataType) {
        Stream<Path> paths = null;
        try {
            this.collectName = collectName;
            Path templatePath = null;
            String templatePathEnv = System.getenv("DOCKER_ENVIRONMENT");
            if (StrUtil.isNotBlank((CharSequence)templatePathEnv) && templatePathEnv.equals(Boolean.TRUE.toString())) {
                templatePath = Paths.get("template/asaDeployer", new String[0]);
                paths = Files.walk(templatePath, new FileVisitOption[0]);
            } else {
                ClassLoader classLoader = this.getClass().getClassLoader();
                URL resourceUrl = classLoader.getResource("template/asaDeployer");
                if (resourceUrl != null) {
                    try {
                        templatePath = Paths.get(resourceUrl.toURI());
                        paths = Files.walk(templatePath, new FileVisitOption[0]);
                    }
                    catch (Exception e) {
                        templatePath = null;
                        log.warn("\u83b7\u53d6\u6587\u4ef6\u76ee\u5f55\u9519\u8bef:{}", (Object)e.getMessage());
                    }
                }
                if (templatePath == null) {
                    try {
                        templatePath = Paths.get("src/main/resources/template/asaDeployer", new String[0]);
                        paths = Files.walk(templatePath, new FileVisitOption[0]);
                    }
                    catch (Exception e) {
                        templatePath = Paths.get("km-deployer-service/src/main/resources/template/asaDeployer", new String[0]);
                        paths = Files.walk(templatePath, new FileVisitOption[0]);
                    }
                }
            }
            List activityTemplateList = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().contains(File.separator + dataType + File.separator)).filter(path -> path.toString().endsWith(".json")).map(Path::toString).collect(Collectors.toList());
            this.initTemplateFunction(dataType, activityTemplateList);
        }
        catch (Exception e) {
            log.error("AbstractTemplate.initTemplateList error collectName:{}", (Object)collectName, (Object)e);
        }
        finally {
            if (null != paths) {
                paths.close();
            }
        }
    }

    static {
        TEMPLATE_TYPE_PATH.put("ASSISTANT_SCENE_TEMPLATE", "template" + File.separator + "asaDeployer" + File.separator + "assistant_scene_template");
        TEMPLATE_TYPE_PATH.put("COLLECT_ITEM_STEP_TEMPLATE", "template" + File.separator + "asaDeployer" + File.separator + "collect_item_step_template");
        TEMPLATE_TYPE_PATH.put("CONSULT_ITEM_STEP_TEMPLATE", Stream.of("template" + File.separator + "asaDeployer" + File.separator + "consult_item_step_template" + File.separator + "allConsult", "template" + File.separator + "asaDeployer" + File.separator + "consult_item_step_template" + File.separator + "common", "template" + File.separator + "asaDeployer" + File.separator + "consult_item_step_template" + File.separator + "partConsult", "template" + File.separator + "asaDeployer" + File.separator + "consult_item_step_template" + File.separator + "specifyConsult", "template" + File.separator + "asaDeployer" + File.separator + "consult_item_step_template" + File.separator + "stepConsult").collect(Collectors.toList()));
        TEMPLATE_TYPE_PATH.put("NOTIFACATION_ITEM_STEP_TEMPLATE", "template" + File.separator + "asaDeployer" + File.separator + "notification_item_step_template");
        TEMPLATE_TYPE_PATH.put("BILL_ITEM_STEP_TEMPLATE", "template" + File.separator + "asaDeployer" + File.separator + "bill_item_step_template");
        TEMPLATE_TYPE_PATH.put("CARD_ITEM_STEP_TEMPLATE", "template" + File.separator + "asaDeployer" + File.separator + "card_item_step_template");
        TEMPLATE_TYPE_PATH.put("MINUTES_TASK_TEMPLATE", "template" + File.separator + "asaDeployer" + File.separator + "minutes_task_template");
        TEMPLATE_TYPE_PATH.put("API_TASK_TEMPLATE", "template" + File.separator + "asaDeployer" + File.separator + "api_task_template");
        TEMPLATE_TYPE_PATH.put("TRIP_TASK_TEMPLATE", "template" + File.separator + "asaDeployer" + File.separator + "trip_task_template");
        TEMPLATE_TYPE_PATH.put("FORM_TASK_TEMPLATE", "template" + File.separator + "asaDeployer" + File.separator + "form_task_template");
        TEMPLATE_TYPE_PATH.put("SCHEDULE_QUERY_TASK_TEMPLATE", "template" + File.separator + "asaDeployer" + File.separator + "schedule_query_task_template");
        TEMPLATE_TYPE_PATH.put("SCHEDULE_UPDATE_TASK_TEMPLATE", "template" + File.separator + "asaDeployer" + File.separator + "schedule_update_task_template");
        TEMPLATE_TYPE_PATH.put("SCHEDULE_DELETE_TASK_TEMPLATE", "template" + File.separator + "asaDeployer" + File.separator + "schedule_delete_task_template");
        TEMPLATE_TYPE_PATH.put("TEXT_COLLECT_ITEM_STEP_TEMPLATE", "template" + File.separator + "asaDeployer" + File.separator + "text_collect_item_step_template");
        TEMPLATE_TYPE_PATH.put("LLM_TASK_TEMPLATE", "template" + File.separator + "asaDeployer" + File.separator + "llm_task_template");
        TEMPLATE_MODEL_CLAZZ = new HashMap();
        TEMPLATE_MODEL_CLAZZ.put("activity", ActivityModel.class);
        TEMPLATE_MODEL_CLAZZ.put("dataDescription", DataDescriptionModel.class);
        TEMPLATE_MODEL_CLAZZ.put("dataState", DataStateModel.class);
        TEMPLATE_MODEL_CLAZZ.put("dataFeatureSet", DataFeatureSetModel.class);
        TEMPLATE_MODEL_CLAZZ.put("project", ProjectModel.class);
        TEMPLATE_MODEL_CLAZZ.put("flowGraph", FlowGraphModel.class);
        TEMPLATE_MODEL_CLAZZ.put("pageView", PageViewModel.class);
        TEMPLATE_MODEL_CLAZZ.put("task", TaskModel.class);
        TEMPLATE_MODEL_CLAZZ.put("applicationRelation", AppRelationModel.class);
        TEMPLATE_MODEL_CLAZZ.put("rules", RulesModelVo.class);
    }
}

