/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.thread;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.domain.asa.deploy.DeployDetail;
import com.digiwin.athena.km_deployer_service.domain.asa.enent.DeployEvent;
import com.digiwin.athena.km_deployer_service.domain.asa.param.DeployParam;
import com.digiwin.athena.km_deployer_service.domain.asa.param.SwitchVersionParam;
import com.digiwin.athena.km_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.km_deployer_service.thread.AbstructVersionThread;
import com.digiwin.athena.km_deployer_service.util.CurThreadInfoUtils;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

public class SwitchVersionThread
extends AbstructVersionThread {
    private static final Logger log = LoggerFactory.getLogger(SwitchVersionThread.class);
    private static final String MONGODB_NAME_ASA = "asa";
    private static final String ABANDON_VERSION = "0.0";
    private SwitchVersionParam switchVersionParam;
    private String betaAssistantCode;
    private String curTenantToken;
    private JSONObject aiProject;

    public SwitchVersionThread(SwitchVersionParam switchVersionParam) {
        this.switchVersionParam = switchVersionParam;
        this.parentThreadId = switchVersionParam.getThreadId();
        this.deployNo = switchVersionParam.getDeployNo();
    }

    public void run() {
        CurThreadInfoUtils.setRouterKey((String)this.routerKey);
        this.application = this.switchVersionParam.getApplication();
        this.tenantIdList = this.switchVersionParam.getTenantIdList().toJavaList(String.class);
        this.currentUser = this.switchVersionParam.getCurrentUser();
        this.currentTenantId = this.currentUser.getTenantId();
        log.info("\u5f00\u59cb\u5207\u7248{}:{}", (Object)this.application, (Object)this.parentThreadId);
        DeployDetail deployDetail = new DeployDetail().setDeployNo(this.deployNo).setTime(new Date()).setContent("\u5207\u6362\u5a1c\u5a1c\u7248\u672c..").setResult("start").setApplication(this.application);
        DeployEvent deployEvent = new DeployEvent((Object)this, this.parentThreadId, "process:" + JSON.toJSONString((Object)deployDetail));
        this.applicationContext.publishEvent((ApplicationEvent)deployEvent);
        this.curTenantToken = this.tenantService.getRealTimeTenantToken(this.currentTenantId);
        this.initExtraVariable();
        this.switchCommercial2Abandon();
        if (!this.isSkipGPT) {
            this.doGPTDeploy();
        }
        this.switchBeta2Publish();
        this.constructBetaFromPublish();
        try {
            this.aniaHelper.deployerCache(this.curTenantToken, this.isCNaDeploy, false, this.assistantCode);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u52a9\u7406\u7f13\u5b58error. ", (Throwable)e);
        }
        this.cleanAbandon();
        this.doAfterDataProcess();
        this.doProcess4ProdAndAuth();
        this.resetCache(this.curTenantToken);
        log.info("\u5207\u7248\u5b8c\u6210:{}", (Object)this.parentThreadId);
        deployDetail.setResult("finish");
        long mills = this.calculateExecuteMills(deployDetail.getTime());
        deployDetail.setTime(new Date()).setExecuteTimeMills(Long.valueOf(mills));
        deployEvent.setMsg("process:" + JSON.toJSONString((Object)deployDetail));
        deployEvent.setComplete(true);
        this.applicationContext.publishEvent((ApplicationEvent)deployEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGPTDeploy() {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(this.deployNo).setTime(new Date()).setContent("GPT\u90e8\u7f72..").setResult("start").setApplication(this.application);
        DeployEvent deployEvent = new DeployEvent((Object)this, this.parentThreadId, "process:" + JSON.toJSONString((Object)deployDetail));
        this.applicationContext.publishEvent((ApplicationEvent)deployEvent);
        try {
            Bson assistantFindFilterBson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"assistantCode", (Object)this.betaAssistantCode), Filters.eq((String)"version", (Object)"1.0")});
            FindIterable assistantDoc = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection("assistant").find(assistantFindFilterBson);
            Document assistant = (Document)assistantDoc.first();
            JSONObject jSONObject = this.aiProject = Objects.isNull(assistant.get((Object)"aiProject")) ? null : (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)assistant.get((Object)"aiProject")), JSONObject.class);
            if (this.aiProject != null) {
                this.deployllm(this.application, this.aiProject.getString("llmPromptId"));
                List modelTypes = (List)this.aiProject.getObject("modelTypes", List.class);
                if (modelTypes.contains(MODEL_TYPE_NLU)) {
                    this.tagDeployer(this.application, this.aiProject.getString("modelCode"));
                }
                if (modelTypes.contains(MODEL_TYPE_ES)) {
                    this.esDeployer();
                }
            }
            deployDetail.setResult("success");
        }
        catch (Exception e) {
            log.error("GPT\u90e8\u7f72\u5f02\u5e38:", (Throwable)e);
            this.setWarnDeployDetail(deployDetail, e);
        }
        finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    private void tagDeployer(String projectCode, String modelCode) {
        HashMap<String, String> projectName = new HashMap<String, String>();
        projectName.put("project_name", projectCode);
        StringBuilder stringBuilder = new StringBuilder("deploy_");
        String createMode = "model_1";
        stringBuilder.append(createMode.replace("_", "")).append("_").append(modelCode);
        this.assistantRhApiHelper.tagDeployer(createMode, projectName, "prod", stringBuilder.toString(), this.curTenantToken);
        createMode = "model_2";
        this.assistantRhApiHelper.tagDeployer(createMode, projectName, "prod", stringBuilder.toString().replaceFirst("model1", "model2"), this.curTenantToken);
    }

    private void esDeployer() {
        this.assistantRhApiHelper.esDeployer(this.application, "test", "prod", this.curTenantToken);
    }

    private void deployllm(String projectCode, String llmPromptId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("project_name", projectCode);
        map.put("mode", "intent");
        this.assistantRhApiHelper.llmDeployer(map, llmPromptId, "prod", this.curTenantToken);
    }

    private void initExtraVariable() {
        Bson assistantFindFilterBson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"assistantCode", (Object)this.application), Filters.eq((String)"version", (Object)"1.0")});
        FindIterable assistantDoc = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection("assistant").find(assistantFindFilterBson);
        Document assistant = (Document)assistantDoc.first();
        if (assistant == null) {
            this.isCNaDeploy = true;
            this.betaAssistantCode = this.application + "_beta";
        } else {
            this.betaAssistantCode = this.application;
            this.assistatnSubType = assistant.getInteger((Object)"appSubType");
            if (ASSISTANT_SUB_TYPE_KNOWLEDGE.equals(this.assistatnSubType)) {
                this.isSkipTemplate = true;
                this.isSkipGPT = true;
            }
        }
    }

    private void switchCommercial2Abandon() {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(this.deployNo).setTime(new Date()).setContent("\u5c062.0\u5e94\u7528\u6570\u636e\u5e9f\u5f03..").setResult("start").setApplication(this.application);
        DeployEvent deployEvent = new DeployEvent((Object)this, this.parentThreadId, "process:" + JSON.toJSONString((Object)deployDetail));
        this.applicationContext.publishEvent((ApplicationEvent)deployEvent);
        try {
            Bson assistantFilterBson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"assistantCode", (Object)this.application), Filters.eq((String)"version", (Object)"2.0")});
            Document assistantUpdateBson = new Document("$set", (Object)new Document().append("version", (Object)ABANDON_VERSION));
            for (String colllectionName : (List)DB_COLLECTION.get(MONGODB_NAME_ASA)) {
                this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection(colllectionName).updateMany(assistantFilterBson, (Bson)assistantUpdateBson);
            }
            if (!this.isSkipTemplate) {
                Bson templateFilterBson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"application", (Object)this.application), Filters.eq((String)"version", (Object)"2.0")});
                Document templateUpdateBson = new Document("$set", (Object)new Document().append("version", (Object)ABANDON_VERSION));
                for (String colllectionName : (List)DB_COLLECTION.get("datamap")) {
                    this.kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(this.datamapDBName).getCollection(colllectionName).updateMany(templateFilterBson, (Bson)templateUpdateBson);
                }
                for (String colllectionName : (List)DB_COLLECTION.get("preset")) {
                    this.presetMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(this.presetDBName).getCollection(colllectionName).updateMany(templateFilterBson, (Bson)templateUpdateBson);
                }
                for (String colllectionName : (List)DB_COLLECTION.get("knowledgegraphSystem")) {
                    this.kgsysMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(this.kgsysDBName).getCollection(colllectionName).updateMany(templateFilterBson, (Bson)templateUpdateBson);
                }
                this.pageService.cleanPageDataFromKM(this.application, "2.0");
            }
            deployDetail.setResult("success");
        }
        catch (Exception e) {
            log.error("Update version 2.0 to 0.0 error. ", (Throwable)e);
            this.setFailDeployDetail(deployDetail, e, deployEvent);
            throw new BusinessException((Throwable)e);
        }
        finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    private void switchBeta2Publish() {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(this.deployNo).setTime(new Date()).setContent("\u66f4\u65b02.0\u5e94\u7528\u6570\u636e..").setResult("start").setApplication(this.application);
        DeployEvent deployEvent = new DeployEvent((Object)this, this.parentThreadId, "process:" + JSON.toJSONString((Object)deployDetail));
        this.applicationContext.publishEvent((ApplicationEvent)deployEvent);
        try {
            if (!this.isSkipTemplate) {
                Bson templateFilterBson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"application", (Object)this.application), Filters.eq((String)"version", (Object)"1.0")});
                Document templateUpdateBson = new Document("$set", (Object)new Document().append("version", (Object)"2.0"));
                for (Object colllectionName : (List)DB_COLLECTION.get("datamap")) {
                    this.kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(this.datamapDBName).getCollection((String)colllectionName).updateMany(templateFilterBson, (Bson)templateUpdateBson);
                }
                for (Object colllectionName : (List)DB_COLLECTION.get("preset")) {
                    this.presetMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(this.presetDBName).getCollection((String)colllectionName).updateMany(templateFilterBson, (Bson)templateUpdateBson);
                }
                for (Object colllectionName : (List)DB_COLLECTION.get("knowledgegraphSystem")) {
                    this.kgsysMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(this.kgsysDBName).getCollection((String)colllectionName).updateMany(templateFilterBson, (Bson)templateUpdateBson);
                }
                this.pageService.updatePageDataVersion(this.application, "1.0", "2.0");
            }
            Bson assistantFilterBson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"assistantCode", (Object)this.betaAssistantCode), Filters.eq((String)"version", (Object)"1.0")});
            String accId = this.imApiHelper.queryAccId(this.application, this.curTenantToken).getString("accid");
            Document assistantUpdateBson = new Document("$set", (Object)new Document().append("version", (Object)"2.0").append("assistantCode", (Object)this.application));
            for (String colllectionName : (List)DB_COLLECTION.get(MONGODB_NAME_ASA)) {
                if ("assistant".equals(colllectionName)) {
                    assistantUpdateBson = this.isCNaDeploy ? (this.aiProject != null ? new Document("$set", (Object)new Document().append("version", (Object)"2.0").append("assistantCode", (Object)this.application).append("accid", (Object)accId).append("aiProject.modelTag", (Object)"prod").append("tenantId", (Object)MONGODB_NAME_ASA)) : new Document("$set", (Object)new Document().append("version", (Object)"2.0").append("assistantCode", (Object)this.application).append("accid", (Object)accId).append("tenantId", (Object)MONGODB_NAME_ASA))) : (this.aiProject != null ? new Document("$set", (Object)new Document().append("version", (Object)"2.0").append("assistantCode", (Object)this.application).append("accid", (Object)accId).append("aiProject.modelTag", (Object)"prod")) : new Document("$set", (Object)new Document().append("version", (Object)"2.0").append("assistantCode", (Object)this.application).append("accid", (Object)accId)));
                }
                this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection(colllectionName).updateMany(assistantFilterBson, (Bson)assistantUpdateBson);
            }
            Bson assistantSceneFilterBson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"assistantCode", (Object)this.application), Filters.eq((String)"version", (Object)"2.0")});
            FindIterable assistantSceneDocs = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection("assistantScene").find(assistantSceneFilterBson);
            assistantSceneDocs.forEach(doc -> this.assistantSceneList.add(JSON.parseObject((String)JSON.toJSONString((Object)doc), JSONObject.class)));
            deployDetail.setResult("success");
        }
        catch (Exception e) {
            log.error("Update version 1.0 to 2.0 error. ", (Throwable)e);
            this.setFailDeployDetail(deployDetail, e, deployEvent);
            throw new BusinessException((Throwable)e);
        }
        finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    private void constructBetaFromPublish() {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(this.deployNo).setTime(new Date()).setContent("\u6062\u590d1.0\u5e94\u7528\u6570\u636e..").setResult("start").setApplication(this.application);
        DeployEvent deployEvent = new DeployEvent((Object)this, this.parentThreadId, "process:" + JSON.toJSONString((Object)deployDetail));
        this.applicationContext.publishEvent((ApplicationEvent)deployEvent);
        try {
            if (!this.isSkipTemplate) {
                FindIterable templateDoc;
                ArrayList tempalteDocList;
                Bson templateFilterBson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"application", (Object)this.application), Filters.eq((String)"version", (Object)"2.0")});
                for (String colllectionName : (List)DB_COLLECTION.get("datamap")) {
                    tempalteDocList = new ArrayList();
                    templateDoc = this.kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(this.datamapDBName).getCollection(colllectionName).find(templateFilterBson);
                    templateDoc.forEach(doc -> {
                        doc.remove((Object)"_id");
                        doc.put("version", (Object)"1.0");
                        tempalteDocList.add(doc);
                    });
                    if (tempalteDocList.isEmpty()) continue;
                    this.kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(this.datamapDBName).getCollection(colllectionName).insertMany(tempalteDocList);
                }
                for (String colllectionName : (List)DB_COLLECTION.get("preset")) {
                    tempalteDocList = new ArrayList();
                    templateDoc = this.presetMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(this.presetDBName).getCollection(colllectionName).find(templateFilterBson);
                    templateDoc.forEach(doc -> {
                        doc.remove((Object)"_id");
                        doc.put("version", (Object)"1.0");
                        tempalteDocList.add(doc);
                    });
                    if (tempalteDocList.isEmpty()) continue;
                    this.presetMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(this.presetDBName).getCollection(colllectionName).insertMany(tempalteDocList);
                }
                for (String colllectionName : (List)DB_COLLECTION.get("knowledgegraphSystem")) {
                    tempalteDocList = new ArrayList();
                    templateDoc = this.kgsysMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(this.kgsysDBName).getCollection(colllectionName).find(templateFilterBson);
                    templateDoc.forEach(doc -> {
                        doc.remove((Object)"_id");
                        doc.put("version", (Object)"1.0");
                        tempalteDocList.add(doc);
                    });
                    if (tempalteDocList.isEmpty()) continue;
                    this.kgsysMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(this.kgsysDBName).getCollection(colllectionName).insertMany(tempalteDocList);
                }
                this.pageService.createNewPageData(this.application, "2.0", "1.0");
            }
            Bson assistantFilterBson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"assistantCode", (Object)this.application), Filters.eq((String)"version", (Object)"2.0")});
            for (String colllectionName : (List)DB_COLLECTION.get(MONGODB_NAME_ASA)) {
                ArrayList assistantDocList = new ArrayList();
                FindIterable assistantDocs = this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection(colllectionName).find(assistantFilterBson);
                assistantDocs.forEach(doc -> {
                    doc.remove((Object)"_id");
                    doc.put("version", (Object)"1.0");
                    doc.put("assistantCode", (Object)this.betaAssistantCode);
                    if ("assistant".equalsIgnoreCase(colllectionName)) {
                        doc.put("tenantId", (Object)this.currentTenantId);
                        String accId = this.imApiHelper.queryAccId(this.betaAssistantCode, this.curTenantToken).getString("accid");
                        doc.put("accid", (Object)accId);
                    }
                    assistantDocList.add(doc);
                });
                if (assistantDocList.isEmpty()) continue;
                this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection(colllectionName).insertMany(assistantDocList);
            }
            deployDetail.setResult("success");
        }
        catch (Exception e) {
            log.error("Insert version 1.0 from 2.0 error. ", (Throwable)e);
            this.setFailDeployDetail(deployDetail, e, deployEvent);
            throw new BusinessException((Throwable)e);
        }
        finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    private void cleanAbandon() {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(this.deployNo).setTime(new Date()).setContent("\u6e05\u74060.0\u5e94\u7528\u6570\u636e..").setResult("start").setApplication(this.application);
        DeployEvent deployEvent = new DeployEvent((Object)this, this.parentThreadId, "process:" + JSON.toJSONString((Object)deployDetail));
        this.applicationContext.publishEvent((ApplicationEvent)deployEvent);
        try {
            Bson assistantFilterBson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"assistantCode", (Object)this.application), Filters.eq((String)"version", (Object)ABANDON_VERSION)});
            for (String colllectionName : (List)DB_COLLECTION.get(MONGODB_NAME_ASA)) {
                this.mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(MONGODB_NAME_ASA).getCollection(colllectionName).deleteMany(assistantFilterBson);
            }
            if (!this.isSkipTemplate) {
                Bson templateFilterBson = Filters.and((Bson[])new Bson[]{Filters.eq((String)"application", (Object)this.application), Filters.eq((String)"version", (Object)ABANDON_VERSION)});
                for (String colllectionName : (List)DB_COLLECTION.get("datamap")) {
                    this.kmMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(this.datamapDBName).getCollection(colllectionName).deleteMany(templateFilterBson);
                }
                for (String colllectionName : (List)DB_COLLECTION.get("preset")) {
                    this.presetMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(this.presetDBName).getCollection(colllectionName).deleteMany(templateFilterBson);
                }
                for (String colllectionName : (List)DB_COLLECTION.get("knowledgegraphSystem")) {
                    this.kgsysMongoTemplate.getMongoDatabaseFactory().getMongoDatabase(this.kgsysDBName).getCollection(colllectionName).deleteMany(templateFilterBson);
                }
            }
            deployDetail.setResult("success");
        }
        catch (Exception e) {
            log.error("Clean version 0.0 data error. ", (Throwable)e);
            this.setFailDeployDetail(deployDetail, e, deployEvent);
            throw new BusinessException((Throwable)e);
        }
        finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    protected void doAfterDataProcess() {
        DeployDetail deployDetail = new DeployDetail().setDeployNo(this.deployNo).setTime(new Date()).setContent("\u5904\u7406\u5173\u7cfb\u6570\u636e..").setResult("start").setApplication(this.application);
        DeployEvent deployEvent = new DeployEvent((Object)this, this.parentThreadId, "process:" + JSON.toJSONString((Object)deployDetail));
        this.applicationContext.publishEvent((ApplicationEvent)deployEvent);
        try {
            if (!this.isCNaDeploy) {
                Map tenantVersionMap = this.tenantService.getTenantVersion(this.tenantIdList);
                this.tenantService.createTenants(this.tenantIdList, "2.0");
                List authAppTenantIdList = this.tenantService.getAuthAppTenantIdList(this.application, "2.0", new ArrayList());
                this.tenantService.createRelation(this.application, "2.0", "2.0", authAppTenantIdList);
                this.tenantService.updateAppDataVersion(this.application, "1.0", "2.0", this.tenantIdList);
                this.tenantService.copyAppVersionData(this.application, "2.0", "1.0");
                List authAppTestTenantIdList = this.tenantService.getAuthAppTenantIdList(this.application, "1.0", this.tenantIdList);
                this.tenantService.createRelation(this.application, "1.0", "1.0", authAppTestTenantIdList);
                ArrayList<String> vChangeTenantIdList = new ArrayList<String>();
                for (String tenantId : this.tenantIdList) {
                    if (StringUtils.isEmpty((CharSequence)((CharSequence)tenantVersionMap.get(tenantId))) || "2.0".equals(tenantVersionMap.get(tenantId))) continue;
                    vChangeTenantIdList.add(tenantId);
                    Set appCodeList = this.tenantService.getNotCommonAppCodeRelaToTenantId(tenantId);
                    appCodeList.remove(this.application);
                    this.tenantService.createOneTenantAndMoreAppRelation(appCodeList, "2.0", "2.0", tenantId);
                }
                if (!vChangeTenantIdList.isEmpty()) {
                    this.tenantService.modifyTenantRelaWithNotMatchAppDataInPublish("2.0", "1.0", vChangeTenantIdList);
                }
            }
            deployDetail.setResult("success");
        }
        catch (Exception e) {
            log.error("Do after switch error. ", (Throwable)e);
            this.setFailDeployDetail(deployDetail, e, deployEvent);
            throw new BusinessException((Throwable)e);
        }
        finally {
            this.sendDeployDetailWithExeTime(deployDetail, deployEvent);
        }
    }

    protected void doProcess4ProdAndAuth() {
        if (!this.isCNaDeploy) {
            super.iamAuthorizationInSwitch((DeployParam)this.switchVersionParam);
        }
    }

    public SwitchVersionParam getSwitchVersionParam() {
        return this.switchVersionParam;
    }

    public String getBetaAssistantCode() {
        return this.betaAssistantCode;
    }

    public String getCurTenantToken() {
        return this.curTenantToken;
    }

    public JSONObject getAiProject() {
        return this.aiProject;
    }

    public void setSwitchVersionParam(SwitchVersionParam switchVersionParam) {
        this.switchVersionParam = switchVersionParam;
    }

    public void setBetaAssistantCode(String betaAssistantCode) {
        this.betaAssistantCode = betaAssistantCode;
    }

    public void setCurTenantToken(String curTenantToken) {
        this.curTenantToken = curTenantToken;
    }

    public void setAiProject(JSONObject aiProject) {
        this.aiProject = aiProject;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwitchVersionThread)) {
            return false;
        }
        SwitchVersionThread other = (SwitchVersionThread)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        SwitchVersionParam this$switchVersionParam = this.getSwitchVersionParam();
        SwitchVersionParam other$switchVersionParam = other.getSwitchVersionParam();
        if (this$switchVersionParam == null ? other$switchVersionParam != null : !this$switchVersionParam.equals(other$switchVersionParam)) {
            return false;
        }
        String this$betaAssistantCode = this.getBetaAssistantCode();
        String other$betaAssistantCode = other.getBetaAssistantCode();
        if (this$betaAssistantCode == null ? other$betaAssistantCode != null : !this$betaAssistantCode.equals(other$betaAssistantCode)) {
            return false;
        }
        String this$curTenantToken = this.getCurTenantToken();
        String other$curTenantToken = other.getCurTenantToken();
        if (this$curTenantToken == null ? other$curTenantToken != null : !this$curTenantToken.equals(other$curTenantToken)) {
            return false;
        }
        JSONObject this$aiProject = this.getAiProject();
        JSONObject other$aiProject = other.getAiProject();
        return !(this$aiProject == null ? other$aiProject != null : !this$aiProject.equals(other$aiProject));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SwitchVersionThread;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SwitchVersionParam $switchVersionParam = this.getSwitchVersionParam();
        result = result * 59 + ($switchVersionParam == null ? 43 : $switchVersionParam.hashCode());
        String $betaAssistantCode = this.getBetaAssistantCode();
        result = result * 59 + ($betaAssistantCode == null ? 43 : $betaAssistantCode.hashCode());
        String $curTenantToken = this.getCurTenantToken();
        result = result * 59 + ($curTenantToken == null ? 43 : $curTenantToken.hashCode());
        JSONObject $aiProject = this.getAiProject();
        result = result * 59 + ($aiProject == null ? 43 : $aiProject.hashCode());
        return result;
    }

    public String toString() {
        return "SwitchVersionThread(switchVersionParam=" + this.getSwitchVersionParam() + ", betaAssistantCode=" + this.getBetaAssistantCode() + ", curTenantToken=" + this.getCurTenantToken() + ", aiProject=" + this.getAiProject() + ")";
    }
}

