/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.km_deployer_service.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.IoUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.deploy.ApplicationData;
import com.digiwin.athena.deploy.ApplicationMongoData;
import com.digiwin.athena.deploy.BasicQuery;
import com.digiwin.athena.deploy.SortField;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.core.DataDescription;
import com.digiwin.athena.domain.core.DataState;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.kg.monitorRule.MonitorRule;
import com.digiwin.athena.km_deployer_service.constant.Constant;
import com.digiwin.athena.km_deployer_service.povo.CypherDto;
import com.digiwin.athena.km_deployer_service.povo.DapResponse;
import com.digiwin.athena.km_deployer_service.support.SkillParseContext;
import com.digiwin.athena.km_deployer_service.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    private static Logger logger = LoggerFactory.getLogger(Utils.class);
    static String db_datamap = "datamap";
    static String db_kg_sys = "knowledgegraphSystem";
    public static HttpClient httpclient = null;
    public static RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(60000).setMaxRedirects(50).build();

    @PostConstruct
    public void init() {
    }

    public static DapResponse request(String url, String httpMethod, Map<String, Object> params) {
        DapResponse result = new DapResponse();
        String json = Utils.requestString((String)url, (String)httpMethod, params);
        if (null != json) {
            result = (DapResponse)JSON.parseObject((String)json, DapResponse.class);
        }
        return result;
    }

    public static String requestString(String url, String httpMethod, Map<String, Object> params) {
        String result = null;
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            try {
                URL u = new URL(url);
                String kghost = u.getHost();
                headers.put("Host", kghost);
            }
            catch (MalformedURLException e) {
                logger.error("requestString error", (Throwable)e);
            }
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String routerKey = request.getHeader("routerKey");
            String token = request.getHeader("token");
            String locale = request.getHeader("locale");
            if (null != routerKey) {
                headers.put("routerKey", routerKey);
            }
            if (null != token) {
                headers.put("token", token);
                headers.put("digi-middleware-auth-user", token);
            }
            if (null != locale) {
                headers.put("locale", locale);
            }
            result = "post".equalsIgnoreCase(httpMethod) ? Utils.postJson((String)url, headers, params) : Utils.get((String)url, headers, params);
        }
        catch (Exception e) {
            logger.error("request to {} failed," + e.getMessage(), (Object)url);
        }
        return result;
    }

    private static Header[] toHeader(Map<String, String> headers) {
        if (null != headers) {
            ArrayList hs = new ArrayList();
            headers.forEach((k, v) -> hs.add(new BasicHeader(k, v)));
            return hs.toArray(new Header[0]);
        }
        return null;
    }

    public static String get(String url, Map<String, String> headers, Map<String, Object> params) {
        String result = null;
        HttpResponse response = Utils.get0((String)url, (Header[])Utils.toHeader(headers), params);
        HttpEntity entity = response.getEntity();
        try {
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (logger.isInfoEnabled()) {
                logger.info("get result=" + result);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
        return result;
    }

    public static HttpResponse get0(String url, Header[] headers, Map<String, Object> params) {
        if (null != params && !params.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("?");
            params.forEach((k, v) -> {
                try {
                    String sv = v.toString();
                    sb.append((String)k).append("=").append(URLEncoder.encode(sv, "UTF-8")).append("&");
                }
                catch (UnsupportedEncodingException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            });
            url = url + sb.substring(0, sb.length() - 1).toString();
        }
        HttpGet get = new HttpGet(url);
        get.setHeaders(headers);
        HttpResponse response = null;
        if (logger.isInfoEnabled()) {
            logger.info("get url=" + url + ",headers=" + JSON.toJSONString((Object)headers) + ",params=" + params);
        }
        try {
            response = Utils.getHttpClient().execute((HttpUriRequest)get);
            return response;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static <T> T get(String url, Map<String, String> headers, Map<String, Object> params, Class<T> c) {
        Object result = null;
        try {
            result = JSON.parseObject((String)Utils.get((String)url, headers, params), c);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postJson(String url, Map<String, String> headers, Map<String, Object> params) {
        String result = null;
        HttpPost httppost = new HttpPost(url);
        httppost.setConfig(requestConfig);
        httppost.setHeaders(Utils.toHeader(headers));
        String jsonbody = JSON.toJSONString(params);
        StringEntity myEntity = new StringEntity(jsonbody, ContentType.APPLICATION_JSON);
        httppost.setEntity((HttpEntity)myEntity);
        HttpResponse response = null;
        if (logger.isInfoEnabled()) {
            logger.info("post to:" + url + ",and request body=" + jsonbody + " and header=" + headers);
        }
        try {
            response = Utils.getHttpClient().execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            HttpClientUtils.closeQuietly((HttpResponse)response);
        }
        if (logger.isInfoEnabled()) {
            logger.info("response from :" + url + ",response body=" + result);
        }
        return result;
    }

    public static HttpClient getHttpClient() {
        if (null == httpclient) {
            SSLContext sslContext = null;
            try {
                sslContext = SSLContext.getInstance("TLS");
                1 tm = new /* Unavailable Anonymous Inner Class!! */;
                sslContext.init(null, new TrustManager[]{tm}, null);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            httpclient = HttpClients.custom().setMaxConnPerRoute(1000).setMaxConnTotal(1000).setSSLContext(sslContext).build();
        }
        return httpclient;
    }

    public static String uid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static <T> T objToClz(Object obj, Class<T> clz) {
        return (T)JSON.parseObject((String)JSON.toJSONString((Object)obj), clz);
    }

    public static <T> List<T> objToArray(Object obj, Class<T> clz) {
        return JSON.parseArray((String)JSON.toJSONString((Object)obj), clz);
    }

    public static Document objToDoc(Object obj) {
        return Document.parse((String)JSON.toJSONString((Object)obj));
    }

    public static ApplicationMongoData objToMongoData(Object obj, String db, String col) {
        ApplicationMongoData data = new ApplicationMongoData();
        data.getDocs().add(Utils.objToDoc((Object)obj));
        data.setDb(db);
        data.setCol(col);
        return data;
    }

    public static CypherDto objToCypher(Object obj, List<String> labels, String version) {
        CypherDto dto = new CypherDto();
        String nodeId = "node_" + Utils.uid();
        StringBuilder sb = new StringBuilder();
        JSONObject map = JSON.parseObject((String)JSON.toJSONString((Object)obj));
        sb.append("create (").append(nodeId).append("");
        for (String label : labels) {
            sb.append(":").append(label);
        }
        sb.append("{");
        map.forEach((k, v) -> {
            sb.append((String)k).append(":");
            if (v instanceof String) {
                sb.append("'").append(v).append("'");
            } else if (Utils.isPrimitive(obj.getClass())) {
                sb.append(v);
            } else {
                sb.append("'").append(JSON.toJSONString((Object)v)).append("'");
            }
            sb.append(",");
        });
        sb.append("version:'").append(version).append("'");
        sb.append("})");
        dto.setNodeId(nodeId);
        dto.setCypher(sb.toString());
        return dto;
    }

    public static boolean isPrimitive(Class<?> c) {
        return c != null && (c.isPrimitive() || Number.class.isAssignableFrom(c) || Boolean.class.equals(c));
    }

    public static String loadTemplate(String fileName) {
        try {
            String text = IoUtil.read((InputStream)Utils.class.getResource(fileName).openStream(), (String)"utf-8");
            return text;
        }
        catch (IOException e) {
            logger.error("load template error", (Throwable)e);
            return null;
        }
    }

    public static <T> T loadObject(String fileName, Class<T> c) {
        String text = Utils.loadTemplate((String)fileName);
        if (null != text) {
            return (T)JSON.parseObject((String)text, c);
        }
        return null;
    }

    public static <T> List<T> loadObjects(String fileName, Class<T> c) {
        String text = Utils.loadTemplate((String)fileName);
        if (null != text) {
            return JSON.parseArray((String)text, c);
        }
        return null;
    }

    public static void addObject(Object obj, SkillParseContext context, ApplicationData data) {
        if (null == obj) {
            return;
        }
        if (obj instanceof TenantObject) {
            TenantObject tenantObject = (TenantObject)obj;
            tenantObject.setTenantId("SYSTEM");
            tenantObject.setVersion(context.getVersion());
        }
        if (obj instanceof Project) {
            data.getMongoData().add(Utils.objToMongoData((Object)obj, (String)Constant.db_datamap, (String)"project"));
        }
        if (obj instanceof Task) {
            data.getMongoData().add(Utils.objToMongoData((Object)obj, (String)Constant.db_datamap, (String)"task"));
        } else if (obj instanceof PageView) {
            data.getMongoData().add(Utils.objToMongoData((Object)obj, (String)Constant.db_datamap, (String)"pageView"));
        } else if (obj instanceof FlowGraph) {
            data.getMongoData().add(Utils.objToMongoData((Object)obj, (String)Constant.db_datamap, (String)"flowGraph"));
        } else if (obj instanceof Activity) {
            data.getMongoData().add(Utils.objToMongoData((Object)obj, (String)Constant.db_datamap, (String)"activity"));
        } else if (obj instanceof DataDescription) {
            data.getMongoData().add(Utils.objToMongoData((Object)obj, (String)Constant.db_datamap, (String)"dataDescription"));
        } else if (obj instanceof DataState) {
            DataState lastState = (DataState)obj;
            data.getMongoData().add(Utils.objToMongoData((Object)obj, (String)Constant.db_datamap, (String)"dataState"));
        } else if (obj instanceof MonitorRule) {
            CypherDto dto = Utils.objToCypher((Object)obj, (List)ListUtil.of((Object[])new String[]{"MonitorRule"}), (String)context.getVersion());
            data.getCyphers().add(dto.getCypher());
        }
    }

    public static Query buildQuery(BasicQuery request) {
        Query query = new Query();
        if (null != request.getCondition()) {
            request.getCondition().forEach((k, v) -> {
                if (v instanceof Collection) {
                    Collection collection = (Collection)v;
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)k).in(collection));
                } else {
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)k).is(v));
                }
            });
        }
        if (null != request.getPage() && null != request.getPageSize()) {
            query.with((Pageable)PageRequest.of((int)request.getPage(), (int)request.getPageSize()));
        }
        if (CollectionUtil.isNotEmpty((Collection)request.getSortFields())) {
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
            for (SortField field : request.getSortFields()) {
                Sort.Direction direction = "desc".equalsIgnoreCase(field.getDirection()) ? Sort.Direction.DESC : Sort.Direction.ASC;
                Sort.Order order = new Sort.Order(direction, field.getField());
                orders.add(order);
            }
            query.with(Sort.by(orders));
        }
        if (CollectionUtil.isNotEmpty((Collection)request.getReturnFields())) {
            for (String field : request.getReturnFields()) {
                query.fields().include(field);
            }
        }
        return query;
    }

    public static void main(String[] args) {
        System.out.println(Utils.loadTemplate((String)"purchaseApproval/Task.json"));
    }
}

