#!/bin/sh
sed -i "s#@mongodb_database@#$mongodb_database#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@mongo_suffix@#$mongo_suffix#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@compile_dataPath@#$compile_dataPath#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@compile_zipPath@#$compile_zipPath#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@design_dataPath@#$design_dataPath#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@design_zipPath@#$design_zipPath#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@designer_domain@#$designer_domain#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@tenantDesigner_domain@#$tenantDesigner_domain#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@iam_domain@#$iam_domain#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@gmc_domain@#$gmc_domain#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@lcdp_domain@#$lcdp_domain#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@km_uri@#$km_uri#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@atmc_uri@#$atmc_uri#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@tbb_uri@#$tbb_uri#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@envMode@#envMode#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@abi_uri@#$abi_uri#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@mdc_uri@#$mdc_uri#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@sd_uri@#$sd_uri#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@appToken@#$appToken#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@dmc_url@#$dmc_url#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@dmc_appToken@#$dmc_appToken#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@dmc_username@#$dmc_username#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@dmc_pwdhash@#$dmc_pwdhash#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@dmc_bucket@#$dmc_bucket#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@pinpoint_appname@#$pinpoint_appname#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@pinpoint_id@#$pinpoint_id#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@collector_ip@#$collector_ip#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@lmc_endpoint@#$lmc_endpoint#g" /usr/local/km_deployer_service/logback.xml
sed -i "s#@apimgmt_uri@#$apimgmt_uri#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@esp_host@#$esp_host#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@app_privateKey@#$app_privateKey#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@app_publicKey@#$app_publicKey#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@app_ucMode@#$app_ucMode#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@app_ucSuffix@#$app_ucSuffix#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@asa_mongodb_database@#$asa_mongodb_database#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@datamap_mongodb_database@#$datamap_mongodb_database#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@preset_mongodb_database@#$preset_mongodb_database#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@kgsys_mongodb_database@#$kgsys_mongodb_database#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@kafka_middle_uri@#$kafka_middle_uri#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@im_uri@#$im_uri#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@designer_legwork_code@#$designer_legwork_code#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@customLegworkCode@#$customLegworkCode#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@bNa_uri@#$bNa_uri#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@dwloadBalanceEnable@#$dwloadBalanceEnable#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@dwdiscoveryServer@#$dwdiscoveryServer#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@dw_loadbalance_mode@#$dw_loadbalance_mode#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@esp_loadbalance_enable@#$esp_loadbalance_enable#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@ja_logback@#$ja_logback#g" /usr/local/km_deployer_service/application.yml
sed -i "s#@ja_check_server@#$ja_check_server#g" /usr/local/km_deployer_service/application.yml

#ops jvm 参数
mem_jvm_heap_mb=""
mem_jvm_heap=""

if [ -n "$ja_Xms" ]; then
  mem_jvm_heap=$ja_Xms
elif [ -n "$LIMITMEMORY" ]; then
  mem_jvm_heap=$(echo $LIMITMEMORY | sed 's/MB$//')
  if [ "$mem_jvm_heap" -le 2048 ]; then
      mem_jvm_heap=$((mem_jvm_heap / 2))
  elif [ "$mem_jvm_heap" -lt 4096 ]; then
    mem_jvm_heap=$((mem_jvm_heap - 1024))
  else
    mem_jvm_heap=$((mem_jvm_heap - 2048))
  fi
fi

echo "mem_jvm_heap : ${mem_jvm_heap}"

if [ -z "$mem_jvm_heap" ]; then
  echo "Error: $mem_jvm_heap not set!"
  exit 1
else
  mem_jvm_heap_mb="${mem_jvm_heap}m"
fi

jvm_gc=""
if [ -z "$ja_GC" ]; then
  if [ "$mem_jvm_heap" -ge 2048 ];then
    jvm_gc="G1GC"
  else
    jvm_gc="ParallelGC"
  fi
fi

path_base=`pwd`
echo "pwd : ${path_base}"
jar_name=`ls -t *.jar | grep -v 'sources' | head -1`
echo "jar : ${jar_name}"

opts_jvm=" -server"
opts_jvm="$opts_jvm -Duser.home=${path_base}"
opts_jvm="$opts_jvm -Djava.security.egd=file:/dev/./urandom"
#opts_jvm="$opts_jvm -Djava.net.preferIPv4Stack=true"
opts_jvm="$opts_jvm -Dfile.encoding=UTF-8"
opts_jvm="$opts_jvm -DJM.LOG.PATH=${path_base}/.logs/nacos"
#opts_jvm="$opts_jvm -Duser.timezone=UTC"
#opts_jvm="$opts_jvm -Dprogram.name=${PROGRAM_NAME}"
opts_jvm="$opts_jvm -Xms${ja_Xms:-$mem_jvm_heap_mb}"
opts_jvm="$opts_jvm -Xmx${ja_Xmx:-$mem_jvm_heap_mb}"
opts_jvm="$opts_jvm -Xss${ja_Xss:-256k}"
#opts_jvm="$opts_jvm -XX:MetaspaceSize=256m"
#opts_jvm="$opts_jvm -XX:MaxMetaspaceSize=256m"
#opts_jvm="$opts_jvm -XX:NewRatio=2"
opts_jvm="$opts_jvm -XX:+HeapDumpOnOutOfMemoryError"
opts_jvm="$opts_jvm -XX:+Use${ja_GC:-$jvm_gc}"
if [ "$jvm_gc" != "G1GC" ]; then
  opts_jvm="$opts_jvm -XX:NewRatio=1"
fi
opts_jvm="$opts_jvm -XX:+PrintGCDateStamps"
opts_jvm="$opts_jvm -XX:+PrintGCDetails"
opts_jvm="$opts_jvm -XX:-OmitStackTraceInFastThrow"
opts_jvm="$opts_jvm -XX:+UseGCLogFileRotation"
opts_jvm="$opts_jvm -XX:NumberOfGCLogFiles=10"
opts_jvm="$opts_jvm -XX:GCLogFileSize=100M"
opts_jvm="$opts_jvm -XX:HeapDumpPath=${path_base}/log"
opts_jvm="$opts_jvm -Xloggc:${path_base}/platform/log/gc.log"

if [ -n "$open_debug" ]; then
   opts_jvm="$opts_jvm -XX:NativeMemoryTracking=detail"
   opts_jvm="$opts_jvm -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=20019"
fi

echo "opts_jvm : ${opts_jvm}"
#ops jvm 参数

JACOCO_AGENT=
if [[ "$enable_jacoco" == "true" ]]; then
JACOCO_AGENT=-javaagent:${path_base}/jacoco/jacocoagent.jar=destfile=${path_base}/platform/jacoco/jacoco.exec,append=true,includes=com.digiwin.athena.km_deployer_service.*
fi
export JACOCO_AGENT



PINPOINT_APPLICATIONNAME_PREFIX=$(printenv "pinpoint.applicationName.prefix")
SPRING_APPLICATION_NAME=$(printenv "spring.application.name")

echo "PINPOINT_APPLICATIONNAME_PREFIX : ${PINPOINT_APPLICATIONNAME_PREFIX}"
echo "SPRING_APPLICATION_NAME : ${SPRING_APPLICATION_NAME}"
# 脚本内使用转换后的变量名
PINPOINT_PREFIX="${PINPOINT_APPLICATIONNAME_PREFIX:-unknown}"
SPRING_APP_NAME="${SPRING_APPLICATION_NAME:-unknown-application}"
# 组合成 AGENT_NAME（使用下划线连接更安全）
export AGENT_NAME="${PINPOINT_PREFIX}-${SPRING_APP_NAME}"
echo "Pinpoint Agent Name: $AGENT_NAME"

export AGENT_ID_SUFFIX=${HOSTNAME:0-5}
echo "AGENT_ID_SUFFIX : ${AGENT_ID_SUFFIX}"

AGENT_ID=${SPRING_APP_NAME}-$AGENT_ID_SUFFIX
echo "AGENT_ID : ${AGENT_ID}"



export AGENT_PATH=/agent_pinpoint/pinpoint-bootstrap.jar
#    export AGENT_NAME=$pinpoint_appname
#    export AGENT_ID=$pinpoint_id
if [ -n "$collector_ip" ]; then
    export AGENT_COLLECTOR="-Dprofiler.transport.grpc.collector.ip=$collector_ip"
fi

sed -i "s/profiler\.transport\.grpc\.collector\.ip=.*/profiler\.transport\.grpc\.collector\.ip=$collector_ip/g" /agent_pinpoint/profiles/release/pinpoint.config
sed -i "s/profiler\.collector\.ip=.*/profiler\.collector\.ip=$collector_ip/g" /agent_pinpoint/profiles/release/pinpoint.config
echo "collector_ip : ${collector_ip}"

export AGENT_MAIN="-Dprofiler.springboot.bootstrap.main=$MAINCLASS"
#  export jvmArgs="-XX:MetaspaceSize=100m -XX:+PrintHeapAtGC -Xms2048m -Xmx2048m  -XX:+HeapDumpOnOutOfMemoryError -XX:HeapDumpPath=/km_deployer_service/platform/log -XX:+PrintGCDateStamps -XX:+PrintGCDetails -Xloggc:/km_deployer_service/platform/log/gc.log -XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=10 -XX:GCLogFileSize=100M -XX:+UseParallelGC -XX:ParallelGCThreads=2"
export AGENT_OPTS="$JACOCO_AGENT -javaagent:$AGENT_PATH -Dpinpoint.agentId=$AGENT_ID -Dpinpoint.applicationName=$AGENT_NAME $AGENT_COLLECTOR $AGENT_MAIN"
 # export jvmArgs="-XX:MetaspaceSize=100m -XX:+PrintHeapAtGC -Xms2048m -Xmx2048m  -XX:+HeapDumpOnOutOfMemoryError -XX:HeapDumpPath=/km_deployer_service/platform/log -XX:+PrintGCDateStamps -XX:+PrintGCDetails -Xloggc:/km_deployer_service/platform/log/gc.log -XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=10 -XX:GCLogFileSize=100M -XX:+UseParallelGC -XX:ParallelGCThreads=2"
echo debug: `grep profiler.springboot.bootstrap.main /agent_pinpoint/profiles/release/pinpoint.config`
chmod 777 /usr/local/km_deployer_service/agent_pinpoint
if [[ "$enable_jacoco" == "true" ]]; then
mkdir -p km_deployer_service-classes
chmod 777 /usr/local/km_deployer_service/km_deployer_service-classes
unzip -o km_deployer_service-1.0.0.jar -d km_deployer_service-classes
fi
java $AGENT_OPTS ${opts_jvm} -jar -Dlogging.config=./logback.xml km_deployer_service-1.0.0.jar

