/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.service.history.impl;

import com.digiwin.athena.sccommon.pojo.model.WorkflowNodeDetailModel;
import com.digiwin.athena.sccommon.pojo.model.WorkflowNodeSummaryModel;
import com.digiwin.athena.sccommon.service.history.IHistoryService;
import com.digiwin.athena.sccommon.service.history.IWorkflowInfoProvider;
import com.digiwin.athena.sccommon.service.history.IWorkflowNodeInfoProvider;
import com.digiwin.athena.sccommon.service.history.impl.CadenceWorkflowInfoProvider;
import com.digiwin.athena.sccommon.service.history.impl.WorkflowNodeInfoProvider;
import com.digiwin.athena.sccommon.service.mongo.IWorkflowNodeDetailPersistenceService;
import com.digiwin.athena.sccommon.service.mongo.IWorkflowNodeSummaryPersistenceService;
import com.uber.cadence.internal.sync.WorkflowInternal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="historyService")
public class HistoryService
implements IHistoryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HistoryService.class);
    private static final String LOOP_ID_PARAM_NAME = "loopId";
    private static final String LOOP_NUM_PARAM_NAME = "loopNum";
    private static final String NEXT_LOOP_INFO_PARAM_NAME = "nextLoopInfo";
    private IWorkflowNodeSummaryPersistenceService workflowNodeSummaryPersistenceService;
    private IWorkflowNodeDetailPersistenceService workflowNodeDetailPersistenceService;

    public HistoryService(IWorkflowNodeSummaryPersistenceService workflowNodeSummaryPersistenceService, IWorkflowNodeDetailPersistenceService workflowNodeDetailPersistenceService) {
        this.workflowNodeSummaryPersistenceService = workflowNodeSummaryPersistenceService;
        this.workflowNodeDetailPersistenceService = workflowNodeDetailPersistenceService;
    }

    @Override
    public String addLoopInfo(Map<String, Object> param, String loopId, int loopNum) {
        if (param.containsKey("scLoopInfo")) {
            Map<String, Object> loopInfo = (Map<String, Object>)param.get("scLoopInfo");
            loopInfo = this.addLoopInfoInner(loopInfo, loopId, loopNum);
            param.put("scLoopInfo", loopInfo);
        } else {
            HashMap<String, Object> loopInfo = new HashMap<String, Object>();
            loopInfo.put(LOOP_ID_PARAM_NAME, loopId);
            loopInfo.put(LOOP_NUM_PARAM_NAME, loopNum);
            param.put("scLoopInfo", loopInfo);
        }
        return UUID.randomUUID().toString();
    }

    private Map<String, Object> addLoopInfoInner(Map<String, Object> loopInfo, String loopId, int loopNum) {
        String currentLoopId = (String)loopInfo.get(LOOP_ID_PARAM_NAME);
        if (currentLoopId.equals(loopId)) {
            loopInfo.put(LOOP_NUM_PARAM_NAME, loopNum);
        } else if (loopInfo.containsKey(NEXT_LOOP_INFO_PARAM_NAME)) {
            Map<String, Object> nextLoopInfo = (Map<String, Object>)loopInfo.get(NEXT_LOOP_INFO_PARAM_NAME);
            nextLoopInfo = this.addLoopInfoInner(nextLoopInfo, loopId, loopNum);
            loopInfo.put(NEXT_LOOP_INFO_PARAM_NAME, nextLoopInfo);
        } else {
            HashMap<String, Object> nextLoopInfo = new HashMap<String, Object>();
            nextLoopInfo.put(LOOP_ID_PARAM_NAME, loopId);
            nextLoopInfo.put(LOOP_NUM_PARAM_NAME, loopNum);
            loopInfo.put(NEXT_LOOP_INFO_PARAM_NAME, nextLoopInfo);
        }
        return loopInfo;
    }

    @Override
    public String removeLoopInfo(Map<String, Object> param, String loopId) {
        if (param.containsKey("scLoopInfo")) {
            Map<String, Object> loopInfo = (Map<String, Object>)param.get("scLoopInfo");
            if ((loopInfo = this.removeLoopInfoInner(loopInfo, loopId)) == null) {
                param.remove("scLoopInfo");
            } else {
                param.put("scLoopInfo", loopInfo);
            }
        }
        return UUID.randomUUID().toString();
    }

    private Map<String, Object> removeLoopInfoInner(Map<String, Object> loopInfo, String loopId) {
        String currentLoopId = (String)loopInfo.get(LOOP_ID_PARAM_NAME);
        if (currentLoopId.equals(loopId)) {
            return null;
        }
        Map<String, Object> nextLoopInfo = (Map<String, Object>)loopInfo.get(NEXT_LOOP_INFO_PARAM_NAME);
        if ((nextLoopInfo = this.removeLoopInfoInner(nextLoopInfo, loopId)) == null) {
            loopInfo.remove(NEXT_LOOP_INFO_PARAM_NAME);
        } else {
            loopInfo.put(NEXT_LOOP_INFO_PARAM_NAME, nextLoopInfo);
        }
        return loopInfo;
    }

    @Override
    public String logWorkflowExecutionLink(Map<String, Object> param, String nodeId, String from, String to) {
        String type = "WorkflowExecutionLink";
        String name = "Workflow execution link";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("from", from);
        summary.put("to", to);
        return this.log(param, nodeId, type, name, summary, null);
    }

    @Override
    public String logWorkflowExecutionDecision(Map<String, Object> param, String nodeId, String from, String to, String caseExpression) {
        String type = "WorkflowExecutionDecision";
        String name = "Workflow execution decision";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("from", from);
        summary.put("to", to);
        summary.put("caseExpression", caseExpression);
        return this.log(param, nodeId, type, name, summary, null);
    }

    @Override
    public String logWorkflowExecutionForkStarted(Map<String, Object> param, String nodeId) {
        String type = "WorkflowExecutionForkStarted";
        String name = "Workflow execution fork started";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        return this.log(param, nodeId, type, name, summary, null);
    }

    @Override
    public String logWorkflowExecutionForkCompleted(Map<String, Object> param, String nodeId) {
        String type = "WorkflowExecutionForkCompleted";
        String name = "Workflow execution fork completed";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        return this.log(param, nodeId, type, name, summary, null);
    }

    @Override
    public String logWorkflowExecutionTimerStarted(Map<String, Object> param, String nodeId, int duration) {
        String type = "WorkflowExecutionTimerStarted";
        String name = "Workflow execution timer started";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("duration", duration);
        return this.log(param, nodeId, type, name, summary, null);
    }

    @Override
    public String logWorkflowExecutionTimerCompleted(Map<String, Object> param, String nodeId, int duration) {
        String type = "WorkflowExecutionTimerCompleted";
        String name = "Workflow execution timer completed";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("duration", duration);
        return this.log(param, nodeId, type, name, summary, null);
    }

    @Override
    public String logWorkflowExecutionBatchStarted(Map<String, Object> param, String nodeId, String loopVarName, String loopResultVarName, List loopData) {
        String type = "WorkflowExecutionBatchStarted";
        String name = "Workflow execution batch started";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("loopVarName", loopVarName);
        summary.put("loopResultVarName", loopResultVarName);
        summary.put("loopCount", loopData.size());
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("loopData", loopData);
        return this.log(param, nodeId, type, name, summary, detail);
    }

    @Override
    public String logWorkflowExecutionBatchCompleted(Map<String, Object> param, String nodeId, List loopResultData) {
        String type = "WorkflowExecutionBatchCompleted";
        String name = "Workflow execution batch completed";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("loopResultData", loopResultData);
        return this.log(param, nodeId, type, name, summary, detail);
    }

    @Override
    public String logActivityStarted(Map<String, Object> param, String nodeId) {
        String type = "ActivityStarted";
        String name = "Activity started";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        return this.log(param, nodeId, type, name, summary, null);
    }

    @Override
    public String logActivityCompleted(Map<String, Object> param, String nodeId) {
        String type = "ActivityCompleted";
        String name = "Activity completed";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        return this.log(param, nodeId, type, name, summary, null);
    }

    @Override
    public String logActivityStarted(Map<String, Object> param, String nodeId, String activityType, String script) {
        String type = "ActivityStarted";
        String name = "Activity started";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("type", activityType);
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("type", activityType);
        detail.put("script", script);
        return this.log(param, nodeId, type, name, summary, detail);
    }

    @Override
    public String logActivityCompleted(Map<String, Object> param, String nodeId, String activityType, String output) {
        String type = "ActivityCompleted";
        String name = "Activity completed";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("type", activityType);
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("type", activityType);
        detail.put("output", output);
        return this.log(param, nodeId, type, name, summary, detail);
    }

    @Override
    public String logActivityTimedOut(Map<String, Object> param, String nodeId, String activityType, int timeoutSeconds) {
        String type = "ActivityTimedOut";
        String name = "Activity timed out";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("type", activityType + "-main");
        summary.put("timeoutSeconds", timeoutSeconds);
        return this.log(param, nodeId, type, name, summary, null);
    }

    @Override
    public String logActivityFailed(Map<String, Object> param, String nodeId, String activityType, String script, String errorMessage) {
        String type = "ActivityFailed";
        String name = "Activity failed";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("type", activityType + "-main");
        summary.put("script", script);
        summary.put("errorMessage", errorMessage);
        return this.log(param, nodeId, type, name, summary, null);
    }

    @Override
    public String logActivityPreStarted(Map<String, Object> param, String nodeId, String activityType, String script) {
        String type = "ActivityStarted";
        String name = "Activity started";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("type", activityType);
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("type", activityType);
        detail.put("script", script);
        return this.log(param, nodeId, nodeId + "-pre", type, name, summary, detail);
    }

    @Override
    public String logActivityPreCompleted(Map<String, Object> param, String nodeId, String activityType, String output) {
        String type = "ActivityCompleted";
        String name = "Activity completed";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("type", activityType);
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("type", activityType);
        detail.put("output", output);
        return this.log(param, nodeId, nodeId + "-pre", type, name, summary, detail);
    }

    @Override
    public String logActivityPreFailed(Map<String, Object> param, String nodeId, String activityType, String script, String errorMessage) {
        String type = "ActivityFailed";
        String name = "Activity failed";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("type", activityType + "-pre");
        summary.put("script", script);
        summary.put("errorMessage", errorMessage);
        return this.log(param, nodeId, type, name, summary, null);
    }

    @Override
    public String logActivityPreTimedOut(Map<String, Object> param, String nodeId, String activityType, int timeoutSeconds) {
        String type = "ActivityTimedOut";
        String name = "Activity timed out";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("type", activityType + "-pre");
        summary.put("timeoutSeconds", timeoutSeconds);
        return this.log(param, nodeId, type, name, summary, null);
    }

    @Override
    public String logActivityPostStarted(Map<String, Object> param, String nodeId, String activityType, String script) {
        String type = "ActivityStarted";
        String name = "Activity started";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("type", activityType);
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("type", activityType);
        detail.put("script", script);
        return this.log(param, nodeId, nodeId + "-post", type, name, summary, detail);
    }

    @Override
    public String logActivityPostCompleted(Map<String, Object> param, String nodeId, String activityType, String output) {
        String type = "ActivityCompleted";
        String name = "Activity completed";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("type", activityType);
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("type", activityType);
        detail.put("output", output);
        return this.log(param, nodeId, nodeId + "-post", type, name, summary, detail);
    }

    @Override
    public String logActivityPostFailed(Map<String, Object> param, String nodeId, String activityType, String script, String errorMessage) {
        String type = "ActivityFailed";
        String name = "Activity failed";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("type", activityType + "-post");
        summary.put("script", script);
        summary.put("errorMessage", errorMessage);
        return this.log(param, nodeId, type, name, summary, null);
    }

    @Override
    public String logActivityPostTimedOut(Map<String, Object> param, String nodeId, String activityType, int timeoutSeconds) {
        String type = "ActivityTimedOut";
        String name = "Activity timed out";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("type", activityType + "-post");
        summary.put("timeoutSeconds", timeoutSeconds);
        return this.log(param, nodeId, type, name, summary, null);
    }

    @Override
    public String logActivityMainStarted(Map<String, Object> param, String nodeId, String activityType, String uri, String method, Map<String, String> headers, String body) {
        String type = "ActivityStarted";
        String name = "Activity started";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("type", activityType);
        summary.put("uri", uri);
        summary.put("method", method);
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("type", activityType);
        detail.put("headers", headers);
        detail.put("body", body);
        return this.log(param, nodeId, nodeId + "-main", type, name, summary, detail);
    }

    @Override
    public String logActivityMainStarted(Map<String, Object> param, String nodeId, String activityType, String invokeType, String serviceProd, String serviceName, Map<String, String> headers, String body) {
        String type = "ActivityStarted";
        String name = "Activity started";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("type", activityType);
        summary.put("invokeType", invokeType);
        summary.put("serviceProd", serviceProd);
        summary.put("serviceName", serviceName);
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("type", activityType);
        detail.put("headers", headers);
        detail.put("body", body);
        return this.log(param, nodeId, nodeId + "-main", type, name, summary, detail);
    }

    @Override
    public String logActivityMainStarted(Map<String, Object> param, String nodeId, String activityType, String templateId, Map<String, Object> childParam) {
        String type = "ActivityStarted";
        String name = "Activity started";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("type", activityType);
        summary.put("templateId", templateId);
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("type", activityType);
        detail.put("param", childParam);
        return this.log(param, nodeId, nodeId + "-main", type, name, summary, detail);
    }

    @Override
    public String logActivityMainCompleted(Map<String, Object> param, String nodeId, String activityType, Map<String, String> headers, String body) {
        String type = "ActivityCompleted";
        String name = "Activity completed";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("type", activityType);
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("type", activityType);
        detail.put("headers", headers);
        detail.put("body", body);
        return this.log(param, nodeId, nodeId + "-main", type, name, summary, detail);
    }

    @Override
    public String logActivityMainCompleted(Map<String, Object> param, String nodeId, String activityType, String reqId, Map<String, Object> headers, String body) {
        String type = "ActivityCompleted";
        String name = "Activity completed";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("type", activityType);
        summary.put("reqId", reqId);
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("type", activityType);
        detail.put("headers", headers);
        detail.put("body", body);
        return this.log(param, nodeId, nodeId + "-main", type, name, summary, detail);
    }

    @Override
    public String logActivityMainPending(Map<String, Object> param, String nodeId, String activityType, String reqId, Map<String, Object> headers, String body) {
        String type = "ActivityPending";
        String name = "Activity pending";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("type", activityType);
        summary.put("reqId", reqId);
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("type", activityType);
        detail.put("headers", headers);
        detail.put("body", body);
        return this.log(param, nodeId, nodeId + "-main", type, name, summary, detail);
    }

    @Override
    public String logActivityMainSignaled(Map<String, Object> param, String nodeId, String activityType, String reqId, Map<String, String> headers, String body) {
        String type = "ActivitySignaled";
        String name = "Activity signaled";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("type", activityType);
        summary.put("reqId", reqId);
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("type", activityType);
        detail.put("headers", headers);
        detail.put("body", body);
        return this.log(param, nodeId, nodeId + "-main", type, name, summary, detail);
    }

    @Override
    public String logActivityMainCompleted(Map<String, Object> param, String nodeId, String activityType, Map<String, Object> response) {
        String type = "ActivityCompleted";
        String name = "Activity completed";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("type", activityType);
        HashMap<String, Object> detail = new HashMap<String, Object>();
        detail.put("type", activityType);
        detail.put("response", response);
        return this.log(param, nodeId, nodeId + "-main", type, name, summary, detail);
    }

    @Override
    public String logActivityMainFailed(Map<String, Object> param, String nodeId, String activityType, Map<String, Object> errorInfo) {
        String type = "ActivityFailed";
        String name = "Activity failed";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("type", activityType + "-main");
        summary.putAll(errorInfo);
        return this.log(param, nodeId, type, name, summary, null);
    }

    @Override
    public String logActivityMainTimedOut(Map<String, Object> param, String nodeId, String activityType, int timeoutSeconds) {
        String type = "ActivityTimedOut";
        String name = "Activity timed out";
        HashMap<String, Object> summary = new HashMap<String, Object>();
        summary.put("type", activityType + "-main");
        summary.put("timeoutSeconds", timeoutSeconds);
        return this.log(param, nodeId, type, name, summary, null);
    }

    @Override
    public String log(Map<String, Object> param, String nodeId, String type, String name, Map<String, Object> summary, Map<String, Object> detail) {
        return this.log(param, nodeId, type, name, LocalDateTime.now(), summary, detail);
    }

    @Override
    public String log(Map<String, Object> param, String groupId, String nodeId, String type, String name, Map<String, Object> summary, Map<String, Object> detail) {
        return this.log(param, groupId, nodeId, type, name, LocalDateTime.now(), summary, detail);
    }

    @Override
    public String log(Map<String, Object> param, String nodeId, String type, String name, LocalDateTime startTime, Map<String, Object> summary, Map<String, Object> detail) {
        if (!this.isActivityRunningOrWorkflowRunningInNotReplaying()) {
            WorkflowNodeInfoProvider workflowNodeInfoProvider = new WorkflowNodeInfoProvider(nodeId, type, name, (Map)param.get("scLoopInfo"), startTime, summary, detail);
            this.log(CadenceWorkflowInfoProvider.getInstance(), workflowNodeInfoProvider);
        }
        return UUID.randomUUID().toString();
    }

    @Override
    public String log(Map<String, Object> param, String groupId, String nodeId, String type, String name, LocalDateTime startTime, Map<String, Object> summary, Map<String, Object> detail) {
        if (!this.isActivityRunningOrWorkflowRunningInNotReplaying()) {
            WorkflowNodeInfoProvider workflowNodeInfoProvider = new WorkflowNodeInfoProvider(groupId, nodeId, type, name, (Map)param.get("scLoopInfo"), startTime, summary, detail);
            this.log(CadenceWorkflowInfoProvider.getInstance(), workflowNodeInfoProvider);
        }
        return UUID.randomUUID().toString();
    }

    @Override
    public boolean log(IWorkflowInfoProvider workflowInfoProvider, IWorkflowNodeInfoProvider workflowNodeInfoProvider) {
        boolean result = true;
        WorkflowNodeSummaryModel workflowNodeSummary = new WorkflowNodeSummaryModel(workflowInfoProvider.getWid(), workflowInfoProvider.getRid(), workflowNodeInfoProvider.getNodeId(), workflowNodeInfoProvider.getGroupId(), workflowNodeInfoProvider.getType(), workflowNodeInfoProvider.getTimestamp(), workflowNodeInfoProvider.getName(), workflowNodeInfoProvider.getLoopInfo(), workflowNodeInfoProvider.getSummary());
        this.workflowNodeSummaryPersistenceService.save(workflowNodeSummary);
        if (workflowNodeInfoProvider.getDetail() != null) {
            WorkflowNodeDetailModel workflowNodeDetailModel = new WorkflowNodeDetailModel(workflowInfoProvider.getWid(), workflowInfoProvider.getRid(), workflowNodeInfoProvider.getNodeId(), workflowNodeInfoProvider.getGroupId(), workflowNodeInfoProvider.getType(), workflowNodeInfoProvider.getTimestamp(), workflowNodeInfoProvider.getName(), workflowNodeInfoProvider.getLoopInfo(), workflowNodeInfoProvider.getDetail());
            this.workflowNodeDetailPersistenceService.save(workflowNodeDetailModel);
        }
        return result;
    }

    private boolean isActivityRunningOrWorkflowRunningInNotReplaying() {
        boolean result;
        block2: {
            result = false;
            try {
                result = WorkflowInternal.isReplaying();
            }
            catch (Error nonWorkflowError) {
                if (nonWorkflowError.getMessage().indexOf("Called from non workflow") <= -1) break block2;
                result = false;
            }
        }
        return result;
    }
}

