/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.template;

import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.athena.sccommon.cache.ILargeObjectCacheService;
import com.digiwin.athena.sccommon.cache.IWorkflowCacheService;
import com.digiwin.athena.sccommon.client.CustomHttpClient;
import com.digiwin.athena.sccommon.constant.ConfigConstant;
import com.digiwin.athena.sccommon.constant.InstanceStatusEnum;
import com.digiwin.athena.sccommon.service.history.IHistoryService;
import com.digiwin.athena.sccommon.template.AbstractSCTemplate;
import com.digiwin.athena.sccommon.template.IExceptionHandler;
import com.digiwin.athena.sccommon.template.ISCGenericTemplate;
import com.digiwin.athena.sccommon.template.ISCTemplateProvider;
import com.digiwin.athena.sccommon.util.JsonUtil;
import com.digiwin.athena.sccommon.util.SCContextUtil;
import com.digiwin.athena.sccommon.util.TemplateExecutionCounter;
import com.uber.cadence.workflow.Functions;
import com.uber.cadence.workflow.Workflow;
import com.uber.cadence.workflow.WorkflowInfo;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpMethod;

public class SCGenericTemplate
implements ISCGenericTemplate {
    protected ISCTemplateProvider templateProvider = SCContextUtil.getBean("templateProvider", ISCTemplateProvider.class);
    protected IExceptionHandler exceptionHandler = SCContextUtil.getBean("exceptionHandler", IExceptionHandler.class);
    protected IHistoryService historyService = SCContextUtil.getBean("historyService", IHistoryService.class);

    @Override
    public Object execute(Map<String, Object> param) {
        if (ConfigConstant.TEMPLATE_EXECUTION_COUNTER_ENABLED) {
            Workflow.sideEffect(String.class, (Functions.Func & Serializable)() -> TemplateExecutionCounter.recordExecution());
        }
        Map<String, Object> result = null;
        Map workflowModel = (Map)param.get("scWorkflowModelContext");
        if (workflowModel != null) {
            this.saveWorkflowModel(workflowModel);
            if (param.containsKey("scLog")) {
                this.historyService.log(param, "WES", "WorkflowExecutionStarted", "Workflow execution start", LocalDateTime.now(), null, (Map<String, Object>)MapUtils.getMap((Map)workflowModel, (Object)"requestParams"));
            }
        }
        if (param.containsKey("scTaskList") && param.get("scTaskList") != null) {
            String scTaskList = (String)param.get("scTaskList");
            AbstractSCTemplate template = this.templateProvider.getTemplate(scTaskList, "scGlobalTenant$dapGeneric$0", false);
            String queueName = MapUtils.getString(param, (Object)"sc_async_callback_queue");
            try {
                result = this.getTemplateResult(template.process(param));
            }
            catch (Exception exception) {
                if (StringUtils.isNotBlank((CharSequence)queueName)) {
                    this.exceptionHandler.handle(exception, param);
                }
                throw exception;
            }
            if (param.containsKey("returnHeaders")) {
                result.put("returnHeaders", param.get("returnHeaders"));
            }
            if (StringUtils.isNotBlank((CharSequence)queueName)) {
                this.postResultToInvoker(queueName, param, result);
            }
        }
        if (param.containsKey("scLog")) {
            this.historyService.log(param, "WEC", "WorkflowExecutionCompleted", "Workflow execution completed", LocalDateTime.now(), null, result);
        }
        result = this.storeData(result);
        return result;
    }

    @Override
    public void callback(Map<String, Object> result) {
        String scTaskList;
        if (result.containsKey("scTaskList") && result.get("scTaskList") != null && !(scTaskList = (String)result.get("scTaskList")).trim().isEmpty()) {
            AbstractSCTemplate template = this.templateProvider.getTemplate(scTaskList, "scGlobalTenant$dapGeneric$0", false);
            template.getCallbackMap().put(MapUtils.getString(result, (Object)"digi-reqid"), result);
        }
    }

    protected Map<String, Object> getTemplateResult(Object obj) {
        WorkflowInfo workflowInfo = Workflow.getWorkflowInfo();
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("wid", workflowInfo.getWorkflowId());
        result.put("rid", workflowInfo.getRunId());
        result.put("output", obj);
        return result;
    }

    protected Object restoreData(Object data) {
        ILargeObjectCacheService largeObjectCacheService = SCContextUtil.getBean("largeObjectCacheService", ILargeObjectCacheService.class);
        if (data instanceof String) {
            String restoreString = largeObjectCacheService.restore((String)data);
            return JsonUtil.parse(restoreString);
        }
        if (data instanceof Map) {
            Map rawMap = (Map)data;
            return rawMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                Object value = entry.getValue();
                if (value instanceof String) {
                    return JsonUtil.parse(largeObjectCacheService.restore((String)value));
                }
                return value;
            }));
        }
        return data;
    }

    private void postResultToInvoker(String queueName, Map<String, Object> param, Map<String, Object> result) {
        CustomHttpClient httpClient = (CustomHttpClient)SpringContextUtils.getContext().getBean(CustomHttpClient.class);
        HashMap<String, Object> httpRequestParams = new HashMap<String, Object>(4);
        httpRequestParams.put("exchange", "");
        httpRequestParams.put("routingKey", queueName);
        httpRequestParams.put("message", result);
        httpClient.invoke(ConfigConstant.POST_SC_WORKER_MQ_URL, HttpMethod.POST, MapUtils.getString(param, (Object)"token"), MapUtils.getString(param, (Object)"tenantId"), httpRequestParams, null);
    }

    private void saveWorkflowModel(Map<String, Object> workflowModel) {
        IWorkflowCacheService workflowCacheService = SCContextUtil.getBean("workflowCacheService", IWorkflowCacheService.class);
        WorkflowInfo workflowInfo = Workflow.getWorkflowInfo();
        workflowModel.put("wid", workflowInfo.getWorkflowId());
        workflowModel.put("rid", workflowInfo.getRunId());
        workflowModel.put("status", InstanceStatusEnum.OPEN.getValue());
        LocalDateTime startTime = LocalDateTime.now();
        workflowModel.put("startTime", startTime);
        workflowCacheService.insert(workflowModel);
    }

    private Map<String, Object> storeData(Map<String, Object> data) {
        Object output = data.get("output");
        if (output != null) {
            ILargeObjectCacheService largeObjectCacheService = SCContextUtil.getBean("largeObjectCacheService", ILargeObjectCacheService.class);
            if (output instanceof String) {
                String storeString = largeObjectCacheService.store((String)output);
                data.put("output", storeString);
            } else if (output instanceof Map) {
                Map rawMap = (Map)output;
                HashMap newMap = new HashMap(rawMap.size());
                rawMap.forEach((key, value) -> newMap.put(key, largeObjectCacheService.convertObjectV2(value)));
                data.put("output", newMap);
            }
        }
        return data;
    }
}

