/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.pojo.bo;

import com.digiwin.athena.sccommon.activity.IEspInvokerActivity;
import com.digiwin.athena.sccommon.activity.IHttpInvokerActivity;
import com.digiwin.athena.sccommon.activity.IScriptHandlerActivity;
import com.digiwin.athena.sccommon.constant.ConfigConstant;
import com.uber.cadence.activity.ActivityOptions;
import com.uber.cadence.activity.LocalActivityOptions;
import com.uber.cadence.workflow.Workflow;
import java.time.Duration;

public class DefaultActivityBO {
    private String taskList;
    private IHttpInvokerActivity httpInvokerActivity;
    private IEspInvokerActivity espInvokerActivity;
    private IScriptHandlerActivity scriptHandlerActivity;
    private boolean haveForkTask = false;

    public DefaultActivityBO(String taskList) {
    }

    public void setTaskList(String taskList) {
        this.taskList = taskList;
    }

    public String getTaskList() {
        return this.taskList;
    }

    public void setHaveForkTask(boolean haveForkTask) {
        this.haveForkTask = haveForkTask;
    }

    public boolean getHaveForkTask() {
        return this.haveForkTask;
    }

    public IHttpInvokerActivity getHttpInvokerActivity() {
        return (IHttpInvokerActivity)Workflow.newActivityStub(IHttpInvokerActivity.class, (ActivityOptions)new ActivityOptions.Builder().setScheduleToCloseTimeout(Duration.ofSeconds(300L)).setTaskList(this.taskList).build());
    }

    public IEspInvokerActivity getEspInvokerActivity() {
        return (IEspInvokerActivity)Workflow.newActivityStub(IEspInvokerActivity.class, (ActivityOptions)new ActivityOptions.Builder().setScheduleToCloseTimeout(Duration.ofSeconds(300L)).setTaskList(this.taskList).build());
    }

    public IScriptHandlerActivity getScriptHandlerActivity() {
        if (!this.haveForkTask) {
            return (IScriptHandlerActivity)Workflow.newLocalActivityStub(IScriptHandlerActivity.class, (LocalActivityOptions)new LocalActivityOptions.Builder().setScheduleToCloseTimeout(Duration.ofSeconds(ConfigConstant.SC_COMMON_SCRIPT_TASK_TIMEOUT)).build());
        }
        ActivityOptions.Builder activityOptionsBuilder = new ActivityOptions.Builder();
        activityOptionsBuilder.setScheduleToCloseTimeout(Duration.ofSeconds(ConfigConstant.SC_COMMON_SCRIPT_TASK_TIMEOUT)).setTaskList(this.taskList);
        return (IScriptHandlerActivity)Workflow.newActivityStub(IScriptHandlerActivity.class, (ActivityOptions)activityOptionsBuilder.build());
    }
}

