/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.service.mongo.impl;

import com.digiwin.athena.sccommon.dao.LargeObjectDao;
import com.digiwin.athena.sccommon.pojo.bo.PageBO;
import com.digiwin.athena.sccommon.pojo.model.LargeObjectModel;
import com.digiwin.athena.sccommon.service.mongo.AbstractService;
import com.digiwin.athena.sccommon.service.mongo.ILargeObjectPersistenceService;
import com.mongodb.client.result.DeleteResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class LargeObjectPersistenceServiceImpl
extends AbstractService<LargeObjectDao, LargeObjectModel>
implements ILargeObjectPersistenceService {
    @Autowired
    private MongoTemplate template;

    @Override
    public long deleteExpiredData(LargeObjectModel largeObjectModel, PageBO pageBO) {
        long deleteCounts = 0L;
        for (int pageNumber = 1; pageNumber <= pageBO.getTotalPage(); ++pageNumber) {
            Criteria criteria = new Criteria();
            criteria.and("createTime").lte((Object)largeObjectModel.getCreateTime());
            Query query = new Query((CriteriaDefinition)criteria);
            PageRequest pageable = PageRequest.of((int)0, (int)pageBO.getPageSize());
            query.with((Pageable)pageable);
            query.with(new Sort(Sort.Direction.ASC, new String[]{"createTime"}));
            DeleteResult deleteResult = this.template.remove(query, LargeObjectModel.class);
            deleteCounts += deleteResult.getDeletedCount();
            if (deleteResult.getDeletedCount() == 0L) break;
        }
        return deleteCounts;
    }

    @Override
    public LargeObjectModel queryValue(String reference) {
        Criteria criteria = new Criteria();
        criteria.and("reference").is((Object)reference);
        return (LargeObjectModel)this.template.findOne(new Query((CriteriaDefinition)criteria), LargeObjectModel.class);
    }
}

