/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.config;

import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCHttpServiceUnavailableRetryStrategy
implements ServiceUnavailableRetryStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCHttpServiceUnavailableRetryStrategy.class);
    private int retryTimes;
    private int retryIntervalMilliSecond;
    private int[] retryStatus;
    private List<Integer> httpClientRetryHttpStatus;

    public SCHttpServiceUnavailableRetryStrategy(int retryTimes, int retryIntervalMilliSecond, List<Integer> httpClientRetryHttpStatus) {
        this.retryTimes = retryTimes;
        this.retryIntervalMilliSecond = retryIntervalMilliSecond;
        this.httpClientRetryHttpStatus = httpClientRetryHttpStatus;
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        if (executionCount > this.retryTimes) {
            return false;
        }
        if (executionCount <= this.retryTimes && response.getStatusLine() != null && this.httpClientRetryHttpStatus.contains(response.getStatusLine().getStatusCode())) {
            try {
                Thread.sleep(this.retryIntervalMilliSecond);
            }
            catch (InterruptedException e) {
                LOGGER.error("SCHttpServiceUnavailableRetryStrategy interrupted exception", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    public long getRetryInterval() {
        return this.retryIntervalMilliSecond;
    }
}

