/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.service.template.impl;

import com.digiwin.athena.sccommon.constant.ConfigConstant;
import com.digiwin.athena.sccommon.constant.ErrorCodeEnum;
import com.digiwin.athena.sccommon.constant.InstanceStatusEnum;
import com.digiwin.athena.sccommon.dto.WorkFlowQueryDto;
import com.digiwin.athena.sccommon.exception.ScTemplateInstanceException;
import com.digiwin.athena.sccommon.pojo.model.WorkFlowModel;
import com.digiwin.athena.sccommon.service.template.ITemplateInstanceCommomService;
import com.digiwin.athena.sccommon.service.workflow.IWorkFlowService;
import com.uber.cadence.DescribeWorkflowExecutionRequest;
import com.uber.cadence.DescribeWorkflowExecutionResponse;
import com.uber.cadence.EntityNotExistsError;
import com.uber.cadence.WorkflowExecution;
import com.uber.cadence.WorkflowExecutionCloseStatus;
import com.uber.cadence.client.WorkflowClient;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class TemplateInstanceCommomServiceImpl
implements ITemplateInstanceCommomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateInstanceCommomServiceImpl.class);
    @Autowired
    private IWorkFlowService workFlowService;

    @Override
    public boolean isExistsRunning(String tenantId, String serviceComposerId, Map<String, Object> eocMap, WorkflowClient client) {
        WorkFlowQueryDto workFlowQueryDto = new WorkFlowQueryDto();
        workFlowQueryDto.setPageSize(200);
        workFlowQueryDto.setTenantId(tenantId);
        workFlowQueryDto.setTemplateId(serviceComposerId);
        workFlowQueryDto.setEocCompanyId(MapUtils.getString(eocMap, (Object)"eoc_company_id"));
        workFlowQueryDto.setEocSiteId(MapUtils.getString(eocMap, (Object)"eoc_site_id"));
        workFlowQueryDto.setEocRegionId(MapUtils.getString(eocMap, (Object)"eoc_region_id"));
        workFlowQueryDto.setStatus(InstanceStatusEnum.OPEN.getValue());
        try {
            Page<WorkFlowModel> workFlowModels = this.workFlowService.queryWorkFlowModels(workFlowQueryDto);
            if (workFlowModels.getTotalElements() == 0L) {
                LOGGER.info("\u6ca1\u6709\u67e5\u5230\u6a21\u677f\u5b9e\u4f8b,tenantId={},serviceComposerId={},eocMap={}", new Object[]{tenantId, serviceComposerId, eocMap});
                return false;
            }
            if (this.isExistsRunning(workFlowModels, null, client)) {
                return true;
            }
            long page = workFlowModels.getTotalPages();
            if (page == 1L) {
                return false;
            }
            int i = 2;
            while ((long)i <= page) {
                workFlowQueryDto.setPageNo(i);
                workFlowModels = this.workFlowService.queryWorkFlowModels(workFlowQueryDto);
                if (this.isExistsRunning(workFlowModels, null, client)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.error("ITemplateInstanceCommomService.isExistsRunning error", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isExistsRunning(String tenantId, String templateId, String taskList, WorkflowClient client) {
        WorkFlowQueryDto workFlowQueryDto = new WorkFlowQueryDto();
        workFlowQueryDto.setPageSize(200);
        workFlowQueryDto.setTenantId(tenantId);
        workFlowQueryDto.setTemplateId(templateId);
        workFlowQueryDto.setStatus(InstanceStatusEnum.OPEN.getValue());
        Page<WorkFlowModel> workFlowModels = this.workFlowService.queryWorkFlowModels(workFlowQueryDto);
        if (workFlowModels.getTotalElements() == 0L) {
            return false;
        }
        if (this.isExistsRunning(workFlowModels, taskList, client)) {
            return true;
        }
        long page = workFlowModels.getTotalPages();
        if (page == 1L) {
            return false;
        }
        int i = 2;
        while ((long)i <= page) {
            workFlowQueryDto.setPageNo(i);
            workFlowModels = this.workFlowService.queryWorkFlowModels(workFlowQueryDto);
            if (this.isExistsRunning(workFlowModels, taskList, client)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isExistsRunning(Page<WorkFlowModel> workFlowModels, String taskList, WorkflowClient client) {
        Optional<WorkFlowModel> workFlowModelOptional = workFlowModels.stream().filter(workFlowModel -> {
            String wid = workFlowModel.getWid();
            String rid = workFlowModel.getRid();
            if (StringUtils.isBlank((CharSequence)wid)) {
                LOGGER.info("\u67e5\u8be2\u7684\u5b9e\u4f8b\u7684wid\u4e3a\u7a7a");
                return false;
            }
            try {
                return this.isOpening(ConfigConstant.DEFAULT_DOMAIN, wid, rid, taskList, client);
            }
            catch (EntityNotExistsError e) {
                LOGGER.warn("\u67e5\u8be2\u7684\u5b9e\u4f8b\u4e0d\u5b58\u5728: wid={},rid={}", (Object)wid, (Object)rid);
                return false;
            }
            catch (TException e) {
                LOGGER.error("\u67e5\u8be2\u670d\u52a1\u7f16\u6392\u5b9e\u4f8b\u662f\u5426\u5173\u95ed\u72b6\u6001\u5931\u8d25", (Throwable)e);
                throw new ScTemplateInstanceException(ErrorCodeEnum.INSTANCE_QUERY_ERROR, "\u67e5\u8be2\u670d\u52a1\u7f16\u6392\u5b9e\u4f8b\u662f\u5426\u5173\u95ed\u72b6\u6001\u5931\u8d25", wid, rid, e.getCause());
            }
        }).findAny();
        return workFlowModelOptional.isPresent();
    }

    private boolean isOpening(String domain, String wid, String rid, String taskList, WorkflowClient client) throws TException {
        DescribeWorkflowExecutionRequest describeWorkflowExecutionRequest = new DescribeWorkflowExecutionRequest();
        describeWorkflowExecutionRequest.setDomain(domain);
        describeWorkflowExecutionRequest.setExecution(new WorkflowExecution().setWorkflowId(wid).setRunId(rid));
        DescribeWorkflowExecutionResponse response = client.getService().DescribeWorkflowExecution(describeWorkflowExecutionRequest);
        WorkflowExecutionCloseStatus closeStatus = response.getWorkflowExecutionInfo().getCloseStatus();
        if (taskList != null) {
            return closeStatus == null && response.getWorkflowExecutionInfo().getTaskList().equals(taskList);
        }
        return closeStatus == null;
    }
}

