/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.util;

import com.alibaba.fastjson.JSONException;
import com.digiwin.athena.sccommon.constant.CustomErrorCode;
import com.digiwin.athena.sccommon.exception.BusinessException;
import com.digiwin.athena.sccommon.exception.EspActivityException;
import com.digiwin.athena.sccommon.exception.HttpActivityException;
import com.digiwin.athena.sccommon.exception.JsActivityException;
import com.digiwin.athena.sccommon.util.JsonUtil;
import com.digiwin.loadbalance.util.HttpRouteUtils;
import com.uber.cadence.client.WorkflowException;
import com.uber.cadence.workflow.ChildWorkflowFailureException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class ErrorMessageUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorMessageUtil.class);
    private static final Pattern errorCodePattern = Pattern.compile("\\\\\"errorCode\\\\\"\\s*:\\s*\\\\\"(\\w+\\.\\w+\\.\\w+\\.\\w+)\\\\\"");
    private static final Pattern errorMessagePattern = Pattern.compile("\\\\\"errorMessage\\\\\"\\s*:\\s*\\\\\"([^\"]*)\\\\\"");

    public static String extractErrorCode(String content) {
        Matcher errorCodeMatcher = errorCodePattern.matcher(content);
        String errorCode = errorCodeMatcher.find() ? errorCodeMatcher.group(1) : null;
        return errorCode == null ? null : errorCode.trim();
    }

    public static String extractErrorMessage(String content) {
        Matcher errorMessageMatcher = errorMessagePattern.matcher(content);
        String errorMessage = errorMessageMatcher.find() ? errorMessageMatcher.group(1) : null;
        return errorMessage == null ? null : errorMessage.trim();
    }

    public static CustomErrorCode extract(String content) {
        String errorCode = ErrorMessageUtil.extractErrorCode(content);
        String errorMessage = ErrorMessageUtil.extractErrorMessage(content);
        return StringUtils.hasText((String)errorCode) ? new CustomErrorCode(errorCode, errorMessage) : null;
    }

    private static CustomErrorCode extractInner(String workflowExceptionApplicationCode, Throwable actualCauseThrowable) {
        String errorCode;
        String errorCode2;
        block38: {
            if (actualCauseThrowable == null) {
                return null;
            }
            if (actualCauseThrowable instanceof EspActivityException) {
                EspActivityException espActivityException = (EspActivityException)actualCauseThrowable;
                String message = espActivityException.getMessage();
                try {
                    Map stdData;
                    Map espMessage = JsonUtil.getObject(message, Map.class);
                    if (espMessage.containsKey("std_data") && (stdData = (Map)espMessage.get("std_data")).containsKey("execution")) {
                        Map execution = (Map)stdData.get("execution");
                        String code = (String)execution.get("code");
                        if ("-1".equals(code)) {
                            code = espActivityException.getServiceProd() == null ? "P." + workflowExceptionApplicationCode + ".9999.9999" : "P." + espActivityException.getServiceProd() + ".9999.9999";
                        }
                        String description = (String)execution.get("description");
                        if (HttpRouteUtils.INSTANCE_NOT_FOUND_ERROR_CODE.equals(code)) {
                            String hostName = description.substring(HttpRouteUtils.INSTANCE_NOT_FOUND_ERROR_MESSAGE.length());
                            code = "P." + hostName + ".9999.9999";
                        }
                        if (HttpRouteUtils.STATEMODE_INSTANCE_NOT_FOUND_ERROR_CODE.equals(code)) {
                            String serviceId = description.substring(HttpRouteUtils.STATEMODE_INSTANCE_NOT_FOUND_ERROR_MESSAGE.length());
                            code = "P." + serviceId + ".9999.9999";
                        }
                        return StringUtils.hasText((String)code) ? new CustomErrorCode(code, description) : null;
                    }
                    if (!espMessage.containsKey("bodyJsonString")) break block38;
                    String bodyJsonStringString = (String)espMessage.get("bodyJsonString");
                    try {
                        Map stdData2;
                        Map bodyJsonStringMap = JsonUtil.getObject(bodyJsonStringString, Map.class);
                        if (bodyJsonStringMap.containsKey("std_data") && (stdData2 = (Map)bodyJsonStringMap.get("std_data")).containsKey("execution")) {
                            Map execution = (Map)stdData2.get("execution");
                            String code = (String)execution.get("code");
                            if ("-1".equals(code)) {
                                code = espActivityException.getServiceProd() == null ? "P." + workflowExceptionApplicationCode + ".9999.9999" : "P." + espActivityException.getServiceProd() + ".9999.9999";
                            }
                            String description = (String)execution.get("description");
                            if (HttpRouteUtils.INSTANCE_NOT_FOUND_ERROR_CODE.equals(code)) {
                                String hostName = description.substring(HttpRouteUtils.INSTANCE_NOT_FOUND_ERROR_MESSAGE.length());
                                code = "P." + hostName + ".9999.9999";
                            }
                            if (HttpRouteUtils.STATEMODE_INSTANCE_NOT_FOUND_ERROR_CODE.equals(code)) {
                                String serviceId = description.substring(HttpRouteUtils.STATEMODE_INSTANCE_NOT_FOUND_ERROR_MESSAGE.length());
                                code = "P." + serviceId + ".9999.9999";
                            }
                            return StringUtils.hasText((String)code) ? new CustomErrorCode(code, description) : null;
                        }
                    }
                    catch (Exception bodyJsonStringMap) {
                        // empty catch block
                    }
                    if (StringUtils.hasText((String)workflowExceptionApplicationCode)) {
                        errorCode2 = "P." + workflowExceptionApplicationCode + ".9999.9999";
                        return new CustomErrorCode(errorCode2, bodyJsonStringString);
                    }
                }
                catch (JSONException exception) {
                    return null;
                }
                catch (Exception exception) {
                    LOGGER.error("ErrorMessageUtil extract exception:" + exception.getMessage());
                    return null;
                }
            }
        }
        if (actualCauseThrowable instanceof HttpActivityException) {
            HttpActivityException httpActivityException = (HttpActivityException)actualCauseThrowable;
            String responseBody = httpActivityException.getResponseBody();
            try {
                String errorMessage;
                String errorCode3;
                int httpStatus;
                if (StringUtils.hasText((String)workflowExceptionApplicationCode) && ErrorMessageUtil.isErrorHttpStatus(httpStatus = httpActivityException.getHttpStatus())) {
                    errorCode3 = "P." + workflowExceptionApplicationCode + ".9999.9999";
                    errorMessage = httpActivityException.getMessage();
                    return new CustomErrorCode(errorCode3, errorMessage);
                }
                Map responseBodyMap = JsonUtil.getObject(responseBody, Map.class);
                if (responseBodyMap.containsKey("errorCode")) {
                    errorCode3 = "";
                    errorMessage = "";
                    errorCode3 = (String)responseBodyMap.get("errorCode");
                    if (responseBodyMap.containsKey("errorMessage")) {
                        errorMessage = (String)responseBodyMap.get("errorMessage");
                    }
                    if (HttpRouteUtils.INSTANCE_NOT_FOUND_ERROR_CODE.equals(errorCode3)) {
                        String hostName = errorMessage.substring(HttpRouteUtils.INSTANCE_NOT_FOUND_ERROR_MESSAGE.length());
                        errorCode3 = "P." + hostName + ".9999.9999";
                    }
                    if (HttpRouteUtils.STATEMODE_INSTANCE_NOT_FOUND_ERROR_CODE.equals(errorCode3)) {
                        String serviceId = errorMessage.substring(HttpRouteUtils.STATEMODE_INSTANCE_NOT_FOUND_ERROR_MESSAGE.length());
                        errorCode3 = "P." + serviceId + ".9999.9999";
                    }
                    return StringUtils.hasText((String)errorCode3) ? new CustomErrorCode(errorCode3, errorMessage) : null;
                }
                if (responseBodyMap.containsKey("response")) {
                    if (responseBodyMap.get("response") instanceof Map) {
                        Map response = (Map)responseBodyMap.get("response");
                        errorCode2 = "";
                        String errorMessage2 = "";
                        if (response.containsKey("errorCode")) {
                            errorCode2 = (String)response.get("errorCode");
                        }
                        if (response.containsKey("errorMessage")) {
                            errorMessage2 = (String)response.get("errorMessage");
                        }
                        return StringUtils.hasText((String)errorCode2) ? new CustomErrorCode(errorCode2, errorMessage2) : null;
                    }
                    if (StringUtils.hasText((String)workflowExceptionApplicationCode)) {
                        errorCode3 = "P." + workflowExceptionApplicationCode + ".9999.9999";
                        errorMessage = (String)responseBodyMap.get("response");
                        return new CustomErrorCode(errorCode3, errorMessage);
                    }
                }
            }
            catch (JSONException exception) {
                return null;
            }
            catch (Exception exception) {
                LOGGER.error("ErrorMessageUtil extract exception:" + exception.getMessage());
                return null;
            }
        }
        if (actualCauseThrowable instanceof JsActivityException) {
            try {
                if (StringUtils.hasText((String)workflowExceptionApplicationCode)) {
                    JsActivityException jsActivityException = (JsActivityException)actualCauseThrowable;
                    String jsErrorMessage = jsActivityException.getMessage();
                    errorCode = "P." + workflowExceptionApplicationCode + ".9999.9999";
                    return new CustomErrorCode(errorCode, jsErrorMessage);
                }
            }
            catch (Exception exception) {
                LOGGER.error("ErrorMessageUtil extract exception:" + exception.getMessage());
                return null;
            }
        }
        if (actualCauseThrowable instanceof BusinessException) {
            try {
                if (StringUtils.hasText((String)workflowExceptionApplicationCode)) {
                    BusinessException businessException = (BusinessException)actualCauseThrowable;
                    String businessExceptionMessage = businessException.getMessage();
                    errorCode = "P." + workflowExceptionApplicationCode + ".9999.9999";
                    return new CustomErrorCode(errorCode, businessExceptionMessage);
                }
            }
            catch (Exception exception) {
                LOGGER.error("ErrorMessageUtil extract exception:" + exception.getMessage());
                return null;
            }
        }
        return null;
    }

    public static CustomErrorCode extract(String workflowExceptionApplicationCode, Exception exception) {
        Throwable actualCauseThrowable;
        if (exception instanceof WorkflowException) {
            WorkflowException workflowException = (WorkflowException)exception;
            if (workflowException.getCause() instanceof ChildWorkflowFailureException) {
                ChildWorkflowFailureException childWorkflowFailureException = (ChildWorkflowFailureException)workflowException.getCause();
                actualCauseThrowable = childWorkflowFailureException.getCause();
            } else {
                actualCauseThrowable = workflowException.getCause();
            }
        } else {
            actualCauseThrowable = exception;
        }
        return ErrorMessageUtil.extractInner(workflowExceptionApplicationCode, actualCauseThrowable);
    }

    public static boolean isErrorHttpStatus(int httpStatus) {
        int[] errorHttpStatues;
        for (int errorHttpStatus : errorHttpStatues = new int[]{404, 413, 503, 504}) {
            if (errorHttpStatus != httpStatus) continue;
            return true;
        }
        return false;
    }
}

