/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.config;

import com.digiwin.athena.sccommon.util.HttpUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTemplateConfig {
    @Value(value="${httpClientMaxTotal:200}")
    private int maxTotal;
    @Value(value="${httpClientMaxPerRoute:100}")
    private int maxPerRoute;
    @Value(value="${httpClientRequestTimeOutMilliSecond:15000}")
    private int requestTimeOutMilliSecond;
    @Value(value="${httpClientConnectTimeOutMilliSecond:15000}")
    private int connectTimeOutMilliSecond;
    @Value(value="${httpClientSocketTimeOutMilliSecond:15000}")
    private int socketTimeOutMilliSecond;

    @Bean
    public RestTemplate restTemplate() {
        return new RestTemplate(this.httpRequestFactory());
    }

    @Bean
    public ClientHttpRequestFactory httpRequestFactory() {
        return new HttpComponentsClientHttpRequestFactory(HttpUtil.createHttpClient(this.maxTotal, this.maxPerRoute, this.socketTimeOutMilliSecond, this.connectTimeOutMilliSecond, this.requestTimeOutMilliSecond));
    }
}

