/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.cache.impl;

import com.digiwin.athena.sccommon.cache.ICacheService;
import com.digiwin.athena.sccommon.cache.ILargeObjectCacheService;
import com.digiwin.athena.sccommon.constant.ConfigConstant;
import com.digiwin.athena.sccommon.util.PlaceholderUtil;
import java.util.UUID;
import org.springframework.stereotype.Service;

@Service(value="largeObjectCacheService")
public class LargeObjectCacheServiceImpl
implements ILargeObjectCacheService {
    private static final String KEY_PREFIX = "SC_BIG_DATA_";
    private static final String TEMPLATE_PLACEHOLDER = "$(%s)";
    private static final long TIME_OUT_SECONDS = (long)(ConfigConstant.RETENTION_PERIOD_IN_DAYS * 24 * 60) * 60L;
    private ICacheService cacheService;

    public LargeObjectCacheServiceImpl(ICacheService cacheService) {
        this.cacheService = cacheService;
    }

    @Override
    public String store(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() > ConfigConstant.LARGE_OBJECT_SIZE_THRESHOLD) {
            String cacheKey = KEY_PREFIX + UUID.randomUUID().toString().replace("-", "").toLowerCase();
            this.cacheService.set(cacheKey, (Object)value, TIME_OUT_SECONDS);
            return String.format(TEMPLATE_PLACEHOLDER, cacheKey);
        }
        return value;
    }

    @Override
    public String restore(String key) {
        if (key == null) {
            return null;
        }
        if (key.startsWith("$(SC_BIG_DATA_")) {
            return (String)this.cacheService.get(PlaceholderUtil.extractPlaceholderKey(key));
        }
        return key;
    }
}

