/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookupFactory;

public final class PlaceholderUtil {
    private static final String DEFAULT_REGEX = "\\$\\((?<key>.+?)\\)";

    private PlaceholderUtil() {
    }

    public static Set<String> extractPlaceholderKeys(String propertyString) {
        return PlaceholderUtil.extractPlaceholderKeys(propertyString, DEFAULT_REGEX);
    }

    public static Set<String> extractPlaceholderKeys(String propertyString, String regex) {
        HashSet<String> placeholderKeys = new HashSet<String>();
        Matcher matcher = Pattern.compile(regex).matcher(propertyString);
        while (matcher.find()) {
            placeholderKeys.add(matcher.group("key"));
        }
        return placeholderKeys;
    }

    public static String extractPlaceholderKey(String propertyString) {
        return PlaceholderUtil.extractPlaceholderKey(propertyString, DEFAULT_REGEX);
    }

    public static String extractPlaceholderKey(String propertyString, String regex) {
        if (StringUtils.isBlank((CharSequence)propertyString)) {
            return "";
        }
        Matcher matcher = Pattern.compile(regex).matcher(propertyString);
        return matcher.find() ? matcher.group("key") : "";
    }

    private static boolean isNotContainPlaceholder(String content) {
        return StringUtils.isBlank((CharSequence)PlaceholderUtil.extractPlaceholderKey(content));
    }

    public static String replaceWithDynamicVariable(String initialString, Map<String, Object> param) {
        if (PlaceholderUtil.isNotContainPlaceholder(initialString)) {
            return initialString;
        }
        StringSubstitutor stringSubstitutor = new StringSubstitutor(param, "$(", ")");
        String firstReplaceResult = stringSubstitutor.replace(initialString);
        if (PlaceholderUtil.isNotContainPlaceholder(firstReplaceResult)) {
            return firstReplaceResult;
        }
        Map configMap = MapUtils.getMap(param, (Object)"scConfigVariable", (Map)MapUtils.EMPTY_MAP);
        stringSubstitutor.setVariableResolver(StringLookupFactory.INSTANCE.mapStringLookup(configMap));
        return stringSubstitutor.replace(firstReplaceResult);
    }
}

