/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.cache.impl;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.athena.sccommon.cache.ILargeObjectCacheService;
import com.digiwin.athena.sccommon.constant.ConfigConstant;
import com.digiwin.athena.sccommon.pojo.model.LargeObjectModel;
import com.digiwin.athena.sccommon.service.mongo.ILargeObjectPersistenceService;
import com.digiwin.athena.sccommon.util.JsonUtil;
import com.digiwin.athena.sccommon.util.PlaceholderUtil;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.data.domain.Example;
import org.springframework.stereotype.Service;

@Service(value="largeObjectCacheService")
public class LargeObjectCacheServiceImpl
implements ILargeObjectCacheService {
    private static final String KEY_PREFIX = "SC_BD_";
    private static final String TEMPLATE_PLACEHOLDER = "$(%s)";
    private ILargeObjectPersistenceService largeObjectPersistenceService;

    public LargeObjectCacheServiceImpl(ILargeObjectPersistenceService largeObjectPersistenceService) {
        this.largeObjectPersistenceService = largeObjectPersistenceService;
    }

    @Override
    public String store(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() > ConfigConstant.LARGE_OBJECT_SIZE_THRESHOLD) {
            String cacheKey = KEY_PREFIX + UUID.randomUUID().toString().replace("-", "").toLowerCase();
            LargeObjectModel largeObjectModel = new LargeObjectModel();
            largeObjectModel.setReference(cacheKey);
            largeObjectModel.setValue(value);
            largeObjectModel.setCreateTime(LocalDateTime.now());
            this.largeObjectPersistenceService.save(largeObjectModel);
            return String.format(TEMPLATE_PLACEHOLDER, cacheKey);
        }
        return value;
    }

    @Override
    public String restore(String value) {
        if (value == null) {
            return null;
        }
        if (value.startsWith("$(SC_BD_")) {
            LargeObjectModel largeObjectModel = new LargeObjectModel();
            largeObjectModel.setReference(PlaceholderUtil.extractPlaceholderKey(value));
            LargeObjectModel largeObjectData = (LargeObjectModel)this.largeObjectPersistenceService.selectOneByCondition(Example.of((Object)largeObjectModel));
            return this.restore(largeObjectData.getValue());
        }
        return value;
    }

    @Override
    public Object convertObject(Object value) {
        String valueString = null;
        if (value instanceof Map || value instanceof List) {
            valueString = JsonUtil.getJsonString(value, SerializerFeature.WriteMapNullValue);
        } else if (value instanceof String) {
            valueString = (String)value;
        }
        if (valueString != null) {
            return this.store(valueString);
        }
        return value;
    }
}

