/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.aop;

import com.digiwin.athena.sccommon.config.ErrorMessageConfig;
import com.digiwin.athena.sccommon.constant.IErrorCodeEnum;
import com.digiwin.athena.sccommon.constant.UndefinedErrorCode;
import com.digiwin.athena.sccommon.context.ErrorMessageContext;
import com.digiwin.athena.sccommon.exception.ScException;
import com.digiwin.athena.sccommon.mq.ErrorMessageSender;
import com.digiwin.athena.sccommon.pojo.bo.ErrorMessageDTO;
import java.util.List;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Aspect
@EnableAspectJAutoProxy
@Component
public class ErrorMessageAspect {
    private static final Logger log = LoggerFactory.getLogger(ErrorMessageAspect.class);
    @Autowired
    private ErrorMessageSender errorMessageSender;
    @Autowired
    private ErrorMessageConfig errorMessageConfig;

    @Pointcut(value="@annotation(com.digiwin.athena.sccommon.aop.ErrorMessage)")
    public void annotationPointcut() {
    }

    @AfterReturning(value="annotationPointcut()")
    public void sendAfter() {
        try {
            ErrorMessageDTO errorMessageDTO = this.getContextData();
            this.sendContextExceptions(errorMessageDTO);
        }
        finally {
            ErrorMessageContext.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterThrowing(pointcut="annotationPointcut()", throwing="e")
    public void sendAfterThrowing(Exception e) {
        try {
            ScException se;
            ErrorMessageDTO errorMessageDTO = this.getContextData();
            if (e instanceof ScException) {
                se = (ScException)((Object)e);
            } else {
                UndefinedErrorCode undefinedErrorCode = UndefinedErrorCode.getInstance(this.errorMessageConfig.getAppId());
                se = new ScException((IErrorCodeEnum)undefinedErrorCode, e.getCause());
            }
            this.errorMessageSender.send(se, errorMessageDTO);
            this.sendContextExceptions(errorMessageDTO);
        }
        finally {
            ErrorMessageContext.clean();
        }
    }

    private ErrorMessageDTO getContextData() {
        ErrorMessageDTO errorMessageDTO = ErrorMessageContext.getData();
        if (errorMessageDTO == null) {
            log.warn("\u9700\u8981\u5728\u76ee\u6807\u65b9\u6cd5\u629b\u51fa\u5f02\u5e38\u524d\u8c03\u7528 ErrorMessageContext.setter() \u8bbe\u7f6e\u544a\u8b66\u5e73\u53f0\u9700\u8981\u7684\u57fa\u672c\u4fe1\u606f");
            errorMessageDTO = new ErrorMessageDTO();
        }
        return errorMessageDTO;
    }

    private void sendContextExceptions(ErrorMessageDTO errorMessageDTO) {
        List<ScException> exceptions = ErrorMessageContext.getExceptions();
        if (!CollectionUtils.isEmpty(exceptions)) {
            exceptions.forEach(se -> this.errorMessageSender.send((ScException)((Object)se), errorMessageDTO));
        }
    }
}

