/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.convert;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;

public class LocalDateTimeConverter
extends TypeAdapter {
    private static final DateTimeFormatter DATETIME_FMT_BY_LINE_AND_COLON = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public void write(JsonWriter out, Object value) throws IOException {
        out.value(DATETIME_FMT_BY_LINE_AND_COLON.format((LocalDateTime)value));
    }

    public Object read(JsonReader in) throws IOException {
        String jsonValue = in.nextString();
        if (StringUtils.isEmpty((CharSequence)jsonValue)) {
            return null;
        }
        long timestamp = LocalDateTime.parse(jsonValue, DATETIME_FMT_BY_LINE_AND_COLON).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
    }
}

