/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.util;

import com.digiwin.athena.sccommon.exception.HttpActivityException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public final class HttpUtil {
    public static RestTemplate createRestTemplate(int timeoutSeconds) {
        if (timeoutSeconds < 0) {
            throw new HttpActivityException("Timeout must be a non-negative value");
        }
        return new RestTemplate((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory(HttpUtil.createHttpClient(5, 2, timeoutSeconds * 1000, 5000, 5000)));
    }

    public static HttpClient createHttpClient(int maxTotal, int maxPerRoute, int socketTimeOutMilliSecond, int connectTimeOutMilliSecond, int requestTimeOutMilliSecond) {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(maxTotal);
        connectionManager.setDefaultMaxPerRoute(maxPerRoute);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(socketTimeOutMilliSecond).setConnectTimeout(connectTimeOutMilliSecond).setConnectionRequestTimeout(requestTimeOutMilliSecond).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
    }

    private HttpUtil() {
    }
}

