/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.cache.impl;

import com.digiwin.athena.sccommon.cache.ICacheService;
import com.digiwin.athena.sccommon.cache.ICacheTransaction;
import com.digiwin.athena.sccommon.util.JsonUtil;
import com.digiwin.athena.sccommon.util.StringUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.stereotype.Service;

@Service
public class CacheServiceImpl
implements ICacheService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheServiceImpl.class);
    private static final String PATTERN_ALL_VAL = "*";
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public <T> T get(String key) {
        return (T)(StringUtil.isBlank(key) ? null : this.redisTemplate.opsForValue().get((Object)key));
    }

    @Override
    public void set(String key, Object value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    @Override
    public void set(String key, Object value, long timeout) {
        this.redisTemplate.opsForValue().set((Object)key, value, timeout, TimeUnit.SECONDS);
    }

    @Override
    public boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    @Override
    public Set<String> keys(String pattern) {
        if (StringUtil.isBlank(pattern) || PATTERN_ALL_VAL.equals(pattern)) {
            LOGGER.warn("pattern\u89c4\u5219\u4e3a\u7a7a\u6216\u8005\u4e3a\u5168\u5339\u914d\u6a21\u5f0f,\u8bf7\u67e5\u770b\uff01");
            return new HashSet<String>();
        }
        return this.redisTemplate.keys((Object)pattern);
    }

    @Override
    public boolean remove(Collection<String> collection) {
        long n = this.redisTemplate.delete(collection);
        if (n == 0L) {
            LOGGER.warn("\u672a\u6e05\u9664redis\u7f13\u5b58\u6570\u636e,\u8bf7\u67e5\u770b!");
            return false;
        }
        if ((long)collection.size() != n) {
            LOGGER.warn("redis\u7f13\u5b58\u6e05\u9664\u4e22\u5931\uff0c\u6e05\u9664\u6570\u636e\u4e3a[{}], \u603b\u5171\u6e05\u9664\u6570\u91cf[{}], \u5b9e\u9645\u6e05\u9664\u6570\u91cf[{}]", new Object[]{JsonUtil.getJsonString(collection), collection.size(), n});
        }
        return true;
    }

    @Override
    public boolean remove(String key) {
        return this.redisTemplate.delete((Object)key);
    }

    @Override
    public void executeTransaction(final ICacheTransaction cacheTransaction) {
        this.redisTemplate.execute((SessionCallback)new SessionCallback<List<Object>>(){

            public List<Object> execute(RedisOperations operations) {
                operations.multi();
                cacheTransaction.execute(operations);
                return operations.exec();
            }
        });
    }

    @Override
    public void set(RedisOperations operations, String key, Object value) {
        operations.opsForValue().set((Object)key, value);
    }

    @Override
    public void set(RedisOperations operations, String key, Object value, long seconds) {
        operations.opsForValue().set((Object)key, value, seconds, TimeUnit.SECONDS);
    }

    @Override
    public boolean remove(RedisOperations operations, String key) {
        return operations.delete((Object)key);
    }
}

