/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.service.mongo;

import com.digiwin.athena.sccommon.pojo.model.BaseModel;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.repository.MongoRepository;

public abstract class AbstractService<D extends MongoRepository, T extends BaseModel> {
    @Autowired
    protected D repository;

    public <T> T save(T model) {
        return (T)this.repository.insert(model);
    }

    public <T> List<T> save(List<T> models) {
        return this.repository.insert(models);
    }

    public <T> T editById(T model) {
        return (T)this.repository.save(model);
    }

    public <T> List<T> editById(List<T> models) {
        return this.repository.saveAll(models);
    }

    public <T> T selectOneByCondition(Example<T> example) {
        Optional result = this.repository.findOne(example);
        return result.orElse(null);
    }

    public <T> List<T> listByCondition(Example<T> example) {
        return this.repository.findAll(example);
    }

    public <T> Page<T> findAll(Example<T> example, Pageable pageable) {
        return this.repository.findAll(example, pageable);
    }

    public long countByCondition(Example<T> example) {
        return this.repository.count(example);
    }

    public boolean exists(Example<T> example) {
        return this.repository.exists(example);
    }

    public void delete(T model) {
        this.repository.delete(model);
    }

    public void deleteAll(Iterable<? extends T> entities) {
        this.repository.deleteAll(entities);
    }
}

