/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.util;

import com.digiwin.athena.sccommon.constant.ConfigConstant;
import com.uber.cadence.DomainAlreadyExistsError;
import com.uber.cadence.RegisterDomainRequest;
import com.uber.cadence.serviceclient.ClientOptions;
import com.uber.cadence.serviceclient.WorkflowServiceTChannel;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CadenceUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CadenceUtil.class);

    private CadenceUtil() {
    }

    public static void registerDomain(RegisterDomainRequest request) {
        WorkflowServiceTChannel cadenceService = new WorkflowServiceTChannel(ClientOptions.newBuilder().setHost(ConfigConstant.CADENCE_SERVER_URL).setPort(ConfigConstant.CADENCE_FRONTEND_PORT).setRpcTimeout(5000L).build());
        try {
            cadenceService.RegisterDomain(request);
            LOGGER.info("Successfully registered domain");
        }
        catch (DomainAlreadyExistsError e) {
            LOGGER.info("Domain[{}] is already registered", (Object)request.getName());
        }
        catch (TException e) {
            LOGGER.error("Failing registered domain", (Throwable)e);
        }
        cadenceService.close();
    }
}

