/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.mq;

import com.digiwin.app.service.DWServiceChainContext;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.sccommon.constant.IErrorCodeEnum;
import com.digiwin.athena.sccommon.mq.RabbitMQProducer;
import com.digiwin.athena.sccommon.pojo.bo.ErrorMessageBO;
import com.digiwin.athena.sccommon.pojo.bo.ErrorMessageCustomBO;
import com.digiwin.athena.sccommon.pojo.bo.ErrorMessageDTO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ErrorMessageSender {
    private static final Logger log = LoggerFactory.getLogger(ErrorMessageSender.class);
    @Value(value="${sc.error-message.exchange}")
    private String exchange;
    @Value(value="${sc.error-message.router-key}")
    private String routeKey;
    @Value(value="${sc.error-message.enabled}")
    private boolean enabled;
    @Autowired
    private RabbitMQProducer rabbitMQProducer;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String sendErrorMessage(IErrorCodeEnum errorCodeEnum, Exception e, ErrorMessageDTO errorMessageDTO) {
        if (!this.enabled) {
            return null;
        }
        String traceId = null;
        String token = null;
        try {
            traceId = DWServiceChainContext.getContext().getTraceElement().getRoot().getId();
            token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
        }
        catch (Exception ex) {
            log.error("\u53d1\u9001\u9519\u8bef\u6d88\u606f\u5230IT\u8fd0\u7ef4\u6a21\u7ec4\u65f6\u83b7\u53d6\u4e0a\u4e0b\u6587\u5931\u8d25", (Throwable)ex);
        }
        String exception = String.format("%s[exception=%s, stackTrace=%s]", errorCodeEnum.getMessage(), ExceptionUtils.getMessage((Throwable)e), ExceptionUtils.getStackTrace((Throwable)e));
        ErrorMessageBO errorMessageBO = new ErrorMessageBO();
        errorMessageBO.setIsError(1);
        errorMessageBO.setTraceId(traceId);
        errorMessageBO.setAppId(errorCodeEnum.getAppId());
        errorMessageBO.setErrorCode(errorCodeEnum.getCode());
        errorMessageBO.setCreatedTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        errorMessageBO.setToken(token);
        errorMessageBO.setExceptionType(e.getClass().getSimpleName());
        errorMessageBO.setException(exception);
        errorMessageBO.setTenantId(errorMessageDTO.getTenantId());
        ErrorMessageCustomBO errorMessageCustomBO = new ErrorMessageCustomBO();
        errorMessageCustomBO.setActionId(errorMessageDTO.getActionId());
        errorMessageCustomBO.setRid(errorMessageDTO.getRid());
        errorMessageCustomBO.setWid(errorMessageDTO.getWid());
        errorMessageBO.setCustom(errorMessageCustomBO);
        try {
            log.debug("\u51c6\u5907\u53d1\u9001\u6d88\u606f\u5230IT\u8fd0\u7ef4\u6a21\u7ec4\uff1aexchange={}, routeKey={}, errorMessageBO={}", new Object[]{this.exchange, this.routeKey, errorMessageBO});
            return this.rabbitMQProducer.convertAndSend(this.exchange, this.routeKey, errorMessageBO);
        }
        catch (Exception ex) {
            log.error("\u53d1\u9001\u9519\u8bef\u6d88\u606f\u5230IT\u8fd0\u7ef4\u6a21\u7ec4\u5931\u8d25\uff1aexchange={}, routeKey={}, errorMessageBO={}", new Object[]{this.exchange, this.routeKey, errorMessageBO, ex});
            return null;
        }
    }
}

