/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.cache.impl;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.athena.sccommon.cache.ILargeObjectCacheService;
import com.digiwin.athena.sccommon.constant.ConfigConstant;
import com.digiwin.athena.sccommon.pojo.model.LargeObjectModel;
import com.digiwin.athena.sccommon.service.mongo.ILargeObjectPersistenceService;
import com.digiwin.athena.sccommon.util.JsonUtil;
import com.digiwin.athena.sccommon.util.PlaceholderUtil;
import com.digiwin.athena.sccommon.util.StringCompressUtil;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.DataFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Example;
import org.springframework.stereotype.Service;

@Service(value="largeObjectCacheService")
public class LargeObjectCacheServiceImpl
implements ILargeObjectCacheService {
    private static final Logger log = LoggerFactory.getLogger(LargeObjectCacheServiceImpl.class);
    private static final String KEY_PREFIX = "SC_BD_";
    private static final String COMPRESSED_KEY_SUFFIX = "_compressed";
    private static final String TEMPLATE_PLACEHOLDER = "$(%s)";
    private ILargeObjectPersistenceService largeObjectPersistenceService;

    public LargeObjectCacheServiceImpl(ILargeObjectPersistenceService largeObjectPersistenceService) {
        this.largeObjectPersistenceService = largeObjectPersistenceService;
    }

    @Override
    public String store(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() > ConfigConstant.LARGE_OBJECT_SIZE_THRESHOLD) {
            String cacheKey = KEY_PREFIX + UUID.randomUUID().toString().replace("-", "").toLowerCase();
            LargeObjectModel largeObjectModel = new LargeObjectModel();
            largeObjectModel.setReference(cacheKey);
            largeObjectModel.setValue(value);
            largeObjectModel.setCreateTime(LocalDateTime.now());
            LargeObjectModel compressed = this.compress(largeObjectModel);
            this.largeObjectPersistenceService.save(compressed);
            return String.format(TEMPLATE_PLACEHOLDER, compressed.getReference());
        }
        return value;
    }

    @Override
    public String restore(String value) {
        if (value == null) {
            return null;
        }
        if (value.startsWith("$(SC_BD_")) {
            LargeObjectModel largeObjectModel = new LargeObjectModel();
            largeObjectModel.setReference(PlaceholderUtil.extractPlaceholderKey(value));
            LargeObjectModel largeObjectData = (LargeObjectModel)this.largeObjectPersistenceService.selectOneByCondition(Example.of((Object)largeObjectModel));
            LargeObjectModel decompressed = this.decompress(largeObjectData);
            return this.restore(decompressed.getValue());
        }
        return value;
    }

    @Override
    public String getValue(String reference) {
        if (reference == null) {
            return null;
        }
        LargeObjectModel largeObjectModel = new LargeObjectModel();
        largeObjectModel.setReference(reference);
        LargeObjectModel largeObjectData = (LargeObjectModel)this.largeObjectPersistenceService.selectOneByCondition(Example.of((Object)largeObjectModel));
        if (largeObjectData == null) {
            return null;
        }
        LargeObjectModel decompressed = this.decompress(largeObjectData);
        return decompressed.getValue();
    }

    @Override
    public Object convertObject(Object value) {
        String valueString = null;
        if (value instanceof Map || value instanceof List) {
            valueString = JsonUtil.getJsonString(value, SerializerFeature.WriteMapNullValue);
        } else if (value instanceof String) {
            valueString = (String)value;
        }
        if (valueString != null) {
            return this.store(valueString);
        }
        return value;
    }

    private LargeObjectModel compress(LargeObjectModel largeObjectModel) {
        if (largeObjectModel.getReference().endsWith(COMPRESSED_KEY_SUFFIX)) {
            return largeObjectModel;
        }
        if (largeObjectModel.getValue().getBytes(StandardCharsets.UTF_8).length > ConfigConstant.LARGE_OBJECT_COMPRESSION_SIZE_THRESHOLD) {
            String compressedValue = StringCompressUtil.compressToBase64String(largeObjectModel.getValue());
            largeObjectModel.setReference(largeObjectModel.getReference() + COMPRESSED_KEY_SUFFIX);
            largeObjectModel.setValue(compressedValue);
        }
        return largeObjectModel;
    }

    private LargeObjectModel decompress(LargeObjectModel largeObjectModel) {
        if (largeObjectModel.getReference().endsWith(COMPRESSED_KEY_SUFFIX)) {
            try {
                String decompressedValue = StringCompressUtil.decompressFromBase64String(largeObjectModel.getValue());
                largeObjectModel.setValue(decompressedValue);
            }
            catch (DataFormatException e) {
                log.error("decompress error", (Throwable)e);
            }
        }
        return largeObjectModel;
    }
}

