/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.mq;

import com.digiwin.app.service.DWServiceChainContext;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.sccommon.config.ErrorMessageConfig;
import com.digiwin.athena.sccommon.exception.ScCallbackException;
import com.digiwin.athena.sccommon.exception.ScException;
import com.digiwin.athena.sccommon.exception.ScTemplateInstanceException;
import com.digiwin.athena.sccommon.mq.RabbitMQProducer;
import com.digiwin.athena.sccommon.pojo.bo.ErrorMessageBO;
import com.digiwin.athena.sccommon.pojo.bo.ErrorMessageCustomBO;
import com.digiwin.athena.sccommon.pojo.bo.ErrorMessageDTO;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErrorMessageSender {
    private static final Logger log = LoggerFactory.getLogger(ErrorMessageSender.class);
    @Autowired
    private ErrorMessageConfig errorMessageConfig;
    @Autowired
    private RabbitMQProducer rabbitMQProducer;

    public String send(ScException se, ErrorMessageDTO errorMessageDTO) {
        if (!this.errorMessageConfig.isEnabled()) {
            return null;
        }
        String traceId = null;
        String token = null;
        try {
            traceId = DWServiceChainContext.getContext().getTraceElement().getRoot().getId();
            token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
        }
        catch (Exception ex) {
            log.error("\u53d1\u9001\u9519\u8bef\u6d88\u606f\u5230\u544a\u8b66\u5e73\u53f0\u65f6\u83b7\u53d6\u670d\u52a1\u4e0a\u4e0b\u6587\u5931\u8d25", (Throwable)ex);
        }
        ErrorMessageBO errorMessageBO = new ErrorMessageBO();
        errorMessageBO.setIsError(1);
        errorMessageBO.setTraceId(traceId);
        errorMessageBO.setAppId(this.errorMessageConfig.getAppId());
        errorMessageBO.setErrorCode(se.getErrorCodeEnum().getCode());
        errorMessageBO.setCreatedTime(se.getCreateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        errorMessageBO.setToken(token);
        errorMessageBO.setExceptionType(((Object)((Object)se)).getClass().getSimpleName());
        errorMessageBO.setException(this.getExceptionMessage(se));
        errorMessageBO.setTenantId(errorMessageDTO.getTenantId());
        errorMessageBO.setEocInfo(errorMessageDTO.getEocInfo());
        errorMessageBO.setCustom(ErrorMessageSender.buildCustomBO(se, errorMessageDTO));
        try {
            log.debug("\u51c6\u5907\u53d1\u9001\u6d88\u606f\u5230\u544a\u8b66\u5e73\u53f0\uff1aexchange={}, routeKey={}, errorMessageBO={}", new Object[]{this.errorMessageConfig.getExchange(), this.errorMessageConfig.getRouteKey(), errorMessageBO});
            return this.rabbitMQProducer.convertAndSend(this.errorMessageConfig.getExchange(), this.errorMessageConfig.getRouteKey(), errorMessageBO);
        }
        catch (Exception ex) {
            log.error("\u53d1\u9001\u9519\u8bef\u6d88\u606f\u5230\u544a\u8b66\u5e73\u53f0\u5931\u8d25\uff1aexchange={}, routeKey={}, errorMessageBO={}", new Object[]{this.errorMessageConfig.getExchange(), this.errorMessageConfig.getRouteKey(), errorMessageBO, ex});
            return null;
        }
    }

    private static ErrorMessageCustomBO buildCustomBO(ScException se, ErrorMessageDTO errorMessageDTO) {
        ErrorMessageCustomBO errorMessageCustomBO = new ErrorMessageCustomBO();
        errorMessageCustomBO.setAppCode(errorMessageDTO.getAppCode());
        errorMessageCustomBO.setTemplateId(errorMessageDTO.getTemplateId());
        if (se instanceof ScTemplateInstanceException) {
            ScTemplateInstanceException tie = (ScTemplateInstanceException)se;
            errorMessageCustomBO.setWid(tie.getWid());
            errorMessageCustomBO.setRid(tie.getRid());
        } else if (se instanceof ScCallbackException) {
            ScCallbackException sce = (ScCallbackException)se;
            errorMessageCustomBO.setWid(sce.getWid());
        }
        return errorMessageCustomBO;
    }

    private String getExceptionMessage(ScException se) {
        String message = se.getErrorCodeEnum().getMessage();
        if (!Objects.equals(message, se.getMessage())) {
            message = message + ": " + se.getMessage();
        }
        if (se instanceof ScTemplateInstanceException) {
            ScTemplateInstanceException tie = (ScTemplateInstanceException)se;
            message = message + ", \u6d41\u7a0bID\u4e3a " + tie.getWid() + ", \u8fd0\u884cID\u4e3a " + tie.getRid();
        } else if (se instanceof ScCallbackException) {
            ScCallbackException sce = (ScCallbackException)se;
            message = message + ", \u6d41\u7a0bID\u4e3a " + sce.getWid();
        }
        return message;
    }
}

