/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.template;

import com.digiwin.app.module.spring.DWModuleSpringUtils;
import com.digiwin.athena.sccommon.cache.ILargeObjectCacheService;
import com.digiwin.athena.sccommon.cache.IWorkflowCacheService;
import com.digiwin.athena.sccommon.client.CustomHttpClient;
import com.digiwin.athena.sccommon.constant.ConfigConstant;
import com.digiwin.athena.sccommon.constant.InstanceStatusEnum;
import com.digiwin.athena.sccommon.pojo.bo.DefaultActivityBO;
import com.digiwin.athena.sccommon.template.ISCTemplate;
import com.digiwin.athena.sccommon.template.service.IForkTaskService;
import com.digiwin.athena.sccommon.util.JsonUtil;
import com.digiwin.athena.sccommon.util.SCContextUtil;
import com.digiwin.athena.sccommon.util.TemplateExecutionCounter;
import com.uber.cadence.workflow.Async;
import com.uber.cadence.workflow.Promise;
import com.uber.cadence.workflow.Workflow;
import com.uber.cadence.workflow.WorkflowInfo;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpMethod;

public abstract class AbstractSCTemplate
implements ISCTemplate {
    protected final Map<String, Map<String, Object>> callbackMap = new HashMap<String, Map<String, Object>>();
    protected final DefaultActivityBO defaultActivity;

    public AbstractSCTemplate(String taskList) {
        this.defaultActivity = new DefaultActivityBO(taskList);
    }

    @Override
    public Object execute(Map<String, Object> param) {
        String queueName;
        Map workflowModel;
        if (ConfigConstant.TEMPLATE_EXECUTION_COUNTER_ENABLED) {
            TemplateExecutionCounter.recordExecution();
        }
        if (param.containsKey("scTaskList") && param.get("scTaskList") != null) {
            String scTaskList = (String)param.get("scTaskList");
            this.defaultActivity.setTaskList(scTaskList);
        }
        if ((workflowModel = (Map)param.get("scWorkflowModelContext")) != null) {
            this.saveWorkflowModel(workflowModel);
        }
        Map<String, Object> result = this.getTemplateResult(this.process(param));
        if (param.containsKey("returnHeaders")) {
            result.put("returnHeaders", param.get("returnHeaders"));
        }
        if (StringUtils.isNotBlank((CharSequence)(queueName = MapUtils.getString(param, (Object)"sc_async_callback_queue")))) {
            this.postResultToInvoker(queueName, param, result);
        }
        return result;
    }

    @Override
    public void callback(Map<String, Object> result) {
        String scTaskList;
        if (result.containsKey("scTaskList") && result.get("scTaskList") != null && !(scTaskList = (String)result.get("scTaskList")).trim().isEmpty()) {
            this.defaultActivity.setTaskList(scTaskList);
        }
        this.callbackMap.put(MapUtils.getString(result, (Object)"digi-reqid"), result);
    }

    protected abstract Object process(Map<String, Object> var1);

    protected Promise<Object> asyncExecute(IForkTaskService forkTaskService) {
        return Async.function(forkTaskService::execute);
    }

    protected void sleep(int timeSeconds) {
        Workflow.sleep((Duration)Duration.ofSeconds(timeSeconds));
    }

    protected Map<String, Object> getTemplateResult(Object obj) {
        WorkflowInfo workflowInfo = Workflow.getWorkflowInfo();
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("wid", workflowInfo.getWorkflowId());
        result.put("rid", workflowInfo.getRunId());
        result.put("output", obj);
        return result;
    }

    protected Object restoreData(Object data) {
        ILargeObjectCacheService largeObjectCacheService = SCContextUtil.getBean("largeObjectCacheService", ILargeObjectCacheService.class);
        if (data instanceof String) {
            String restoreString = largeObjectCacheService.restore((String)data);
            return JsonUtil.parse(restoreString);
        }
        if (data instanceof Map) {
            Map rawMap = (Map)data;
            return rawMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                Object value = entry.getValue();
                if (value instanceof String) {
                    return JsonUtil.parse(largeObjectCacheService.restore((String)value));
                }
                return value;
            }));
        }
        return data;
    }

    private void postResultToInvoker(String queueName, Map<String, Object> param, Map<String, Object> result) {
        CustomHttpClient httpClient = (CustomHttpClient)DWModuleSpringUtils.getModuleSpringContext((String)"scworker").getBean(CustomHttpClient.class);
        HashMap<String, Object> httpRequestParams = new HashMap<String, Object>(4);
        httpRequestParams.put("exchange", "");
        httpRequestParams.put("routingKey", queueName);
        httpRequestParams.put("message", result);
        httpClient.invoke(ConfigConstant.POST_SC_WORKER_MQ_URL, HttpMethod.POST, MapUtils.getString(param, (Object)"token"), MapUtils.getString(param, (Object)"tenantId"), httpRequestParams, null);
    }

    private void saveWorkflowModel(Map<String, Object> workflowModel) {
        IWorkflowCacheService workflowCacheService = SCContextUtil.getBean("workflowCacheService", IWorkflowCacheService.class);
        WorkflowInfo workflowInfo = Workflow.getWorkflowInfo();
        workflowModel.put("wid", workflowInfo.getWorkflowId());
        workflowModel.put("rid", workflowInfo.getRunId());
        workflowModel.put("status", InstanceStatusEnum.OPEN.getValue());
        workflowModel.put("startTime", LocalDateTime.now());
        workflowCacheService.insert(workflowModel);
    }

    public DefaultActivityBO getDefaultActivityBO() {
        return this.defaultActivity;
    }

    public Map<String, Map<String, Object>> getCallbackMap() {
        return this.callbackMap;
    }
}

