/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.util;

import com.digiwin.athena.sccommon.constant.CustomErrorCode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public final class ErrorMessageUtil {
    private static final Pattern errorCodePattern = Pattern.compile("\\\\\"errorCode\\\\\"\\s*:\\s*\\\\\"(\\w+\\.\\w+\\.\\w+\\.\\w+)\\\\\"");
    private static final Pattern errorMessagePattern = Pattern.compile("\\\\\"errorMessage\\\\\"\\s*:\\s*\\\\\"([^\"]*)\\\\\"");

    public static String extractErrorCode(String content) {
        Matcher errorCodeMatcher = errorCodePattern.matcher(content);
        String errorCode = errorCodeMatcher.find() ? errorCodeMatcher.group(1) : null;
        return errorCode == null ? null : errorCode.trim();
    }

    public static String extractErrorMessage(String content) {
        Matcher errorMessageMatcher = errorMessagePattern.matcher(content);
        String errorMessage = errorMessageMatcher.find() ? errorMessageMatcher.group(1) : null;
        return errorMessage == null ? null : errorMessage.trim();
    }

    public static CustomErrorCode extract(String content) {
        String errorCode = ErrorMessageUtil.extractErrorCode(content);
        String errorMessage = ErrorMessageUtil.extractErrorMessage(content);
        return StringUtils.hasText((String)errorCode) ? new CustomErrorCode(errorCode, errorMessage) : null;
    }
}

