/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.config;

import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.protocol.HttpContext;

public class SCHttpServiceUnavailableRetryStrategy
implements ServiceUnavailableRetryStrategy {
    private int retryTimes;
    private int retryIntervalMilliSecond;
    private int[] retryStatus;
    private List<Integer> httpClientRetryHttpStatus;

    public SCHttpServiceUnavailableRetryStrategy(int retryTimes, int retryIntervalMilliSecond, List<Integer> httpClientRetryHttpStatus) {
        this.retryTimes = retryTimes;
        this.retryIntervalMilliSecond = retryIntervalMilliSecond;
        this.httpClientRetryHttpStatus = httpClientRetryHttpStatus;
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        if (executionCount > this.retryTimes) {
            return false;
        }
        return executionCount <= this.retryTimes && response.getStatusLine() != null && this.httpClientRetryHttpStatus.contains(response.getStatusLine().getStatusCode());
    }

    public long getRetryInterval() {
        return this.retryIntervalMilliSecond;
    }
}

