/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.pojo.bo;

import com.digiwin.athena.sccommon.activity.IEspInvokerActivity;
import com.digiwin.athena.sccommon.activity.IHttpInvokerActivity;
import com.digiwin.athena.sccommon.activity.IScriptHandlerActivity;
import com.digiwin.athena.sccommon.constant.ConfigConstant;
import com.digiwin.athena.sccommon.util.TaskListUtil;
import com.uber.cadence.activity.ActivityOptions;
import com.uber.cadence.activity.LocalActivityOptions;
import com.uber.cadence.workflow.Workflow;
import java.time.Duration;

public class DefaultActivityBO {
    private String taskList;
    private IHttpInvokerActivity httpInvokerActivity;
    private IEspInvokerActivity espInvokerActivity;
    private IScriptHandlerActivity scriptHandlerActivity;

    public DefaultActivityBO(String taskList) {
        String taskListAndRpcRouterKey;
        this.taskList = taskListAndRpcRouterKey = TaskListUtil.appendRpcRouterKey(taskList);
        this.scriptHandlerActivity = ConfigConstant.SCRIPT_HANDLER_ACTIVITY_LOCAL ? (IScriptHandlerActivity)Workflow.newLocalActivityStub(IScriptHandlerActivity.class, (LocalActivityOptions)new LocalActivityOptions.Builder().setScheduleToCloseTimeout(Duration.ofSeconds(60L)).build()) : (IScriptHandlerActivity)Workflow.newActivityStub(IScriptHandlerActivity.class, (ActivityOptions)new ActivityOptions.Builder().setScheduleToCloseTimeout(Duration.ofSeconds(60L)).build());
    }

    public String getTaskList() {
        return this.taskList;
    }

    public IHttpInvokerActivity getHttpInvokerActivity() {
        if (this.httpInvokerActivity == null) {
            this.httpInvokerActivity = (IHttpInvokerActivity)Workflow.newActivityStub(IHttpInvokerActivity.class, (ActivityOptions)new ActivityOptions.Builder().setScheduleToCloseTimeout(Duration.ofSeconds(300L)).setTaskList(this.taskList).build());
        }
        return this.httpInvokerActivity;
    }

    public IEspInvokerActivity getEspInvokerActivity() {
        if (this.espInvokerActivity == null) {
            this.espInvokerActivity = (IEspInvokerActivity)Workflow.newActivityStub(IEspInvokerActivity.class, (ActivityOptions)new ActivityOptions.Builder().setScheduleToCloseTimeout(Duration.ofSeconds(300L)).setTaskList(this.taskList).build());
        }
        return this.espInvokerActivity;
    }

    public IScriptHandlerActivity getScriptHandlerActivity() {
        if (this.scriptHandlerActivity == null) {
            this.scriptHandlerActivity = (IScriptHandlerActivity)Workflow.newActivityStub(IScriptHandlerActivity.class, (ActivityOptions)new ActivityOptions.Builder().setScheduleToCloseTimeout(Duration.ofSeconds(60L)).build());
        }
        return this.scriptHandlerActivity;
    }
}

