/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.client;

import com.digiwin.athena.sccommon.config.RestTemplateConfigBean;
import com.digiwin.athena.sccommon.exception.HttpActivityException;
import com.digiwin.athena.sccommon.util.HttpUtil;
import com.digiwin.athena.sccommon.util.JsonUtil;
import com.digiwin.athena.sccommon.util.StringUtil;
import java.util.Map;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.UnknownHttpStatusCodeException;

@Component
public class CustomHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomHttpClient.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private RestTemplateConfigBean restTemplateConfigBean;
    @Autowired(required=false)
    @Qualifier(value="dwAttemptHttpLoadbalanceRoute")
    private HttpRoutePlanner httpRoutePlanner;

    public String invoke(String url, HttpMethod method, String token, String routerKey, Map<String, Object> param, Integer timeoutSeconds) {
        return this.invoke(url, method, token, routerKey, param, timeoutSeconds, null);
    }

    public String invoke(String url, HttpMethod method, String token, String routerKey, Map<String, Object> param, Integer timeoutSeconds, Map<String, String> responseHeader) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        if (StringUtil.isBlank(routerKey)) {
            LOGGER.warn("\u53d1\u9001Http\u8bf7\u6c42\u65f6\uff0crouterKey\u503c\u4e3a\u7a7a\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\uff01");
        } else {
            headers.set("routerKey", routerKey);
        }
        headers.set("token", token);
        headers.set("digi-middleware-auth-user", token);
        return this.invoke(url, method, headers, param, timeoutSeconds, responseHeader);
    }

    public String invoke(String url, HttpMethod httpMethod, HttpHeaders headers, Object param, Integer timeoutSeconds, Map<String, String> responseHeader) {
        ResponseEntity content;
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        LOGGER.debug("[{}][method={}][url={}]HTTP\u8bf7\u6c42\u5165\u53c2: {}", new Object[]{headers.get((Object)"data-key"), httpMethod, url, JsonUtil.getJsonString(httpEntity)});
        if (httpMethod == null) {
            throw new HttpActivityException(String.format("\u8bf7\u6c42[%s]\u7684httpMethod\u4e3a\u7a7a\uff01", url));
        }
        try {
            RestTemplate template = this.restTemplate;
            if (timeoutSeconds != null) {
                template = HttpUtil.createRestTemplate(timeoutSeconds, this.restTemplateConfigBean, this.httpRoutePlanner);
            }
            content = url.contains("{") && param instanceof Map ? template.exchange(url, httpMethod, httpEntity, String.class, (Map)param) : template.exchange(url, httpMethod, httpEntity, String.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            LOGGER.error(String.format("HTTP\u8bf7\u6c42[%s]\u51fa\u73b0\u5ba2\u6237\u7aef4XX\u5f02\u5e38\uff01", url), (Throwable)e);
            throw new HttpActivityException(String.format("HTTP\u8bf7\u6c42[%s]\u51fa\u73b0\u5ba2\u6237\u7aef4XX\u5f02\u5e38\uff01\u62a5\u6587\u4f53\u5185\u5bb9\uff1a%s", url, e.getResponseBodyAsString()));
        }
        catch (HttpServerErrorException e) {
            LOGGER.error(String.format("HTTP\u8bf7\u6c42[%s]\u51fa\u73b0\u670d\u52a1\u7aef5XX\u5f02\u5e38\uff01", url), (Throwable)e);
            throw new HttpActivityException(String.format("HTTP\u8bf7\u6c42[%s]\u51fa\u73b0\u670d\u52a1\u7aef5XX\u5f02\u5e38\uff01\u62a5\u6587\u4f53\u5185\u5bb9\uff1a%s", url, e.getResponseBodyAsString()));
        }
        catch (UnknownHttpStatusCodeException e) {
            LOGGER.error(String.format("HTTP\u8bf7\u6c42[%s]\u51fa\u73b0\u672a\u77e5\u72b6\u6001\u7801\u5f02\u5e38\uff01", url), (Throwable)e);
            throw new HttpActivityException(String.format("HTTP\u8bf7\u6c42[%s]\u51fa\u73b0\u672a\u77e5\u72b6\u6001\u7801\u5f02\u5e38\uff01\u62a5\u6587\u4f53\u5185\u5bb9\uff1a%s", url, e.getResponseBodyAsString()));
        }
        catch (Exception e) {
            LOGGER.error(String.format("HTTP\u8bf7\u6c42[%s]\u51fa\u73b0\u5f02\u5e38\uff01", url), (Throwable)e);
            StringBuilder message = new StringBuilder();
            message.append("error message:" + e.getMessage() + "\n ");
            message.append("stack trace: ");
            for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                message.append(stackTraceElement.toString() + "\n ");
            }
            throw new HttpActivityException(String.format("HTTP\u8bf7\u6c42[%s]\u51fa\u73b0\u5f02\u5e38\uff01\u9519\u8bef\u8baf\u606f\u5185\u5bb9\uff1a%s", url, message.toString()));
        }
        LOGGER.debug("[{}][url={}]HTTP\u8bf7\u6c42\u54cd\u5e94: {}", new Object[]{headers.get((Object)"data-key"), url, content});
        if (HttpStatus.OK != content.getStatusCode()) {
            throw new HttpActivityException("HTTP\u8bf7\u6c42:" + url + "\u8fd4\u56deHttpStatus\u4e3a" + content.getStatusCode());
        }
        if (responseHeader != null) {
            content.getHeaders().forEach((k, v) -> responseHeader.put(k.toString(), v.toString()));
        }
        return (String)content.getBody();
    }
}

