/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;

public final class LocalTimeUtil {
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    private static final String YYYY_MM_DD_HH_MM_SS_SSS = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String YYYY_MM_DD_T_HH_MM_SS_SSS_Z = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final DateTimeFormatter DATETIME_FMT_BY_DATE_AND_TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter DATETIME_FMT_BY_DATE_AND_TIME_UNTIL_MS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final DateTimeFormatter DATETIME_FMT_BY_DATE_T_AND_TIME_UNTIL_MS_Z = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final DateTimeFormatter DATE_FMT = DateTimeFormatter.ofPattern("yyyyMMdd");

    private LocalTimeUtil() {
    }

    public static String getCurrentDate(boolean isSeparateByLine) {
        LocalDate now = LocalDate.now();
        if (isSeparateByLine) {
            return now.toString();
        }
        return now.format(DATE_FMT);
    }

    public static String getCurrentDateTime() {
        return LocalDateTime.now().format(DATETIME_FMT_BY_DATE_AND_TIME);
    }

    public static long getCurrentTimeNano() {
        return LocalTimeUtil.getNanoTime(Instant.now());
    }

    public static long getTimeNano(int dayInterval) {
        if (dayInterval < 0) {
            return LocalTimeUtil.getNanoTime(Instant.now().minusSeconds((long)(-dayInterval) * 86400L));
        }
        return LocalTimeUtil.getNanoTime(Instant.now().plusSeconds((long)dayInterval * 86400L));
    }

    private static long getNanoTime(Instant instant) {
        return TimeUnit.NANOSECONDS.convert(instant.getEpochSecond(), TimeUnit.SECONDS) + (long)instant.getNano();
    }

    public static String getDateTime(LocalDateTime time) {
        return time.format(DATETIME_FMT_BY_DATE_AND_TIME_UNTIL_MS);
    }

    public static String getCurrentDateTime(String pattern) {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(pattern));
    }

    private static String getDateTime(long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault()).format(DATETIME_FMT_BY_DATE_AND_TIME);
    }

    public static String getUTCDateTime(long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.of("Z")).format(DATETIME_FMT_BY_DATE_T_AND_TIME_UNTIL_MS_Z);
    }

    public static String getDateTime(String timestamp) {
        return LocalTimeUtil.getDateTime(Long.parseLong(timestamp));
    }

    public static LocalDateTime parseDateTime(String timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(timestamp)), ZoneId.systemDefault());
    }

    public static String getDateTimeMs(long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault()).format(DATETIME_FMT_BY_DATE_AND_TIME_UNTIL_MS);
    }
}

