/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.pojo.bo;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.athena.sccommon.activity.IEspInvokerActivity;
import com.digiwin.athena.sccommon.activity.IHttpInvokerActivity;
import com.digiwin.athena.sccommon.activity.IScriptHandlerActivity;
import com.digiwin.athena.sccommon.constant.ConfigConstant;
import com.digiwin.athena.sccommon.service.templatecode.ITemplateCodeInfoService;
import com.digiwin.athena.sccommon.util.SCContextUtil;
import com.uber.cadence.activity.ActivityOptions;
import com.uber.cadence.activity.LocalActivityOptions;
import com.uber.cadence.common.RetryOptions;
import com.uber.cadence.internal.replay.ActivityTaskFailedException;
import com.uber.cadence.workflow.Workflow;
import java.time.Duration;
import java.util.concurrent.CancellationException;

public class DefaultActivityBO {
    private String scWorkerRunningMode = DWApplicationConfigUtils.getProperty((String)"sc.worker.running.mode", (String)"always");
    private String taskList;
    private IHttpInvokerActivity httpInvokerActivity;
    private IEspInvokerActivity espInvokerActivity;
    private IScriptHandlerActivity scriptHandlerActivity;
    private boolean haveForkTask = false;

    public DefaultActivityBO(String taskList) {
        ITemplateCodeInfoService templateCodeService = SCContextUtil.getBean("templateCodeInfoService", ITemplateCodeInfoService.class);
        this.haveForkTask = templateCodeService.haveForkTask(taskList);
    }

    public void setTaskList(String taskList) {
        this.taskList = taskList;
    }

    public String getTaskList() {
        return this.taskList;
    }

    public void setHaveForkTask(boolean haveForkTask) {
        this.haveForkTask = haveForkTask;
    }

    public boolean getHaveForkTask() {
        return this.haveForkTask;
    }

    public IHttpInvokerActivity getHttpInvokerActivity() {
        if ("generic".equals(this.scWorkerRunningMode)) {
            return (IHttpInvokerActivity)Workflow.newActivityStub(IHttpInvokerActivity.class, (ActivityOptions)new ActivityOptions.Builder().setScheduleToCloseTimeout(Duration.ofSeconds(300L)).setTaskList(this.taskList).build());
        }
        if (this.httpInvokerActivity == null) {
            this.httpInvokerActivity = (IHttpInvokerActivity)Workflow.newActivityStub(IHttpInvokerActivity.class, (ActivityOptions)new ActivityOptions.Builder().setScheduleToCloseTimeout(Duration.ofSeconds(300L)).setTaskList(this.taskList).build());
        }
        return this.httpInvokerActivity;
    }

    public IEspInvokerActivity getEspInvokerActivity() {
        if ("generic".equals(this.scWorkerRunningMode)) {
            return (IEspInvokerActivity)Workflow.newActivityStub(IEspInvokerActivity.class, (ActivityOptions)new ActivityOptions.Builder().setScheduleToCloseTimeout(Duration.ofSeconds(300L)).setTaskList(this.taskList).build());
        }
        if (this.espInvokerActivity == null) {
            this.espInvokerActivity = (IEspInvokerActivity)Workflow.newActivityStub(IEspInvokerActivity.class, (ActivityOptions)new ActivityOptions.Builder().setScheduleToCloseTimeout(Duration.ofSeconds(300L)).setTaskList(this.taskList).build());
        }
        return this.espInvokerActivity;
    }

    public IScriptHandlerActivity getScriptHandlerActivity() {
        if ("generic".equals(this.scWorkerRunningMode)) {
            if (!this.haveForkTask) {
                return (IScriptHandlerActivity)Workflow.newLocalActivityStub(IScriptHandlerActivity.class, (LocalActivityOptions)new LocalActivityOptions.Builder().setScheduleToCloseTimeout(Duration.ofSeconds(ConfigConstant.SC_COMMON_SCRIPT_TASK_TIMEOUT)).build());
            }
            ActivityOptions.Builder activityOptionsBuilder = new ActivityOptions.Builder();
            activityOptionsBuilder.setScheduleToCloseTimeout(Duration.ofSeconds(ConfigConstant.SC_COMMON_SCRIPT_TASK_TIMEOUT)).setTaskList(this.taskList);
            RetryOptions.Builder retryOptionsBuilder = new RetryOptions.Builder();
            retryOptionsBuilder.setInitialInterval(Duration.ofSeconds(30L));
            retryOptionsBuilder.setMaximumAttempts(5);
            retryOptionsBuilder.setBackoffCoefficient(1.0);
            retryOptionsBuilder.setDoNotRetry(new Class[]{CancellationException.class, ActivityTaskFailedException.class});
            activityOptionsBuilder.setRetryOptions(retryOptionsBuilder.build());
            return (IScriptHandlerActivity)Workflow.newActivityStub(IScriptHandlerActivity.class, (ActivityOptions)activityOptionsBuilder.build());
        }
        if (this.scriptHandlerActivity == null) {
            this.scriptHandlerActivity = !this.haveForkTask ? (IScriptHandlerActivity)Workflow.newLocalActivityStub(IScriptHandlerActivity.class, (LocalActivityOptions)new LocalActivityOptions.Builder().setScheduleToCloseTimeout(Duration.ofSeconds(ConfigConstant.SC_COMMON_SCRIPT_TASK_TIMEOUT)).build()) : (IScriptHandlerActivity)Workflow.newActivityStub(IScriptHandlerActivity.class, (ActivityOptions)new ActivityOptions.Builder().setScheduleToCloseTimeout(Duration.ofSeconds(ConfigConstant.SC_COMMON_SCRIPT_TASK_TIMEOUT)).setTaskList(this.taskList).build());
        }
        return this.scriptHandlerActivity;
    }
}

