/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.util;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.athena.sccommon.util.JsonUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookupFactory;

public final class PlaceholderUtil {
    private static final String DEFAULT_REGEX = "\\$\\((?<key>.+?)\\)";

    private PlaceholderUtil() {
    }

    public static Set<String> extractPlaceholderKeys(String propertyString) {
        return PlaceholderUtil.extractPlaceholderKeys(propertyString, DEFAULT_REGEX);
    }

    public static Set<String> extractPlaceholderKeys(String propertyString, String regex) {
        HashSet<String> placeholderKeys = new HashSet<String>();
        Matcher matcher = Pattern.compile(regex).matcher(propertyString);
        while (matcher.find()) {
            placeholderKeys.add(matcher.group("key"));
        }
        return placeholderKeys;
    }

    public static String extractPlaceholderKey(String propertyString) {
        return PlaceholderUtil.extractPlaceholderKey(propertyString, DEFAULT_REGEX);
    }

    public static String extractPlaceholderKey(String propertyString, String regex) {
        if (StringUtils.isBlank((CharSequence)propertyString)) {
            return "";
        }
        Matcher matcher = Pattern.compile(regex).matcher(propertyString);
        return matcher.find() ? matcher.group("key") : "";
    }

    public static boolean isNotContainPlaceholder(String content) {
        return StringUtils.isBlank((CharSequence)PlaceholderUtil.extractPlaceholderKey(content));
    }

    public static String replaceWithDynamicVariable(String initialString, Map<String, Object> param, boolean reservedJsonString) {
        HashMap<String, Object> convertedParam = new HashMap<String, Object>();
        param.forEach((key, value) -> {
            if (value instanceof Map || value instanceof List) {
                String convertedValue = JsonUtil.getJsonString(value, SerializerFeature.WriteMapNullValue);
                convertedValue = StringEscapeUtils.escapeJava((String)convertedValue);
                convertedParam.put((String)key, convertedValue);
            } else {
                convertedParam.put((String)key, value);
            }
        });
        return PlaceholderUtil.replaceWithDynamicVariable(initialString, convertedParam);
    }

    public static String replaceWithDynamicVariable(String initialString, Map<String, Object> param) {
        if (PlaceholderUtil.isNotContainPlaceholder(initialString)) {
            return initialString;
        }
        StringSubstitutor stringSubstitutor = new StringSubstitutor(param, "$(", ")");
        String firstReplaceResult = stringSubstitutor.replace(initialString);
        if (PlaceholderUtil.isNotContainPlaceholder(firstReplaceResult)) {
            return firstReplaceResult;
        }
        Object variableMap = param.get("scConfigVariable");
        Object configMap = variableMap instanceof String ? JsonUtil.getObject((String)variableMap) : (variableMap instanceof Map ? (Map)variableMap : new HashMap(1));
        stringSubstitutor.setVariableResolver(StringLookupFactory.INSTANCE.mapStringLookup((Map)configMap));
        return stringSubstitutor.replace(firstReplaceResult);
    }
}

