/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.util;

import com.uber.cadence.workflow.Workflow;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TemplateExecutionCounter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateExecutionCounter.class);
    private static final int MAX_COUNTER_SIZE = 4320;
    private static final Map<LocalDateTime, Integer> EXECUTION_COUNTER_MAP = new ConcurrentHashMap<LocalDateTime, Integer>(5761);

    public static synchronized String recordExecution() {
        LocalDateTime now = LocalDateTime.now();
        if (EXECUTION_COUNTER_MAP.size() >= 4320) {
            TemplateExecutionCounter.clear();
        }
        int count = EXECUTION_COUNTER_MAP.getOrDefault(now.truncatedTo(ChronoUnit.MINUTES), 0);
        EXECUTION_COUNTER_MAP.put(now.truncatedTo(ChronoUnit.MINUTES), count + 1);
        LOGGER.info("Template executed at {}. Total count in this minute: {}", (Object)now, (Object)(count + 1));
        return Workflow.getWorkflowInfo().getWorkflowId();
    }

    public static synchronized int getExecutionCountInPeriod(LocalDateTime start, LocalDateTime end) {
        int totalCount = 0;
        for (Map.Entry<LocalDateTime, Integer> entry : EXECUTION_COUNTER_MAP.entrySet()) {
            LocalDateTime key = entry.getKey();
            if (!key.isAfter(start) || !key.isBefore(end)) continue;
            totalCount += entry.getValue().intValue();
        }
        return totalCount;
    }

    public static void logExecutionCountsInPeriod(LocalDateTime start, LocalDateTime end) {
        int count = TemplateExecutionCounter.getExecutionCountInPeriod(start, end);
        LOGGER.info("The total count of template execution between {} and {} is {}", new Object[]{start, end, count});
    }

    public static void clear() {
        EXECUTION_COUNTER_MAP.clear();
        LOGGER.info("Template execution counts cleared at {}.", (Object)LocalDateTime.now());
    }
}

