/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.dao;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.athena.sccommon.util.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class BaseDao {
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;

    protected int update(String statement, Object ... params) {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        return this.dao.update((IDWSQLOptions)option, statement, params);
    }

    protected List<Map<String, Object>> select(String statement, Object ... params) {
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        return this.dao.select((IDWSQLOptions)option, statement, params);
    }

    protected <T> List<T> select(Class<T> cls, String statement, Object ... params) {
        List<Map<String, Object>> resultList = this.select(statement, params);
        if (CollectionUtils.isEmpty(resultList)) {
            return new ArrayList();
        }
        return resultList.stream().map(JsonUtil::getJsonString).map(itemStr -> JsonUtil.getObject(itemStr, cls)).collect(Collectors.toList());
    }
}

