/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.util;

import com.alibaba.fastjson.JSONException;
import com.digiwin.athena.sccommon.constant.CustomErrorCode;
import com.digiwin.athena.sccommon.exception.EspActivityException;
import com.digiwin.athena.sccommon.exception.HttpActivityException;
import com.digiwin.athena.sccommon.exception.JsActivityException;
import com.digiwin.athena.sccommon.util.JsonUtil;
import com.uber.cadence.client.WorkflowException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class ErrorMessageUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorMessageUtil.class);
    private static final Pattern errorCodePattern = Pattern.compile("\\\\\"errorCode\\\\\"\\s*:\\s*\\\\\"(\\w+\\.\\w+\\.\\w+\\.\\w+)\\\\\"");
    private static final Pattern errorMessagePattern = Pattern.compile("\\\\\"errorMessage\\\\\"\\s*:\\s*\\\\\"([^\"]*)\\\\\"");

    public static String extractErrorCode(String content) {
        Matcher errorCodeMatcher = errorCodePattern.matcher(content);
        String errorCode = errorCodeMatcher.find() ? errorCodeMatcher.group(1) : null;
        return errorCode == null ? null : errorCode.trim();
    }

    public static String extractErrorMessage(String content) {
        Matcher errorMessageMatcher = errorMessagePattern.matcher(content);
        String errorMessage = errorMessageMatcher.find() ? errorMessageMatcher.group(1) : null;
        return errorMessage == null ? null : errorMessage.trim();
    }

    public static CustomErrorCode extract(String content) {
        String errorCode = ErrorMessageUtil.extractErrorCode(content);
        String errorMessage = ErrorMessageUtil.extractErrorMessage(content);
        return StringUtils.hasText((String)errorCode) ? new CustomErrorCode(errorCode, errorMessage) : null;
    }

    public static CustomErrorCode extract(String workflowExceptionApplicationCode, WorkflowException workflowException) {
        if (workflowException.getCause() != null && workflowException.getCause() instanceof EspActivityException) {
            EspActivityException espActivityException = (EspActivityException)workflowException.getCause();
            String message = espActivityException.getMessage();
            try {
                String bodyJsonStringString;
                Map bodyJsonStringMap;
                Map stdData;
                Map stdData2;
                Map espMessage = JsonUtil.getObject(message, Map.class);
                if (espMessage.containsKey("std_data") && (stdData2 = (Map)espMessage.get("std_data")).containsKey("execution")) {
                    Map execution = (Map)stdData2.get("execution");
                    String code = (String)execution.get("code");
                    if ("-1".equals(code)) {
                        code = "P." + espActivityException.getServiceProd() + ".9999.9999";
                    }
                    String description = (String)execution.get("description");
                    return StringUtils.hasText((String)code) ? new CustomErrorCode(code, description) : null;
                }
                if (espMessage.containsKey("bodyJsonString") && (stdData = (Map)(bodyJsonStringMap = JsonUtil.getObject(bodyJsonStringString = (String)espMessage.get("bodyJsonString"), Map.class)).get("std_data")).containsKey("execution")) {
                    Map execution = (Map)stdData.get("execution");
                    String code = (String)execution.get("code");
                    if ("-1".equals(code)) {
                        code = "P." + espActivityException.getServiceProd() + ".9999.9999";
                    }
                    String description = (String)execution.get("description");
                    return StringUtils.hasText((String)code) ? new CustomErrorCode(code, description) : null;
                }
            }
            catch (JSONException exception) {
                return null;
            }
            catch (Exception exception) {
                LOGGER.error("ErrorMessageUtil extract exception:" + exception.getMessage());
                return null;
            }
        }
        if (workflowException.getCause() != null && workflowException.getCause() instanceof HttpActivityException) {
            HttpActivityException httpActivityException = (HttpActivityException)workflowException.getCause();
            String responseBody = httpActivityException.getResponseBody();
            try {
                Map responseBodyMap = JsonUtil.getObject(responseBody, Map.class);
                if (responseBodyMap.containsKey("errorCode")) {
                    String errorCode = "";
                    String errorMessage = "";
                    errorCode = (String)responseBodyMap.get("errorCode");
                    if (responseBodyMap.containsKey("errorMessage")) {
                        errorMessage = (String)responseBodyMap.get("errorMessage");
                    }
                    return StringUtils.hasText((String)errorCode) ? new CustomErrorCode(errorCode, errorMessage) : null;
                }
                if (responseBodyMap.containsKey("response")) {
                    Map response = (Map)responseBodyMap.get("response");
                    String errorCode = "";
                    String errorMessage = "";
                    if (response.containsKey("errorCode")) {
                        errorCode = (String)response.get("errorCode");
                    }
                    if (response.containsKey("errorMessage")) {
                        errorMessage = (String)response.get("errorMessage");
                    }
                    return StringUtils.hasText((String)errorCode) ? new CustomErrorCode(errorCode, errorMessage) : null;
                }
            }
            catch (JSONException exception) {
                return null;
            }
            catch (Exception exception) {
                LOGGER.error("ErrorMessageUtil extract exception:" + exception.getMessage());
                return null;
            }
        }
        if (workflowException.getCause() != null && workflowException.getCause() instanceof JsActivityException) {
            try {
                if (StringUtils.hasText((String)workflowExceptionApplicationCode)) {
                    JsActivityException jsActivityException = (JsActivityException)workflowException.getCause();
                    String jsErrorMessage = jsActivityException.getMessage();
                    String errorCode = "P." + workflowExceptionApplicationCode + ".9999.9999";
                    return new CustomErrorCode(errorCode, jsErrorMessage);
                }
            }
            catch (Exception exception) {
                LOGGER.error("ErrorMessageUtil extract exception:" + exception.getMessage());
                return null;
            }
        }
        return null;
    }
}

