/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.cache.impl;

import com.digiwin.athena.sccommon.cache.IWorkflowCacheService;
import com.digiwin.athena.sccommon.pojo.model.WorkFlowModel;
import com.digiwin.athena.sccommon.service.mongo.IWorkflowPersistenceService;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="workflowCacheService")
public class WorkflowCacheServiceImpl
implements IWorkflowCacheService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowCacheServiceImpl.class);
    private IWorkflowPersistenceService workflowPersistenceService;

    public WorkflowCacheServiceImpl(IWorkflowPersistenceService workflowPersistenceService) {
        this.workflowPersistenceService = workflowPersistenceService;
    }

    @Override
    public void insert(Map<String, Object> workflowModel) {
        try {
            WorkFlowModel wf = new WorkFlowModel();
            String wid = MapUtils.getString(workflowModel, (Object)"wid");
            String rid = MapUtils.getString(workflowModel, (Object)"rid");
            wf.setWid(wid);
            wf.setRid(rid);
            wf.setTemplateId(MapUtils.getString(workflowModel, (Object)"templateId"));
            wf.setTemplateName(MapUtils.getString(workflowModel, (Object)"templateName"));
            wf.setTenantId(MapUtils.getString(workflowModel, (Object)"tenantId"));
            LocalDateTime startTime = (LocalDateTime)workflowModel.get("startTime");
            wf.setStartTime(startTime);
            wf.setRequestParams(MapUtils.getMap(workflowModel, (Object)"requestParams"));
            wf.setEocCompanyId(MapUtils.getString(workflowModel, (Object)"eocCompanyId"));
            wf.setEocRegionId(MapUtils.getString(workflowModel, (Object)"eocRegionId"));
            wf.setEocSiteId(MapUtils.getString(workflowModel, (Object)"eocSiteId"));
            wf.setStatus(MapUtils.getIntValue(workflowModel, (Object)"status"));
            wf.setApplicationCode(MapUtils.getString(workflowModel, (Object)"applicationCode"));
            WorkFlowModel wfInDb = this.workflowPersistenceService.selectOne(wid, rid);
            if (wfInDb == null) {
                this.workflowPersistenceService.save(wf);
            } else {
                String duplicateMessage = "workflow replay instance[wid={}, rid={}], new instance[{}], in mongo db instance[{}]";
                LOGGER.debug(duplicateMessage, new Object[]{wid, rid, wf.toString(), wfInDb.toString()});
            }
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0MongoDB\u4e2d\u7684\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }
}

