/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.mq;

import com.digiwin.app.service.DWServiceChainContext;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.sccommon.config.ErrorMessageConfig;
import com.digiwin.athena.sccommon.exception.ScCallbackException;
import com.digiwin.athena.sccommon.exception.ScException;
import com.digiwin.athena.sccommon.exception.ScTemplateInstanceException;
import com.digiwin.athena.sccommon.mq.RabbitMQProducer;
import com.digiwin.athena.sccommon.pojo.bo.ErrorMessageBO;
import com.digiwin.athena.sccommon.pojo.bo.ErrorMessageCustomBO;
import com.digiwin.athena.sccommon.pojo.bo.ErrorMessageDTO;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ErrorMessageSender {
    private static final Logger log = LoggerFactory.getLogger(ErrorMessageSender.class);
    @Autowired
    private ErrorMessageConfig errorMessageConfig;
    @Autowired
    private RabbitMQProducer rabbitMQProducer;

    public String send(ScException se, ErrorMessageDTO errorMessageDTO) {
        if (!this.errorMessageConfig.isEnabled()) {
            return null;
        }
        String traceId = null;
        String token = null;
        String pinpointId = null;
        try {
            traceId = DWServiceChainContext.getContext().getTraceElement().getRoot().getId();
            token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
            pinpointId = this.getPinpointId(se.getErrorCodeEnum().getCode());
        }
        catch (Exception ex) {
            log.error("\u53d1\u9001\u9519\u8bef\u6d88\u606f\u5230\u544a\u8b66\u5e73\u53f0\u65f6\u83b7\u53d6\u670d\u52a1\u4e0a\u4e0b\u6587\u5931\u8d25", (Throwable)ex);
        }
        ErrorMessageBO errorMessageBO = new ErrorMessageBO();
        errorMessageBO.setIsError(1);
        errorMessageBO.setTraceId(traceId);
        errorMessageBO.setPinpointId(pinpointId);
        errorMessageBO.setAppId(this.errorMessageConfig.getAppId());
        errorMessageBO.setErrorCode(se.getErrorCodeEnum().getCode());
        errorMessageBO.setCreatedTime(se.getCreateTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        errorMessageBO.setToken(token);
        errorMessageBO.setExceptionType(((Object)((Object)se)).getClass().getSimpleName());
        errorMessageBO.setException(this.getExceptionMessage(se));
        errorMessageBO.setTenantId(errorMessageDTO.getTenantId());
        errorMessageBO.setEocInfo(errorMessageDTO.getEocInfo());
        errorMessageBO.setCustom(this.buildCustomBO(se, errorMessageDTO));
        try {
            log.debug("\u51c6\u5907\u53d1\u9001\u6d88\u606f\u5230\u544a\u8b66\u5e73\u53f0\uff1aexchange={}, routeKey={}, errorMessageBO={}", new Object[]{this.errorMessageConfig.getExchange(), this.errorMessageConfig.getRouteKey(), errorMessageBO});
            return this.rabbitMQProducer.convertAndSend(this.errorMessageConfig.getExchange(), this.errorMessageConfig.getRouteKey(), errorMessageBO);
        }
        catch (Exception ex) {
            log.error("\u53d1\u9001\u9519\u8bef\u6d88\u606f\u5230\u544a\u8b66\u5e73\u53f0\u5931\u8d25\uff1aexchange={}, routeKey={}, errorMessageBO={}", new Object[]{this.errorMessageConfig.getExchange(), this.errorMessageConfig.getRouteKey(), errorMessageBO, ex});
            return null;
        }
    }

    private ErrorMessageCustomBO buildCustomBO(ScException se, ErrorMessageDTO errorMessageDTO) {
        ErrorMessageCustomBO errorMessageCustomBO = new ErrorMessageCustomBO();
        errorMessageCustomBO.setAppCode(errorMessageDTO.getAppCode());
        errorMessageCustomBO.setTemplateId(errorMessageDTO.getTemplateId());
        if (se instanceof ScTemplateInstanceException) {
            ScTemplateInstanceException tie = (ScTemplateInstanceException)se;
            errorMessageCustomBO.setWid(tie.getWid());
            errorMessageCustomBO.setRid(tie.getRid());
        } else if (se instanceof ScCallbackException) {
            ScCallbackException sce = (ScCallbackException)se;
            errorMessageCustomBO.setWid(sce.getWid());
        }
        return errorMessageCustomBO;
    }

    private String getExceptionMessage(ScException se) {
        String errorMessage = se.getErrorCodeEnum().getMessage();
        String detailMessage = se.getMessage();
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(errorMessage);
        if (!Objects.equals(errorMessage, detailMessage)) {
            messages.add(detailMessage);
        }
        if (se instanceof ScTemplateInstanceException) {
            ScTemplateInstanceException tie = (ScTemplateInstanceException)se;
            messages.add("wid = " + tie.getWid() + ", rid = " + tie.getRid());
        } else if (se instanceof ScCallbackException) {
            ScCallbackException sce = (ScCallbackException)se;
            messages.add("wid = " + sce.getWid());
        }
        messages.add(se.getErrorCodeEnum().getSolution());
        if (this.errorMessageConfig.isEnableCauseStackTrace() && !CollectionUtils.isEmpty((Map)se.getInstructors())) {
            Map instructors = se.getInstructors();
            Object message = instructors.get("message");
            Object stackTrace = instructors.get("stackTrace");
            Object rootCauseMessage = instructors.get("rootCauseMessage");
            Object rootCauseStackTrace = instructors.get("rootCauseStackTrace");
            if (message != null && stackTrace != null) {
                String causeStackTrace = String.format("message = %s, stackTrace = %s, rootCauseMessage = %s, rootCauseStackTrace = %s", message, stackTrace, rootCauseMessage, rootCauseStackTrace);
                messages.add(causeStackTrace);
            }
        }
        return String.join((CharSequence)"\uff1b", messages);
    }

    private String getPinpointId(String code) {
        log.info("Get pinpoint tracking ID: code = {}", (Object)code);
        String pinpointId = ThreadContext.get((String)"PtxId");
        if (StringUtils.isEmpty((Object)pinpointId)) {
            pinpointId = MDC.get((String)"PtxId");
        }
        log.info("Get pinpoint tracking ID: pinpointId = {}", (Object)pinpointId);
        return pinpointId;
    }
}

