/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.config;

import java.io.IOException;
import java.net.ConnectException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCHttpRequestRetryHandler
implements HttpRequestRetryHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCHttpRequestRetryHandler.class);
    private int retryTimes;
    private int retryIntervalMilliSecond;

    public SCHttpRequestRetryHandler(int retryTimes, int retryIntervalMilliSecond) {
        this.retryTimes = retryTimes;
        this.retryIntervalMilliSecond = retryIntervalMilliSecond;
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        if (executionCount > this.retryTimes) {
            return false;
        }
        if (exception instanceof ConnectTimeoutException || exception instanceof NoHttpResponseException || exception instanceof ConnectException) {
            try {
                Thread.sleep(this.retryIntervalMilliSecond);
            }
            catch (InterruptedException e) {
                LOGGER.error("SCHttpRequestRetryHandler interrupted exception", (Throwable)e);
            }
            return true;
        }
        return false;
    }
}

