/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.List;

public final class JsonUtil {
    private JsonUtil() {
    }

    public static <T> T getObject(String jsonText, Class<T> clazz) {
        return (T)JSON.parseObject((String)jsonText, clazz);
    }

    public static <T> T getObjectByOrder(String jsonText, Class<T> clazz) {
        return (T)JSON.parseObject((String)jsonText, clazz, (Feature[])new Feature[]{Feature.OrderedField});
    }

    public static JSONObject getObjectByOrder(String jsonText) {
        return JSON.parseObject((String)jsonText, (Feature[])new Feature[]{Feature.OrderedField});
    }

    public static JSONObject getObject(String jsonText) {
        return JSON.parseObject((String)jsonText);
    }

    public static Object parse(String json) {
        if (json == null) {
            return null;
        }
        if (JSONValidator.from((String)json).validate()) {
            return JSON.parse((String)json);
        }
        return json;
    }

    public static <T> T parseObject(String text, TypeReference<T> type) {
        return (T)JSON.parseObject((String)text, type, (Feature[])new Feature[0]);
    }

    public static <T> T getObjectByKey(String data, String key, Class<T> cls) {
        return (T)JsonUtil.getObject(data, JSONObject.class).getObject(key, cls);
    }

    public static String getJsonString(Object object) {
        return JSON.toJSONString((Object)object);
    }

    public static String getJsonString(Object object, SerializerFeature feature) {
        return JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{feature});
    }

    public static <T> List<T> getList(String jsonStr, Class<T> clazz) {
        return JSON.parseArray((String)jsonStr, clazz);
    }

    public static JSONArray getList(String jsonStr) {
        return JSON.parseArray((String)jsonStr);
    }

    public static <T> List<T> getListByKey(String data, String key, Class<T> cls) {
        return JsonUtil.getObject(data, JSONObject.class).getJSONArray(key).toJavaList(cls);
    }

    public static <T> List<T> getListByKey(JSONObject data, String key, Class<T> cls) {
        return data.getJSONArray(key).toJavaList(cls);
    }
}

