/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.client;

import com.digiwin.app.resource.DWApplicationMessageResourceBundleUtils;
import com.digiwin.athena.sccommon.config.RestTemplateConfigBean;
import com.digiwin.athena.sccommon.exception.HttpActivityException;
import com.digiwin.athena.sccommon.util.HttpUtil;
import com.digiwin.athena.sccommon.util.JsonUtil;
import com.digiwin.athena.sccommon.util.StringUtil;
import com.digiwin.loadbalance.exception.DWInstanceServiceNotFoundException;
import com.digiwin.loadbalance.exception.DWStateModeServiceNotFoundException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.UnknownHttpStatusCodeException;

@Component
public class CustomHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomHttpClient.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private RestTemplateConfigBean restTemplateConfigBean;
    @Autowired(required=false)
    @Qualifier(value="dwAttemptHttpLoadbalanceRoute")
    private HttpRoutePlanner httpRoutePlanner;
    @Autowired
    @Qualifier(value="dw-httpclient-request-retry-handler")
    HttpRequestRetryHandler dapRequestRetryHandler;
    @Autowired
    @Qualifier(value="dw-httpclient-response-retry-strategy")
    ServiceUnavailableRetryStrategy dapServiceUnavailableRetryStrategy;

    public String invoke(String url, HttpMethod method, String token, String routerKey, Map<String, Object> param, Integer timeoutSeconds) {
        return this.invoke(url, method, token, routerKey, param, timeoutSeconds, null);
    }

    public String invoke(String url, HttpMethod method, String token, String routerKey, Map<String, Object> param, Integer timeoutSeconds, Map<String, String> responseHeader) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        if (StringUtil.isBlank(routerKey)) {
            LOGGER.warn("\u53d1\u9001Http\u8bf7\u6c42\u65f6\uff0crouterKey\u503c\u4e3a\u7a7a\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\uff01");
        } else {
            headers.set("routerKey", routerKey);
        }
        headers.set("token", token);
        headers.set("digi-middleware-auth-user", token);
        return this.invoke(url, method, headers, param, timeoutSeconds, responseHeader);
    }

    public String invoke(String url, HttpMethod httpMethod, HttpHeaders headers, Object param, Integer timeoutSeconds, Map<String, String> responseHeader) {
        ResponseEntity content;
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        LOGGER.debug("[{}][method={}][url={}]HTTP\u8bf7\u6c42\u5165\u53c2: {}", new Object[]{headers.get((Object)"data-key"), httpMethod, url, JsonUtil.getJsonString(httpEntity)});
        if (httpMethod == null) {
            String errorMessage = DWApplicationMessageResourceBundleUtils.getString((String)"sc.common.http.exception.method.empty", (Object[])new Object[]{url});
            throw new HttpActivityException(errorMessage);
        }
        try {
            RestTemplate template = this.restTemplate;
            if (timeoutSeconds != null) {
                template = HttpUtil.createRestTemplate(timeoutSeconds, this.restTemplateConfigBean, this.httpRoutePlanner, this.dapRequestRetryHandler, this.dapServiceUnavailableRetryStrategy);
            }
            content = url.contains("{") && param instanceof Map ? template.exchange(url, httpMethod, httpEntity, String.class, (Map)param) : template.exchange(url, httpMethod, httpEntity, String.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            String responseBody = e.getResponseBodyAsString();
            String errorMessage = DWApplicationMessageResourceBundleUtils.getString((String)"sc.common.http.error.unknown", (Object[])new Object[]{url, e.getStatusCode().toString(), responseBody});
            LOGGER.error(errorMessage, (Throwable)e);
            throw new HttpActivityException(errorMessage, responseBody);
        }
        catch (HttpServerErrorException e) {
            String responseBody = e.getResponseBodyAsString();
            String errorMessage = DWApplicationMessageResourceBundleUtils.getString((String)"sc.common.http.error.unknown", (Object[])new Object[]{url, e.getStatusCode().toString(), responseBody});
            LOGGER.error(errorMessage, (Throwable)e);
            throw new HttpActivityException(errorMessage, responseBody);
        }
        catch (UnknownHttpStatusCodeException e) {
            String responseBody = e.getResponseBodyAsString();
            String errorMessage = DWApplicationMessageResourceBundleUtils.getString((String)"sc.common.http.error.unknown", (Object[])new Object[]{url, String.valueOf(e.getRawStatusCode()), responseBody});
            LOGGER.error(errorMessage, (Throwable)e);
            throw new HttpActivityException(errorMessage, responseBody);
        }
        catch (DWInstanceServiceNotFoundException | DWStateModeServiceNotFoundException e) {
            String exceptionMessage = e.getMessage();
            HashMap<String, String> responseBodyMap = new HashMap<String, String>();
            responseBodyMap.put("errorCode", e.getErrorCode());
            responseBodyMap.put("errorMessage", exceptionMessage);
            String responseBody = JsonUtil.getJsonString(responseBodyMap);
            String combinedMessage = DWApplicationMessageResourceBundleUtils.getString((String)"sc.common.http.exception", (Object[])new Object[]{url, exceptionMessage});
            throw new HttpActivityException(combinedMessage, responseBody);
        }
        catch (Exception e) {
            StringBuilder message = new StringBuilder();
            message.append("error message:" + e.getMessage() + "\n ");
            message.append("stack trace: ");
            for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                message.append(stackTraceElement.toString() + "\n ");
            }
            String errorMessage = DWApplicationMessageResourceBundleUtils.getString((String)"sc.common.http.exception", (Object[])new Object[]{url, message.toString()});
            LOGGER.error(errorMessage, (Throwable)e);
            throw new HttpActivityException(errorMessage, message.toString());
        }
        LOGGER.debug("[{}][url={}]HTTP\u8bf7\u6c42\u54cd\u5e94: {}", new Object[]{headers.get((Object)"data-key"), url, content});
        if (HttpStatus.OK != content.getStatusCode()) {
            String responseBody = (String)content.getBody();
            String errorMessage = DWApplicationMessageResourceBundleUtils.getString((String)"sc.common.http.error.unknown", (Object[])new Object[]{url, String.valueOf(content.getStatusCodeValue()), responseBody});
            throw new HttpActivityException(errorMessage, responseBody);
        }
        if (responseHeader != null) {
            content.getHeaders().forEach((k, v) -> responseHeader.put(k.toString(), v.toString()));
        }
        return (String)content.getBody();
    }
}

