/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.config;

import com.digiwin.athena.sccommon.config.RestTemplateConfigBean;
import com.digiwin.athena.sccommon.util.HttpUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTemplateConfig {
    @Value(value="${httpClientMaxTotal:200}")
    private int maxTotal;
    @Value(value="${httpClientMaxPerRoute:100}")
    private int maxPerRoute;
    @Value(value="${httpClientRequestTimeOutMilliSecond:15000}")
    private int requestTimeOutMilliSecond;
    @Value(value="${httpClientConnectTimeOutMilliSecond:15000}")
    private int connectTimeOutMilliSecond;
    @Value(value="${httpClientSocketTimeOutMilliSecond:15000}")
    private int socketTimeOutMilliSecond;
    @Value(value="${httpClientRetryTimes:3}")
    private int retryTimes;
    @Value(value="${httpClientRetryIntervalMilliSecond:30000}")
    private int retryIntervalMilliSecond;

    @Bean
    public RestTemplateConfigBean restTemplateConfigBean() {
        RestTemplateConfigBean restTemplateConfigBean = new RestTemplateConfigBean();
        restTemplateConfigBean.setMaxTotal(this.maxTotal);
        restTemplateConfigBean.setMaxPerRoute(this.maxPerRoute);
        restTemplateConfigBean.setRequestTimeOutMilliSecond(this.requestTimeOutMilliSecond);
        restTemplateConfigBean.setConnectTimeOutMilliSecond(this.connectTimeOutMilliSecond);
        restTemplateConfigBean.setSocketTimeOutMilliSecond(this.socketTimeOutMilliSecond);
        restTemplateConfigBean.setRetryTimes(this.retryTimes);
        restTemplateConfigBean.setRetryIntervalMilliSecond(this.retryIntervalMilliSecond);
        return restTemplateConfigBean;
    }

    @Bean
    public RestTemplate restTemplate(@Autowired HttpComponentsClientHttpRequestFactory httpRequestFactory) {
        RestTemplate restTemplate = HttpUtil.createRestTemplate(httpRequestFactory);
        return restTemplate;
    }

    @Bean
    public HttpComponentsClientHttpRequestFactory httpRequestFactory(@Autowired RestTemplateConfigBean restTemplateConfigBean) {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory(HttpUtil.createHttpClient(null, restTemplateConfigBean));
        return factory;
    }
}

