/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.util;

import com.digiwin.athena.sccommon.config.RestTemplateConfigBean;
import com.digiwin.athena.sccommon.config.SCHttpRequestRetryHandler;
import com.digiwin.athena.sccommon.config.SCHttpServiceUnavailableRetryStrategy;
import com.digiwin.athena.sccommon.exception.HttpActivityException;
import java.nio.charset.StandardCharsets;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public final class HttpUtil {
    public static RestTemplate createRestTemplate(Integer timeoutSeconds, RestTemplateConfigBean restTemplateConfigBean) {
        if (timeoutSeconds < 0) {
            throw new HttpActivityException("Timeout must be a non-negative value");
        }
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory(HttpUtil.createHttpClient(timeoutSeconds * 1000, restTemplateConfigBean));
        RestTemplate restTemplate = HttpUtil.createRestTemplate(clientHttpRequestFactory);
        return restTemplate;
    }

    public static RestTemplate createRestTemplate(RestTemplateConfigBean restTemplateConfigBean) {
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory(HttpUtil.createHttpClient(null, restTemplateConfigBean));
        RestTemplate restTemplate = HttpUtil.createRestTemplate(clientHttpRequestFactory);
        return restTemplate;
    }

    public static RestTemplate createRestTemplate(HttpComponentsClientHttpRequestFactory clientHttpRequestFactory) {
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)clientHttpRequestFactory);
        restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        return restTemplate;
    }

    public static HttpClient createHttpClient(Integer timeoutSeconds, RestTemplateConfigBean restTemplateConfigBean) {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(restTemplateConfigBean.getMaxTotal());
        connectionManager.setDefaultMaxPerRoute(restTemplateConfigBean.getMaxPerRoute());
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        if (timeoutSeconds == null) {
            requestConfigBuilder.setSocketTimeout(restTemplateConfigBean.getSocketTimeOutMilliSecond());
        } else {
            requestConfigBuilder.setSocketTimeout(timeoutSeconds.intValue());
        }
        requestConfigBuilder.setConnectTimeout(restTemplateConfigBean.getConnectTimeOutMilliSecond());
        requestConfigBuilder.setConnectionRequestTimeout(restTemplateConfigBean.getRequestTimeOutMilliSecond());
        RequestConfig requestConfig = requestConfigBuilder.build();
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultRequestConfig(requestConfig);
        builder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        builder.setRetryHandler((HttpRequestRetryHandler)new SCHttpRequestRetryHandler(restTemplateConfigBean.getRetryTimes(), restTemplateConfigBean.getRetryIntervalMilliSecond()));
        builder.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new SCHttpServiceUnavailableRetryStrategy(restTemplateConfigBean.getRetryTimes(), restTemplateConfigBean.getRetryIntervalMilliSecond()));
        return builder.build();
    }

    private HttpUtil() {
    }
}

