/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.util;

import java.io.ByteArrayOutputStream;
import java.util.Base64;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public final class StringCompressUtil {
    private static final int BUFFER_SIZE = 1024;

    public static byte[] compress(String str) {
        Deflater deflater = new Deflater();
        deflater.setInput(str.getBytes());
        deflater.finish();
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            out.write(buffer, 0, count);
        }
        return out.toByteArray();
    }

    public static String decompress(byte[] compressed) throws DataFormatException {
        Inflater inflater = new Inflater();
        inflater.setInput(compressed);
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream(compressed.length);
        while (!inflater.finished()) {
            int count = inflater.inflate(buffer);
            out.write(buffer, 0, count);
        }
        return out.toString();
    }

    public static String compressToBase64String(String str) {
        return Base64.getEncoder().encodeToString(StringCompressUtil.compress(str));
    }

    public static String decompressFromBase64String(String compressed) throws DataFormatException {
        return StringCompressUtil.decompress(Base64.getDecoder().decode(compressed));
    }

    public static void main(String[] args) throws Exception {
        String value = "{\"task1_1_duration\":0,\"task1_2_duration\":1,\"task2_1_duration\":0,\"task2_2_duration\":1,\"task3_1_duration\":1,\"task3_2_duration\":0}";
        String compressedValue = StringCompressUtil.compressToBase64String(value);
        System.out.println(compressedValue);
    }
}

