/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.sccommon.util;

import com.digiwin.athena.sccommon.constant.ConfigConstant;

public class TaskListUtil {
    public static String getHostOrComputerName() {
        String hostOrComputerName = System.getenv("COMPUTERNAME");
        if (hostOrComputerName == null) {
            hostOrComputerName = System.getenv("HOSTNAME");
        }
        return hostOrComputerName;
    }

    public static String appendRpcRouterKeyAndHostName(String taskList) {
        return TaskListUtil.appendRpcRouterKey(taskList);
    }

    public static String escapeSpecialCharacters(String taskList) {
        if (taskList == null || taskList.isEmpty()) {
            return taskList;
        }
        return taskList.replace("-", "__");
    }

    public static String unescapeSpecialCharacters(String escapedTaskList) {
        if (escapedTaskList == null || escapedTaskList.isEmpty()) {
            return escapedTaskList;
        }
        return escapedTaskList.replace("__", "-");
    }

    public static String appendRpcRouterKey(String taskList) {
        return taskList + ConfigConstant.RPC_ROUTER_KEY;
    }

    public static String removeRpcRouterKeyAndHostName(String taskList) {
        String[] splitTaskList = taskList.split("\\$");
        return splitTaskList[0] + "$" + splitTaskList[1] + "$" + splitTaskList[2];
    }

    public static String removeRpcRouterKey(String taskList) {
        return taskList.substring(0, taskList.length() - ConfigConstant.RPC_ROUTER_KEY.length());
    }

    public static int removeRpcRouterKeyDollarSign(String rpcRouterKey) {
        return Integer.parseInt(rpcRouterKey.substring(1));
    }

    public static void main(String[] args) throws Exception {
        String hostName = TaskListUtil.getHostOrComputerName();
        String hostNamePostFiveSymbol = hostName.substring(hostName.length() - 5, hostName.length());
        System.out.println(hostNamePostFiveSymbol);
        String taskList = "scGlobalTenant$map_SupplierTrackPlanPlant$66$2250";
        String taskListWithouRpcRouterKeyAndHostName = TaskListUtil.removeRpcRouterKeyAndHostName(taskList);
        System.out.println(taskListWithouRpcRouterKeyAndHostName);
        String taskList2 = "scGlobalTenant$dap_prezzure_test1$2";
        String taskListWithouRpcRouterKeyAndHostName2 = TaskListUtil.getHostOrComputerName();
        System.out.println(taskListWithouRpcRouterKeyAndHostName2);
    }
}

