package com.digiwin.athena.semc;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.scheduling.annotation.EnableAsync;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-10-28 09:35
 **/
@SpringBootApplication
@ServletComponentScan
@MapperScan("com.digiwin.athena.semc.mapper")
@EnableAsync
@EnableRetry
@EnableCaching
@EnableDiscoveryClient
public class AppSemc extends SpringBootServletInitializer {

    public static void main(String[] args) {
        SpringApplication.run(AppSemc.class,args);
    }

    @Override
    protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
        return builder.sources(AppSemc.class);
    }

}
