package com.digiwin.athena.semc.aspect;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.semc.annotate.MenuPermissionAuth;
import com.digiwin.athena.semc.entity.menu.manage.ManageMenuAuth;
import com.digiwin.athena.semc.mapper.menu.manage.ManageMenuAuthMapper;
import com.digiwin.athena.semc.proxy.iam.service.IamService;
import com.digiwin.athena.semc.proxy.iam.service.model.RoleDTO;
import com.digiwin.athena.semc.proxywrapper.IamUserService;
import com.digiwin.athena.semc.proxywrapper.dto.IamUserAuthInfo;
import com.digiwin.athena.semc.util.Utils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * @Author  jeff
 * @Date: 2025-03-14
 * @Version 1.0
 * @Description
 */
@Slf4j
@Aspect
@Component
public class MenuPermissionAuthAspect {

    @Resource
    private IamService iamService;

    @Resource
    private IamUserService iamUserService;

    @Resource
    private ManageMenuAuthMapper manageMenuAuthMapper;

    @Pointcut("@within(com.digiwin.athena.semc.annotate.MenuPermissionAuth) || @annotation(com.digiwin.athena.semc.annotate.MenuPermissionAuth)")
    public void permissionAuthAspect() {
        log.info(" ---------- MenuPermissionAuthAspect()");
    }

    @Before(value = "permissionAuthAspect()")
    public void mgrPermissionAuthCheck(JoinPoint joinPoint) {
        MenuPermissionAuth permissionAuth = null;
        try {
            Class<?> clazz = joinPoint.getTarget().getClass();
            if(clazz.isAnnotationPresent(MenuPermissionAuth.class)){
                permissionAuth = clazz.getAnnotation(MenuPermissionAuth.class);
            }else {
                MethodSignature methodSignature = (MethodSignature) joinPoint.getSignature();
                Method method = methodSignature.getMethod();
                if (method.isAnnotationPresent(MenuPermissionAuth.class)) {
                    permissionAuth = method.getDeclaredAnnotation(MenuPermissionAuth.class);
                }
            }
        } catch (Exception e) {
            log.error("permissionAuthAspect error", e);
            return;
        }
        if(permissionAuth ==null || StringUtils.isBlank(permissionAuth.code())){
            return;
        }
        menuPermissionAuth(permissionAuth);
    }

    private void menuPermissionAuth(MenuPermissionAuth permissionAuth){
        try{
            List<RoleDTO> roles = iamService.queryUserRoles(Utils.getUserId(), Utils.getUserToken());
            for (RoleDTO role : roles) {
                if (Objects.equals(role.getId(), permissionAuth.role())) {
                    return;
                }
            }
        } catch (Exception e) {
            log.error("menuPermissionAuth role auth error", e);
        }
        menuAuth(permissionAuth.code());
    }

    private void menuAuth(String menuKey){
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        IamUserAuthInfo iamUserAuthInfo = iamUserService.getUserAuthSids(authoredUser.getUserId(), authoredUser.getTenantId(), authoredUser.getToken());
        List<Long> authIdList = Lists.newArrayList();
        if(Objects.nonNull(iamUserAuthInfo)){
            if (CollectionUtils.isNotEmpty(iamUserAuthInfo.getOrgSids())) {
                authIdList.addAll(iamUserAuthInfo.getOrgSids());
            }
            // 拼接角色条件
            if (CollectionUtils.isNotEmpty(iamUserAuthInfo.getRoleSids())) {
                authIdList.addAll(iamUserAuthInfo.getRoleSids());
            }
            // 拼接部门条件
            if (CollectionUtils.isNotEmpty(iamUserAuthInfo.getDeptSids())) {
                authIdList.addAll(iamUserAuthInfo.getDeptSids());
            }
        }
        // 拼接用户条件
        if (ObjectUtils.isNotEmpty(authoredUser.getSid())) {
            authIdList.add(authoredUser.getSid());
        }
        if(CollectionUtils.isNotEmpty(authIdList)){
            Collections.sort(authIdList);
            QueryWrapper<ManageMenuAuth> condition = new QueryWrapper<>();
            condition.eq("menu_key",menuKey);
            condition.apply("(auth_id IN ({0}) OR all_menu_auth_flag = {1})", Joiner.on(",").join(authIdList), 1);
            Long selectCount = manageMenuAuthMapper.selectCount(condition);
            if(Objects.isNull(selectCount) || selectCount<1){
                throw BusinessException.create("No menu permission");
            }
        }
        throw BusinessException.create("No menu permission");
    }
}
