package com.digiwin.athena.semc.common;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;

/**
 * @description: 业务异常包装类
 * @author: sunyfa
 * @create: 2022-12-10 16:58
 */
@Data
public class BizException extends RuntimeException {
    private final Integer code;

    private final String lang;

    public BizException(Integer code, String msg, String lang) {
        super(msg);
        this.code = code;
        this.lang = lang;
    }

    /**
     * 构造默认语言的业务异常类
     *
     * @param code 业务异常码
     * @param msg 业务异常消息
     * @return 业务异常类
     */
    public static BizException getDefaultBizException(Integer code, String msg) {
        return new BizException(code, msg, LocaleContextHolder.getLocale().toString());
    }

    /**
     * 构造指定语言的业务异常类
     *
     * @param code 业务异常码
     * @param msg 业务异常消息
     * @param lang 语言
     * @return 业务异常类
     */
    public static BizException getBizException(Integer code, String msg, String lang) {
        if (StringUtils.isEmpty(lang)) {
            lang = LocaleContextHolder.getLocale().toString();
        }
        return new BizException(code, msg, lang);
    }
}
