package com.digiwin.athena.semc.common;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;


/**
 * @program: demos
 * @description: 描述
 * @author: Tuo
 * @create: 2022-06-29 18:16
 **/

public interface Constants {
    // semc缓存前缀
    String CACHE_KEY_PREFIX = "Athena:agileInteraction:semc:cache:";

    public static final String base64ImgPrefix = "data:image/png;base64,";

    public static final String token = "Authenticate";

    public static final String userAttr = "userAttr";

    public static final String loginUser = "loginUser";

    public static final String DIGIWIN_CODE = "DIGIWIN_SEMC_CODE";


    String asc = "asc";
    String desc = "desc";

    public static final Integer MAXPAGESIZE = 1000;

    // 拉取三方待办每次的最大数量
    public static final Integer TODO_MAX_SIZE = 1000;


    public static final Integer pageNum = 1;

    public static final Integer pageSize = 100;


    // 默认分页大小
    public static final Integer DEF_PAGE_SIZE = 20;

    /**
     * 应用类型 稳态
     */
    public static final String SYSTEM_TYPE_WT = "wt";

    /**
     * 应用类型 敏态
     */
    public static final String SYSTEM_TYPE_MT = "mt";

    /**
     * 简体
     */
    public static final String ZH_CN_LOCALE = "zh_CN";

    /**
     * 简体
     */
    public static final String ZH_CH_LOCALE = "zh_CH";

    /**
     * 繁体
     */
    public static final String ZH_TW_LOCALE = "zh_TW";

    /**
     * 英文
     */
    public static final String EN_US_LOCALE = "en_US";


    /**
     * code前缀-敏态
     */
    public static final String CODE_PREFFIX_MT = "MT-";

    /**
     * code前缀-稳态
     */
    public static final String CODE_PREFFIX_WT = "WT-";


    /**
     * 数据源中的源应用需要过滤的应用集合
     */
    public static final List<String> FILTER_SYSETEM_DATA = Arrays.asList("鼎捷云控制台", "开发平台");

    /**
     * 稳态链接不要加密-配置值
     */
    public static final Integer ERP_URL_NO_NEEDBASE64 = 1;

    /**
     * 稳态链接要加密-配置值
     */
    public static final Integer ERP_URL_NEEDBASE64 = 2;

    /**
     * 配置有效状态-有效
     */
    public static final Integer VALID_STATUS_ENABLE = 1;

    /**
     * 配置有效状态-无效
     */
    public static final Integer VALID_STATUS_UNUSABLE = 0;

    /**
     * 是否使用最近一次的门户 0:否 1:是
     */
    public static final Integer USE_LATEST_FLAG_YES = 1;

    /**
     * 稳态链接直接指定路径-配置
     */
    public static final Integer PRESCRIBED_ROUTE = 1;

    /**
     * 默认配置标识 0：否 1：是
     */
    public static final Integer DEFAULT_CONFIGURED_FLAG_NO = 0;

    /**
     * 默认配置标识 0：否 1：是
     */
    public static final Integer DEFAULT_CONFIGURED_FLAG_YES = 1;


    /**
     * 页签待办详情默认刷新频率开关，默认开启1
     */
    public static final Integer TABS_IS_OPEN = 1;


    /**
     * 页签默认刷新频率时间
     */
    public static final Integer TABS_TIME_DEF = 3;

    /**
     * 是否需要获取授权码 0:否 1:是
     */
    public static final Integer NEED_AUTH_CODE_FLAG_YES = 1;

    /**
     * 是否需要获取授权码 0:否 1:是
     */
    public static final Integer NEED_AUTH_CODE_FLAG_NO = 0;

    /**
     * 稳态产品的产品代号 T100
     */
    public static final String T100_PRODUCT_TYPE = "100";

    /**
     * 稳态产品的产品代号 TIPTOP
     */
    public static final String TIPTOP_PRODUCT_TYPE = "06";

    /**
     * C/S应用注册
     */
    public static final String CS_APP_CALLBACK_URL = "http://www.%s.com";

    /**
     * 智能入口登录DMC 用户名
     */
    public static final String DMC_USER_NAME = "entrance";

    /**
     * 智能入口登录DMC 用户名
     */
    public static final String DMC_USER = "entrance123456";

    /**
     * 智能入口登录DMC 密码
     */
    public static final String DMC_ENCRYPTION = "1OOWFo386jQGUNKoYQ/XL2doLTXfEpHKQJpNQK5Sxf4=";


    /**
     * 智能入口登录DMC pwdhash
     */
    public static final String DMC_HASH = "pwdhash";


    /**
     * 智能入口登录DMC username
     */
    public static final String USER_NAME = "username";


    /**
     * 简体转为繁体
     */
    public static final String TRANSLATE_CN_TO_TW = "zh2Hant";

    /**
     * 繁体转为简体
     */
    public static final String TRANSLATE_TW_TO_CN = "zh2Hans";

    /**
     * dmc userToken 缓存key前缀
     */
    public static final String DMC_USER_TOKEN = "dmc-userToken:";

    /**
     * 升级说明版更内容 简体缓存
     */
    public static final String TEXT_CN_CACHE_KEY = "text-cn-cache:";

    /**
     * 升级说明版更内容 繁体缓存
     */
    public static final String TEXT_TW_CACHE_KEY = "text-tw-cache:";

    /**
     * 是否是通用菜单模板 0:否 1:是
     */
    public static final Integer GENERAL_MENU_FLAG_NO = 0;

    public static final Integer GENERAL_MENU_FLAG_YES = 1;

    /**
     * 通用菜单模板id
     */
    public static final Long GENERAL_MENU_TEMPLATE_ID = 1L;


    /**
     * 是否门户布局查询
     */
    Integer IS_LAYOUT = 1;
    /**
     * 指定启用状态
     */
    Integer LABEL_SYSTEM_PRE_VALID_STATUS = 1;

    /**
     * 指定卡死启用状态
     */
    Integer LABEL_SYSTEM_PRE_ENABLE_TRUE = 1;

    /**
     * 指定不需要选择数据源
     */
    Integer LABEL_SYSTEM_PRE_USE_DATA = 0;

    /**
     * 特定组件类型(预设组件-固定组件) 指定状态
     */
    Integer LABEL_SYSTEM_PRE_REGULAR = 5;

    Integer COMPONENT_SIZE = 40;

    Integer EMAIL_COUNT = 30;

    /**
     * 预设组件
     */
    Integer COMPONENTSOURCE_TYPE = 1;

    /**
     * 特定组件类型(待办)
     */
    Integer LABEL_SYSTEM_PRE_NEED_DEAL = 0;


    String ID = "主键id不可为空";

    String VALIDSTATUS = "有效状态不可为空";

    String COMPONENTSOURCE = "组件来源不为空";


    /**
     * 黑名单标识
     */
    public static final Integer BLACK_TYPE = 0;

    /**
     * 白名单标识
     */
    public static final Integer WHITE_TYPE = 1;

    /**
     * B/S应用类型
     */
    public static final Integer APP_TYPE_BS = 1;

    /**
     * C/S应用类型
     */
    public static final Integer APP_TYPE_CS = 2;

    /**
     * IAM应用类型
     */
    public static final Integer APP_TYPE_IAM = 4;

    /**
     * 三方异构系统查询消息restful接口
     */
    public static final String THIRD_MESSAGE_QUERY_INTERFACE_PATH = "/third/message/query";

    /**
     * 全员可见标识
     */
    public static final String ALL_STAFF_CAN_SEE_FLAG = "all";

    /**
     * 是否全员可看 1:全员可阅 0:部分成员可阅读
     */
    public static final Integer MESSAGE_ALL_STAFF_FLAG = 1;

    /**
     * 是否置顶 0:否 1:是
     */
    public static final Integer TOPPED_FLAG_NO = 0;

    /**
     * 是否置顶 0:否 1:是
     */
    public static final Integer TOPPED_FLAG_YES = 1;

    /**
     * 是否修改 0:否 1:是
     */
    public static final Integer MODIFIED_FLAG_YES = 1;

    /**
     * 是否全员可见 0:否 1:是
     */
    public static final Integer NEWS_ALL_AUTH_FLAG_NO = 0;

    /**
     * 是否全员可见 0:否 1:是
     */
    public static final Integer NEWS_ALL_AUTH_FLAG_YES = 1;

    /**
     * 是否展示系统菜单 0:否 1:是
     */
    public static final Integer SYSTEM_MENU_FLAG_YES = 1;

    /**
     * 数字1
     */
    public static final Integer NUMBER_ONE = 1;

    /**
     * 数字0
     */
    public static final Integer NUMBER_ZERO = 0;


    /**
     * 数字5
     */
    public static final Integer NUMBER_FIVE = 5;

    /**
     * 数字10
     */
    public static final Integer NUMBER_TEN = 10;

    /**
     * 智奇应用id
     */
    String CORPID = "CORP-8sgGghQW8nlrwn97nf4";


    /**
     * 智奇应用密钥
     */
    @SuppressWarnings("java:S6418")
    String CORPSECRET = "a92e0d94-47cb-4f4a-9a3f-269cb565e38f";


    /**
     * 智奇接口域名
     */
    String DOMAIN = "http://open.global-mail.cn";


    /**
     * 调用正式区iam 获取sid
     */
    String urlSid = "https://iam.digiwincloud.com.cn/api/iam/v2/dev/app";

    /**
     * 调用iam 获取appToken
     */
    String url = "https://iam.digiwincloud.com.cn/api/iam/v2/dev/app/";

    /**
     * 获取正式区域用户token
     */
    String urlToken = "https://iam.digiwincloud.com.cn/api/iam/v2/identity/login/internal";

    /**
     * 是否已存在应用
     */
    String isExist = "https://iam.digiwincloud.com.cn/api/iam/v2/dev/app";


    /**
     * 每刻地址后缀
     */
    String APPROVALURL = "/api/web/report/approvals?limit=500";
    String TOKENURL = "/api/web/auth/sso?entCode=%s&userId=%s&timestamp=%s&token=%s";

    /**
     * 审批中
     */
    String APPROVING = "APPROVING";
    String APPROVINGZH = "审批中";
    /**
     * 待报销人确认
     */
    String CONFIRMINGZH = "待报销人确认";

    String TENANT_APPLICATION = "租户应用";

    String PLATFORM_APPLICATION = "平台应用";


    /**
     * 语言类型枚举
     */
    public enum LanguageEnum {
        ZH_CN(0, ZH_CN_LOCALE),
        ZH_TW(1, ZH_TW_LOCALE),
        EN_US(2, EN_US_LOCALE);


        /**
         * code
         */
        @Getter
        private final Integer code;

        /**
         * desc
         */
        @Getter
        private final String desc;

        LanguageEnum(Integer code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        /**
         * 通过语言标识获取枚举值
         *
         * @param desc 语言类型
         * @return 类型code
         */
        public static Integer parseLanguageCodeByLocale(String desc) {
            if (StringUtils.isNotBlank(desc)) {
                for (LanguageEnum languageEnum : LanguageEnum.values()) {
                    if (languageEnum.getDesc().equals(desc)) {
                        return languageEnum.getCode();
                    }
                }
            }
            return ZH_TW.getCode();
        }
    }

    enum JobWorkTypeEnum {
        // 0:代表Web端的作业
        WEB_JOB(0),
        // 1:代表移动端的作业
        MOBILE_JOB(1);

        private Integer value;

        public Integer getValue() {
            return value;
        }

        JobWorkTypeEnum(Integer value) {
            this.value = value;
        }
    }


    /**
     * 组件标识
     */
    public enum LabelEnum {
        // 全局资讯
        GLOBAL_INFORMATION("global_information"),
        // 待办
        TO_DO("to_do"),
        // 三方待办
        THIRD_TO_DO("third_to_do"),
        // 常用
        COMMONLY_USED("commonly_used"),
        // 收藏
        COLLECTION("collection"),
        // 新闻公告
        NEWS_NOTICE("news_notice"),
        // 三方报表
        REPORT_FORMS("report_forms");
        private String key;

        LabelEnum(String key) {
            this.key = key;
        }

        public String getKey() {
            return key;
        }
    }

    /**
     * 组件配置打页签标识
     */
    public enum SystemTabEnum {
        TZGG("TZGG", "通知公告"),
        GSXW("GSXW", "公司新闻");

        /**
         * code
         */
        @Getter
        private final String flag;

        /**
         * desc
         */
        @Getter
        private final String name;

        SystemTabEnum(String code, String name) {
            this.flag = code;
            this.name = name;
        }

        /**
         * 通过页签标识获取页签名称
         *
         * @param flag 页签标识
         * @return 类型code
         */
        public static String parseNameByCode(String flag) {
            if (StringUtils.isNotBlank(flag)) {
                for (SystemTabEnum tabEnum : SystemTabEnum.values()) {
                    if (tabEnum.getFlag().equals(flag)) {
                        return tabEnum.getName();
                    }
                }
            }
            return null;
        }
    }

    /**
     * 系统标识
     */
    public enum SystemFlagEnum {
        DEFAULT(0),// 默认
        THIRD(1);// 三方

        private Integer flag;

        SystemFlagEnum(Integer source) {
            this.flag = source;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 数据类型（0：待办卡片、1：三方报表、2：公告、3：邮件、
     * 4：常用、5：收藏、6：数智视图、7：绩效、8：作业工作台、9：行事历、10：三方待办、11：轮播图）
     */
    public enum DataTypeEnum {
        TYPE_TODO(0),
        TYPE_REPORT(1),
        TYPE_NOTICE(2),
        TYPE_EMAIL(3),
        TYPE_USE(4),
        TYPE_COLLECT(5),
        TYPE_INFO(6),
        TYPE_MERITS(7),
        TYPE_JOB(8),
        TYPE_CALENDAR(9),
        TYPE_THIRD_TODO(10),
        TYPE_CAROUSEL(11);

        private Integer val;

        DataTypeEnum(Integer val) {
            this.val = val;
        }

        public Integer getVal() {
            return val;
        }
    }

    /**
     * 数据源/组件分类（ 0-预设组件-三方待办、1-预设组件-三方报表、2-预设组件-新闻公告、
     * * 3-自定义组件-作业集成、4-自定义组件-应用集成、5-预设组件-固定组件；
     */
    public enum DataCategoryEnum {
        CATEGORY_TODO(0),// 预设组件-三方待办
        CATEGORY_REPORT(1),// 预设组件-三方报表
        CATEGORY_NOTICE(2),// 预设组件-新闻公告
        CATEGORY_WORK(3),// 自定义组件-作业集成
        CATEGORY_APP(4),// 自定义组件-应用集成
        CATEGORY_CURRENCY(5),// 预设组件-固定组件
        CATEGORY_COUNT(6),// 自定义组件-统计组件
        BUSINESS_TODO(7),// 自定义组件-业务待办
        WEB_PAGE(8), // 自定义组件-内嵌网页
        REPORT(9); // 自定义组件-报表

        private Integer val;

        DataCategoryEnum(Integer val) {
            this.val = val;
        }

        public Integer getVal() {
            return val;
        }
    }

    /**
     * 内嵌网页类型的自定义组件 链接参数类型 0:常用参数 1:自定义参数
     */
    public enum WebLabelLinkEnum {
        COMMON_PARAM(0), // 常用参数
        CUSTOM_PARAM(1); // 自定义参数

        private Integer type;

        WebLabelLinkEnum(Integer type) {
            this.type = type;
        }

        public Integer getType() {
            return type;
        }
    }

    /**
     * 内嵌网页类型的自定义组件 链接常用参数配置
     */
    public enum WebLabelCommonParamEnum {
        USER_ID("userId"),   // 用户id
        USER_TOKEN("userToken"), // 用户token
        TIMESTAMP("timestamp"), // 时间戳
        LANGUAGE("language"); // 语系

        private String key;

        WebLabelCommonParamEnum(String key) {
            this.key = key;
        }

        public String getKey() {
            return key;
        }
    }

    /**
     * 是否需要卡死状态为有效（0：不需要；1：需要）
     */
    public enum IsEnableTrueNum {
        ENABLE_FALSE(0),
        ENABLE_TRUE(1);

        private Integer val;

        IsEnableTrueNum(Integer val) {
            this.val = val;
        }

        public Integer getVal() {
            return val;
        }
    }

    /**
     * 是否需要选择数据源（0：不需要；1：需要）
     */
    public enum IsUseDataNum {
        USE_DATA_FALSE(0),
        USE_DATA_TRUE(1);

        private Integer val;

        IsUseDataNum(Integer val) {
            this.val = val;
        }

        public Integer getVal() {
            return val;
        }
    }

    /**
     * 数据源/组件分类（ 0-预设组件-三方待办、1-预设组件-三方报表、2-预设组件-新闻公告、
     * * 3-自定义组件-作业集成、4-自定义组件-应用集成、5-预设组件-固定组件；
     */
    public enum DataCategoryNameEnum {
        CATEGORY_TODO_NAME("三方待办"),// 预设组件-三方待办
        CATEGORY_WORK_NAME("作业集成"),// 自定义组件-作业集成
        CATEGORY_APP_NAME("应用集成"),// 自定义组件-应用集成
        CATEGORY_WEB_NAME("内嵌网页");// 自定义组件-内嵌网页
        private String val;

        DataCategoryNameEnum(String val) {
            this.val = val;
        }

        public String getVal() {
            return val;
        }
    }


    /**
     * 有效状态 0:无效 1:有效
     */
    public enum ValidStatusEnum {
        VALID_STATUS_ON(0),
        VALID_STATUS_OFF(1);
        private Integer val;

        ValidStatusEnum(Integer val) {
            this.val = val;
        }

        public Integer getVal() {
            return val;
        }
    }

    /**
     * 启用状态
     */
    public enum ValidStatusNameEnum {
        VALID_STATUS_ON("已启用"),
        VALID_STATUS_OFF("未启用");
        private String val;

        ValidStatusNameEnum(String val) {
            this.val = val;
        }

        public String getVal() {
            return val;
        }
    }

    /**
     * 作业填写方式，作业名称、作业回调地址
     */
    public enum JobTypeEnum {
        JOB_TYPE_NAME("作业名称"),
        JOB_TYPE_CALLBACK("作业回调地址");
        private String val;

        JobTypeEnum(String val) {
            this.val = val;
        }

        public String getVal() {
            return val;
        }
    }

    /**
     * 组件类型（0：自定义组件、1：预设组件）
     */
    public enum LabelTypeEnum {
        SYSTEM_CUSTOM(0, "自定义组件"),
        SYSTEM_PRE(1, "预设组件");
        private Integer val;
        private String name;

        LabelTypeEnum(Integer val, String name) {
            this.val = val;
            this.name = name;
        }

        public Integer getVal() {
            return val;
        }

        public String getName() {
            return name;
        }
    }

    /**
     * 接入模式（0：混合云、1：纯云上）
     */
    public enum DataModelEnum {
        MODEL_HYBRID_CLOUD(0),// 混合云
        MODEL_CLOUD(1);// 纯云上
        private Integer val;

        DataModelEnum(Integer val) {
            this.val = val;
        }

        public Integer getVal() {
            return val;
        }
    }

    /**
     * 渠道（平台：platform、地端用户：ground）
     */
    public enum ChannelEnum {
        PLATFORM("platform"),
        GROUND("ground");

        private String val;

        ChannelEnum(String val) {
            this.val = val;
        }

        public String getVal() {
            return val;
        }
    }

    /**
     * 门户风格类型
     */
    public enum PortalTypeEnum {
        SIMPLE(0),// 极简风格
        CONVENTIONAL(1);// 传统风格

        private Integer flag;

        PortalTypeEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 查询logo图片的场景 0：登录页 1：登录后首页
     */
    public enum SceneFlagEnum {
        LOGIN_BEFORE_PAGE(0),// 登录页
        LOGIN_AFTER_PAGE(1),// 登录后首页
        LOGIN_AFTER_TITLE(2),// 2：首页网页标题logo（登录后）
        LOGIN_AFTER_LOGO(3),// 3：企业标识logo（登录后）；
        HOME_LOGIN_LOGO(4),// 4：企业标识logo（登录前）
        HOME_LOGIN_TITLE_LOGO(5);// 5：网页标题logo（登录前）

        private Integer flag;

        SceneFlagEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    public enum ThirdNewsAnnouncementEnum {

        INSIDER_INFORMATION(0),// 一方公告
        OUTSIDER_INFORMATION(1);// 三方公告

        private Integer value;

        ThirdNewsAnnouncementEnum(Integer value) {
            this.value = value;
        }

        public Integer getType() {
            return value;
        }
    }


    /**
     * 作业同步类型。同步类型：0:新增、1：修改、2：删除
     */
    public enum syncTypeEnum {
        ADD(0),
        EDIT(1),
        DEL(2);

        private Integer flag;

        syncTypeEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 跳转官网状态（0：未启用；1：启用）
     */
    public enum JumpStatusEnum {
        NO(0),// 否

        YES(1);// 是

        private Integer flag;

        JumpStatusEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 用户行为枚举 与mmc配置一致
     */
    public enum ActionFlagEnum {
        BASIC_ENABLE("basic-enable"),// 基础版是否启用
        SSO_ENABLE("sso-enable"),// SSO是否启用
        PORTAL_ENABLE("portal-enable");// 门户是否启用

        private String flag;

        ActionFlagEnum(String flag) {
            this.flag = flag;
        }

        public String getFlag() {
            return flag;
        }
    }

    /**
     * 归户模式 0:自动归户 1：手动归户 2：无需归户
     */
    public enum BindFlagEnum {
        AUTO(0),// 自动归户
        HAND(1),// 手动归户
        NO(2),// 无需归户
        OUTSIDE(3);// 外链模式

        private Integer flag;

        BindFlagEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 是否显示在友情链接 0:否；1:是
     */
    public enum LinkDisplayFlagEnum {
        NO(0),// 否

        YES(1);// 是

        private Integer flag;

        LinkDisplayFlagEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * tbb消息通知 浏览广告平台
     */
    public enum ReadAdPlatformEnum {
        ENTRANCE("entrance"),   // 智能入口
        TBB("tbb"); // tbb

        private String flag;

        ReadAdPlatformEnum(String flag) {
            this.flag = flag;
        }

        public String getFlag() {
            return flag;
        }
    }

    /**
     * 统一消息关联 渠道标识
     */
    public enum MessageChannelEnum {
        REMIND("remind"),   // 站内信
        EMAIL("email"),   // 邮箱
        SMS("sms"),   // 短信
        WECOM("wecom"),   // 企微
        DINGTALK("dingTalk"); // 钉钉

        private String flag;

        MessageChannelEnum(String flag) {
            this.flag = flag;
        }

        public String getFlag() {
            return flag;
        }
    }

    /**
     * 自定义菜单类型
     */
    public enum CustomizedMenuTypeEnum {
        MENU(1),   // 菜单
        WORK(2),  // 作业
        LABEL(3);  // 组件

        private Integer type;

        CustomizedMenuTypeEnum(Integer type) {
            this.type = type;
        }

        public Integer getType() {
            return type;
        }
    }


    /**
     * 菜单类型 1:菜单 2:链接 3:iframe
     */
    public enum ManageMenuTypeEnum {
        MENU(1),   // 菜单
        LINK(2),  // 链接
        IFRAME(3);  // iframe

        private Integer type;

        ManageMenuTypeEnum(Integer type) {
            this.type = type;
        }

        public Integer getType() {
            return type;
        }
    }

    /**
     * 自定义菜单层级
     */
    public enum CustomizedMenuLevelEnum {
        FIRST(1),   // 一级
        SECOND(2),  // 二级
        THIRD(3);   // 三级

        private Integer level;

        CustomizedMenuLevelEnum(Integer level) {
            this.level = level;
        }

        public Integer getLevel() {
            return level;
        }
    }

    /**
     * 自定义菜单模式
     */
    public enum CustomizedMenuModeEnum {
        DEFAULT(0),   // 默认菜单
        CUSTOM(1);  // 自定义菜单

        private Integer flag;

        CustomizedMenuModeEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 预览内容的类型 1：取templateUrl预览 2：取subject预览 3：不支持预览
     */
    public enum PreviewTypeEnum {
        EMAIL_PREVIEW("email", 1),   // 邮箱预览
        SMS_PREVIEW("sms", 2),   // 短信预览
        WECOM_PREVIEW("wecom", 2),   // 企微预览
        DINGTALK_PREVIEW("dingTalk", 3); // 钉钉

        @Getter
        private String flag;

        @Getter
        private Integer type;

        PreviewTypeEnum(String flag, Integer type) {
            this.flag = flag;
            this.type = type;
        }

        /**
         * 通过渠道标识获取预览的内容类型标识
         *
         * @param flag 渠道标识
         * @return 内容类型type
         */
        public static Integer parseTypeByFlag(String flag) {
            if (StringUtils.isNotBlank(flag)) {
                for (PreviewTypeEnum typeEnum : PreviewTypeEnum.values()) {
                    if (typeEnum.getFlag().equals(flag)) {
                        return typeEnum.getType();
                    }
                }
            }
            return SMS_PREVIEW.getType();
        }
    }

    /**
     * 帆软系统查询目录接口，返回数据显示类型字段
     * 接口文档：https://docs.apipost.net/docs/detail/2b091f662064000?target_id=3345d1f730b002
     */
    public enum FineReportDeviceTypeEnum {
        NOT_SELECT_PC_PAD_PHONE(0),   // 未勾选 PC 、平板、手机
        PC(1),  // PC
        PAD(2), // PAD
        PC_PAD(3),  // PC、PAD
        PHONE(4),  // PHONE
        PC_PHONE(5),  // PC、PHONE
        PAD_PHONE(6),  // PAD、PHONE
        PC_PAD_PHONE(7);  // PC、PAD、PHONE

        private Integer flag;

        FineReportDeviceTypeEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 帆软系统查询目录接口，入参设备类型字段
     * 接口文档：https://docs.apipost.net/docs/detail/2b091f662064000?target_id=3345d1f730b002
     */
    public enum FineReportDeviceEnum {
        PC_DEVICVE("pcDevice"),   // 电脑端
        PAD_DEVICVE("padDevice"),  // 平板端
        PFONE_DEVICE("phoneDevice");  // 手机端

        private String flag;

        FineReportDeviceEnum(String flag) {
            this.flag = flag;
        }

        public String getFlag() {
            return flag;
        }
    }

    /**
     * 统一消息关联 邮箱类型
     */
    public enum EmailTypeEnum {
        CONTACT(1),   // 收件人
        CCCONTACT(2),   // 抄送人
        BCCCONTACT(3); // 密送人

        private Integer flag;

        EmailTypeEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 异构系统消息 数据获取方式 1:应用推送数据 2:拉取应用数据
     */
    public enum DataGetTypeEnum {
        PUSH(1),   // 应用推数据
        PULL(2); // 拉取应用数据

        private Integer flag;

        DataGetTypeEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 公告状态标识
     */
    public enum NewsAnnouncementStatusEnum {
        // 未发布
        UNPUBLISHED(0),
        // 已发布
        PUBLISHED(1),
        // 已失效
        EXPIRED(2),
        // 待生效
        PENDING_EFFECTIVE(3);

        private Integer flag;

        NewsAnnouncementStatusEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 异构系统消息 应用接入模式 1:混合云 2:非混合云
     */
    public enum AppAccessModelEnum {
        HYBRID_CLOUD(1),   // 混合云
        NOT_HYBRID_CLOUD(2); // 非混合云

        private Integer flag;

        AppAccessModelEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 布局状态（0：未发布；1：已发布）
     */
    public enum ReleaseEnum {
        NO_RELEASE(0),
        RELEASED(1);
        private Integer val;

        ReleaseEnum(Integer val) {
            this.val = val;
        }

        public Integer getVal() {
            return val;
        }
    }


    /**
     * 组件类型（0：自定义组件、1：预设组件、2：自定义菜单、3：容器
     */
    public enum PrtalContentTypeEnum {
        LABEL_SYSTEM_CUSTOM(0),
        LABEL_SYSTEM_PRE(1),
        CUSTOMIZED_MENU(2),
        CONTAINER(3);
        private Integer val;

        PrtalContentTypeEnum(Integer val) {
            this.val = val;
        }

        public Integer getVal() {
            return val;
        }
    }


    /**
     * 0：预设部件-金刚区、1：预设部件-任务组件、2：预设部件-项目追踪组件、3:预设部件-金刚球、4：预设部件-轮播图、5：预设部件-公告
     * 6：预设部件-标题、7：预设部件-分割线、8：预设部件-三方待办、9：预设部件-图片、10：预设部件-业务入口、11：自定义部件-H5外链
     */
    public enum PrtalMobileContentTypeEnum {
        PRE_KING_KONG_DISTRICT(0),
        PRE_TASK(1),
        PRE_PROJECT(2),
        KING_KONG_BALL(3),
        CONTENT_CAROUSEL(4),
        CONTENT_NEWS(5),
        TITLE(6),
        DIVIDER(7),
        THIRD_TO_DO(8),
        PICTURE(9),
        BUSINESS_ENTRANCE(10),
        H5_LINK(11),
        ;
        private Integer val;

        public static boolean isPreContent(Integer val) {
            if (PrtalMobileContentTypeEnum.PRE_KING_KONG_DISTRICT.getVal().equals(val)
                    || PrtalMobileContentTypeEnum.PRE_TASK.getVal().equals(val)
                    || PrtalMobileContentTypeEnum.PRE_PROJECT.getVal().equals(val)
                    || PrtalMobileContentTypeEnum.KING_KONG_BALL.getVal().equals(val)
                    || PrtalMobileContentTypeEnum.CONTENT_CAROUSEL.getVal().equals(val)
                    || PrtalMobileContentTypeEnum.CONTENT_NEWS.getVal().equals(val)
                    || PrtalMobileContentTypeEnum.TITLE.getVal().equals(val)
                    || PrtalMobileContentTypeEnum.DIVIDER.getVal().equals(val)
                    || PrtalMobileContentTypeEnum.THIRD_TO_DO.getVal().equals(val)
                    || PrtalMobileContentTypeEnum.PICTURE.getVal().equals(val)
                    || PrtalMobileContentTypeEnum.BUSINESS_ENTRANCE.getVal().equals(val)) {
                return true;
            }
            return false;
        }

        PrtalMobileContentTypeEnum(Integer val) {
            this.val = val;
        }

        public Integer getVal() {
            return val;
        }
    }

    enum DistrictinteractionTypeEnum {
        // 全部展开
        EXPAND_ALL(0),
        // 左右滑动
        SWIPE_LEFT_AND_RIGHT(1),
        // 折叠展开
        COLLAPSE_TO_EXPAND(2);

        private Integer value;

        DistrictinteractionTypeEnum(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return value;
        }
    }

    /**
     * 金刚球跳转类型（0-常用功能、1-自定义链接、2-应用作业、3-自定义页面、4-公告）
     */
    enum BallJumpTypeEnum {
        // 0-常用功能
        COMMONLY_USED_FUNCTIONS(0),
        // 1-自定义链接
        CUSTOM_LINKS(1),
        // 2-应用作业
        SSO_CONFIGURATION(2),
        // 3-自定义页面
        CUSTOM_PAGE(3),
        // 4-公告
        MOBILE_NEWS(4);

        public Integer getValue() {
            return value;
        }

        BallJumpTypeEnum(Integer value) {
            this.value = value;
        }

        private Integer value;

    }

    // 金刚区设置类型
    enum DistrictCustomTypeEnum {
        // 默认租户设置
        TENANT_TYPE(0),
        // 用户自定义设置
        USER_TYPE(1);

        private Integer value;

        DistrictCustomTypeEnum(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return value;
        }
    }

    /**
     * 0：租户端无权限弹框；1：关联源应用页面；2：布局设计器;3：作业工作台
     */
    public enum JumpToPageEnum {
        NO_PERMISSION_PAGE(0),
        CORRELATION_APP_PAGE(1),
        PORTAL_PAGE(2),
        JOB_BENCH_PAGE(3);
        private Integer val;

        JumpToPageEnum(Integer val) {
            this.val = val;
        }

        public Integer getVal() {
            return val;
        }
    }

    /**
     * 模版状态（0：未发布；1：已发布）
     */
    public enum TemplateStatusEnum {
        NO_RELEASE(0),
        RELEASED(1);
        private Integer val;

        TemplateStatusEnum(Integer val) {
            this.val = val;
        }

        public Integer getVal() {
            return val;
        }
    }

    /**
     * 模版类型（0：经典门户、1：作业工作台、2：自定义菜单）
     */
    public enum TemplateTypeEnum {
        CLASSIC_PORTAL(0),
        JOB_BENCH(1),
        CUSTOMIZED_MENU(2);
        private Integer val;

        TemplateTypeEnum(Integer val) {
            this.val = val;
        }

        public Integer getVal() {
            return val;
        }
    }

    /**
     * 模版编号的前缀
     */
    public enum TemplateNoPreEnum {
        PORTAL_PRE("MH_"),
        JOB_BENCH_PRE("ZYGZT_");
        private String val;

        TemplateNoPreEnum(String val) {
            this.val = val;
        }

        public String getVal() {
            return val;
        }
    }

    /**
     * 给用户授权应用 操作行为，1-删除授权，0-新增授权
     */
    public enum IamAuthorizeTypeEnum {
        DELETE(1),// 删除授权
        INSERT(0); // 新增授权
        private Integer val;

        IamAuthorizeTypeEnum(Integer val) {
            this.val = val;
        }

        public Integer getVal() {
            return val;
        }
    }

    /**
     * 部门租户选择类型（0：按租户、1：按分组）
     */
    public enum SelectTypeEnum {
        RELEASE_BY_TENANT(0),   // 按租户
        RELEASE_BY_GROUP(1);   // 按分组
        private Integer flag;

        SelectTypeEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 订阅的类型（0：全部租户、1：部分租户、2：不选择租户）
     */
    public enum SubTypeEnum {
        ALL_TENANT(0),// 全部租户
        PART_TENANT(1),// 部分租户
        NO_TENANT(2); // 不选择租户
        private Integer flag;

        SubTypeEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 类型：1-第三方应用/作业 2-鼎捷非雅典娜应用 3-鼎捷雅典娜新应用
     */
    enum MobileDataSourceTye {
        MOBILE_THIRD_APPLICATION(1),
        DIGIWIN_NOT_ATHENA_APPLICATION(2),
        DIGIWIN_ATHENA_APPLICATION(3);

        private Integer value;

        MobileDataSourceTye(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return value;
        }
    }

    /**
     * 自定义应用状态标识
     */
    public enum MobileDatasourceInfoStatusEnum {
        // 未启用
        UNUSABLE(0),
        // 已启用
        ENABLE(1);

        private Integer flag;

        MobileDatasourceInfoStatusEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    enum IsNeedJobEnum {
        NOT_NEED_JOB(0),

        NEED_CUSTOM_JOB(1);

        private Integer value;

        public Integer getValue() {
            return value;
        }

        IsNeedJobEnum(Integer value) {
            this.value = value;
        }
    }


    /**
     * 移动数据源图标类型
     */
    public enum MobileIconTypeEnum {
        // 图标库
        ICON_LIB(0),
        // 自定义
        ICON_CUSTOM(1);

        private Integer flag;

        MobileIconTypeEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 公告渠道标识 0:全部 1:Web工作台 2:移动工作台
     */
    public enum NewsChannelFlagEnum {
        ALL(0),
        WEB(1),
        MOBILE(2);

        private Integer flag;

        NewsChannelFlagEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 公告来源 0：一方 1：三方
     */
    public enum NewsSourceEnum {
        ONE(0),
        THIRD(1);

        private Integer flag;

        NewsSourceEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 类型：1-第三方应用/作业 2-鼎捷非雅典娜新应用 3-鼎捷雅典娜应用
     */
    public enum MobileAppJobTypeEnum {
        THIRD_APP_JOB(1),
        NO_IAM_APP(2),
        IAM_APP(3);

        private Integer flag;

        MobileAppJobTypeEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 移动应用作业中特殊标识：1-绿色智机 2-每刻
     */
    public enum SpecialSignEnum {
        TOPIC_PRESET(1),
        MAYCUR(2);

        private Integer flag;

        SpecialSignEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 菜单所属环境标识 0:全部 1:云上 2:下地
     */
    public enum MenuEnvironmentFlag {
        ALL(0),
        CLOUD(1),
        CUSTOM(2);

        private Integer flag;

        MenuEnvironmentFlag(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 是否是二级页面 0:否 1:是
     */
    public enum SecondPageFlagEnum {
        NO(0),// 否

        YES(1);// 是

        private Integer flag;

        SecondPageFlagEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 移动门户类型（0：门户布局；1：自定义页面布局）
     */
    public enum MobilePortalTypeEnum {
        PORTAL(0),

        CUSTOM_PORTAL(1);

        private Integer flag;

        MobilePortalTypeEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 客户端类型 PC端：0，移动端：1
     */
    @Getter
    enum ClientTypeTypeEnum {
        PC(0),

        MOBILE(1);

        private final Integer flag;

        ClientTypeTypeEnum(Integer flag) {
            this.flag = flag;
        }

    }

    /**
     * 门户来源，0：租户门户，1：ISV门户
     */
    @Getter
    enum PortalTypeSourceEnum {
        TENANT(0),

        ISV(1);

        private final Integer flag;

        PortalTypeSourceEnum(Integer flag) {
            this.flag = flag;
        }

    }

    /**
     * 部件类型来源，0：租户部件，1：ISV部件
     */
    @Getter
    enum LabelTypeSourceEnum {
        TENANT(0),

        ISV(1);

        private final Integer flag;

        LabelTypeSourceEnum(Integer flag) {
            this.flag = flag;
        }

    }

    /**
     * 菜单来源，0：租户菜单，1：ISV菜单
     */
    @Getter
    enum MenuTypeSourceEnum {
        TENANT(0),

        ISV(1);

        private final Integer flag;

        MenuTypeSourceEnum(Integer flag) {
            this.flag = flag;
        }

    }

    @Getter
    enum SourceEnum {
        TENANT(0),

        ISV(1);

        private final Integer flag;

        SourceEnum(Integer flag) {
            this.flag = flag;
        }
    }


    /**
     * 平台配置项
     */
    public enum SceneCodeEnum {
        // 门户下拉选择
        PORTAL_SELECT_OPTION("portal_select_option");

        private String code;

        SceneCodeEnum(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }
    }


    /**
     * web链接类型: 0-常用功能；1-待办；2-友情链接；3-消息；4-作业工作台；
     * * 5-常用；6-收藏；7-升级说明；8-行事历；9-全局搜索；10-新闻公告；
     * * 11-单条公告；12-公告分类；13-应用；14-作业；15-业务待办；16-自定义链接
     */
    public enum WebLinkTypeEnum {
        COMMON_FUNCTION(0),
        TO_DO(1),
        FRIENDSHIP_LINK(2),
        MESSAGE(3),
        JOB_BENCH(4),
        COMMON(5),
        COLLECT(6),
        UPGRADE_INST(7),
        CALENDAR(8),
        GLOBAL_SEARCH(9),
        NEWS(10),
        NEWS_ONE(11),
        NEWS_TYPE(12),
        APP(13),
        JOB(14),
        BUSINESS_TODO(15),
        CUSTOM_LINK(16);
        private Integer val;

        WebLinkTypeEnum(Integer val) {
            this.val = val;
        }

        public Integer getVal() {
            return val;
        }

        public static List<Integer> getTenantDesign() {
            return Arrays.asList(
                    WebLinkTypeEnum.COMMON_FUNCTION.getVal(),
                    WebLinkTypeEnum.TO_DO.getVal(),
                    WebLinkTypeEnum.FRIENDSHIP_LINK.getVal(),
                    WebLinkTypeEnum.MESSAGE.getVal(),
                    WebLinkTypeEnum.JOB_BENCH.getVal(),
                    WebLinkTypeEnum.COMMON.getVal(),
                    WebLinkTypeEnum.COLLECT.getVal(),
                    WebLinkTypeEnum.UPGRADE_INST.getVal(),
                    WebLinkTypeEnum.CALENDAR.getVal(),
                    WebLinkTypeEnum.GLOBAL_SEARCH.getVal(),
                    WebLinkTypeEnum.NEWS.getVal(),
                    WebLinkTypeEnum.NEWS_ONE.getVal(),
                    WebLinkTypeEnum.NEWS_TYPE.getVal(),
                    WebLinkTypeEnum.CUSTOM_LINK.getVal()
            );
        }
    }

    @Getter
    @AllArgsConstructor
    enum TerminalTypeEnum {
        PC("PC", 0),
        APP("APP", 1);
        private String code;
        private int type;

        public static Integer getTypeByCode(String code) {
            if (TerminalTypeEnum.PC.getCode().equals(code)) {
                return TerminalTypeEnum.PC.getType();
            } else if (TerminalTypeEnum.APP.getCode().equals(code)) {
                return TerminalTypeEnum.APP.getType();
            }
            return 0;
        }

        public static List<String> getCodes() {
            return Arrays.stream(TerminalTypeEnum.values()).map(TerminalTypeEnum::getCode).collect(Collectors.toList());
        }
    }

    /**
     * 组件所属端，0：PC端，1：移动端
     * 门户所属端，0：PC端，1：移动端
     */
    enum ClientTypeEnum {
        PC(0),
        MOBILE(1);
        private Integer value;

        public Integer getValue() {
            return value;
        }

        ClientTypeEnum(Integer value) {
            this.value = value;
        }
    }

    /**
     * 部件类型来源，0：租户部件，1：ISV部件
     * 门户类型来源，0：租户门户，1：ISV门户
     */
    enum LabelOrPoralSourceEnum {
        TENANT(0),
        ISV(1);

        private Integer flag;

        LabelOrPoralSourceEnum(Integer flag) {
            this.flag = flag;
        }

        public Integer getFlag() {
            return flag;
        }
    }

    /**
     * 访问类型
     * 0：访问首页门户
     * 1：访问管理后台门户
     */
    enum VisitTypeEnum {
        ATHENA_PORTAL(0),
        MANAGEMENT(1);

        private Integer value;

        public Integer getValue() {
            return value;
        }

        VisitTypeEnum(Integer value) {
            this.value = value;
        }
    }

    /**
     * 用户绑定设备配置变更
     */
    String USER_DEVICE_CONFIG_CHANGE = "USER_DEVICE_CONFIG_CHANGE";

    /**
     * 用户绑定设备状态变更
     */
    String USER_DEVICE_STATUS_CHANGE = "USER_DEVICE_STATUS_CHANGE";

    /**
     * 三方待办消息topic
     */
    public static final String SEMC_TODO_USER = "SEMC_TODO_USER";

    /**
     * 三方待办消息-租户级别 topic
     */
    public static final String SEMC_TODO_TENANT = "SEMC_TODO_TENANT";


    /**
     * 三方待办中efnet 用户id字段
     */
    public static final String SEMC_TODO_EFNET_USER = "FK_EmpID";

    String DMC_FILE_PREVIEW_DIRECTORY = "preview";

    String DMC_FILE_BUCKET = "/intelligententry";

    String DMC_FILE_PREVIEW_BUCKET = DMC_FILE_BUCKET + "/" + DMC_FILE_PREVIEW_DIRECTORY;

    /**
     * 文件预览地址
     */
    public static final String DMC_FILE_PREVIEW_PATH = "/api/dmc/v2/file" + DMC_FILE_PREVIEW_BUCKET + "/";


    /**
     * 移动端文件预览地址
     */
    public static final String DMC_MOBILE_FILE_PREVIEW_PATH = "/api/dmc/v2/file/intelligententry/online/preview/";

    /**
     * 雅典娜_智能入口消息默认事件
     */
    public static final String SEMC_MESSAGE_DEFAULT_EVENT_ID = "ATHENA_SEMC_MESSAGE_DEFAULT";

    /**
     * 异构系统消息通知topic
     */
    public static final String THIRD_MESSAGE_NOTICE_USER_TOPIC = "THIRD_MESSAGE_NOTICE";

    /**
     * 异构系统消息通知（移动）
     */
    public static final String THIRD_MESSAGE_MOBILE_NOTICE_USER_TOPIC = "THIRD_MESSAGE_MOBILE_NOTICE";


    /**
     * 作业同步AES加解密的秘钥
     */
    @SuppressWarnings("all")
    public static final String SYNC_SECRET = "Wr3t3568aXaH91T30000fMK3ZpOyv4";

    /**
     * 我的应用
     */
    public static final String MY_TOPIC_PRESET = "我的应用";


    /**
     * 绿色智机模组之间拼接的特殊符号
     */
    public static final String MY_TOPIC_PRESET_SYMBOL = "§";


    /**
     * tbb应用id
     */
    public static final String TBB_APP_ID = "tipbiubi";


    /**
     * 请求iam获取功能权限target前缀
     */
    public static final String IAM_FUNCTIONAL_STR = "drn:iam:app:";

    /**
     * 冒号
     */
    public static final String COLON = ":";

    /**
     * 公司别和厂别参数
     */
    public static final String ENTER_PRISE_FACTORY_INFO = "&enterpriseFactoryInfo=";


    /**
     * 请求异构作业接口地址  测试桩地址：/eai/mocksys/data/queryJobData、正式地址：/app/job/queryJobList
     */
    public static final String QUERY_JOB_LIST_URL = "/eai/mocksys/data/queryJobData";

    public static final String QUERY_TODOJOB_LIST_URL = "/tenant/semc/todo/queryAll";

    public static final String TEST_TODOJOB_LIST_URL = "/eai/mocksys/todo/queryToDoData";

    public static final String QUERY_MESSAGEJOB_LIST_URL = "/third/message/query";

    public static final String TEST_MESSAGEJOB_LIST_URL = "/eai/mocksys/third/message/query";


    /**
     * 三方待办
     */
    public static final String THIRD_TO_DO_DESC = "三方待办";

    /**
     * 待办
     */
    public static final String TO_DO_DESC = "待办";

    /**
     * T100链接参数值
     */
    public static final String T100_TRUST_KEY = "athenaAb1234PWd28682266T100frank";

    /**
     * 自定义组件-统计的值
     */
    public static final Integer COUNT_COMPOENT_TYPE = 6;


    /**
     * 应用经典图标前缀
     */
    public static final String ICON_TZYY_APP = "icon_tzyy_";


    /**
     * 作业经典图标前缀
     */
    public static final String ICON_TZZY_JOB = "icon_tzzy_";

    /**
     * 极简门户下应用和作业的图标
     */
    public static final String PORTAL_CARD = "portal_card_performance,portal_card_report,portal_card_todo,portal_card_collect,portal_card_news,portal_card_common,portal_card_global";


    /**
     * passwordHash 的值
     */
    public static final String ZONE_USER_HASH = "6826CC688C4AF1BD0A8DDA2DBDF8897B";

    /**
     * passwordHash 的值
     */
    public static final String PASS_WORD_HASH = "passwordHash";

    /**
     * IDENTITY_TYPE
     */
    public static final String IDENTITY_TYPE_KEY = "identityType";

    /**
     * IDENTITY_TYPE 的值
     */
    public static final String IDENTITY_TYPE_VALUE = "internal";

    /**
     * 加密演算法BlowFish
     */
    public static final String BLOW_FISH = "BlowFish";

    /**
     * userId
     */
    public static final String ZONE_USER_ID = "integration";


    /**
     * tenantId
     */
    public static final String ZONE_TENANT_ID = "semcIntegrated";

    /**
     * 超管标识
     */
    public static final String SUPER_ADMIN = "superadmin";

    /**
     * 默认金刚球的图标
     */
    public static final String CONTENT_ICON_DEF = "/assets/img/mobile/king/default.svg";

    /**
     * 埋点来源
     */
    public static final String SOURCE = "source";

    /**
     * 移动门户复制名称前缀
     */
    public static final String MOBILE_PORTAL_COPY_NAME = "_复制";

    /**
     * iSV管理菜单key
     */
    public static final String ISV_MANAGE_KEY = "isv-manage";

    /**
     * iam租户默认版本v1
     */
    public static final String IAM_TENANT_DEF_V = "v1";

    /**
     * 是否全员可见 0:否 1:是
     */
    Integer ALL_AUTH_FLAG_YES = 1;

    /**
     * 是否全员可见 0:否 1:是
     */
    Integer ALL_AUTH_FLAG_NO = 0;

    /**
     * 帆软报表-pc端报表
     */
    Integer PC_FINE_REPORT = 1;

    /**
     * 帆软报表-移动端报表
     */
    Integer MOBILE_FINE_REPORT = 2;

    /**
     * .cpt格式帆软报表
     */
    String CPT_FINE_REPORT_END = ".cpt";

    /**
     * .frm格式帆软报表
     */
    String FRM_FINE_REPORT_END = ".frm";

    /**
     * .cpt格式帆软报表跳转固定路径
     */
    String CPT_FINE_REPORT_PATH = "/webroot/decision/view/report?viewlet=";

    /**
     * .frm格式帆软报表跳转固定路径
     */
    String FRM_FINE_REPORT_PATH = "/webroot/decision/view/form?viewlet=";

    /**
     * .fvs格式帆软报表跳转固定路径
     */
    String FVS_FINE_REPORT_PATH = "/webroot/decision/view/duchamp?viewlet=";

    /**
     * 帆软系统查询目录接口，平台类型字段，102表示帆软报表
     * 接口文档：https://docs.apipost.net/docs/detail/2b091f662064000?target_id=3345d1f730b002
     */
    Integer FINE_REPORT_TYPE = 102;

    /**
     * 链接格式
     */
    String MESSAGE_LINK_URL = "<a href=\"%s\">%s</a>";
}
