package com.digiwin.athena.semc.common;

/**
 * @Author: sunyfa
 * @CreateTime: 2022/12/6 11:41
 * @Description: 系統错误码
 * @Version: 1.0
 */
public final class ErrorCodeConstant {
    public static final String SYSTEM = "2";

    public static final String FINE_REPORT = "3";

    public static final String FOLDER = "4";

    public static final String MODULE_COMMON = "0";

    public static final String MODULE_EXTERNAL_CALL = "1";

    public static final String SYSTEM_PRE = "5";

    public static final String DATA_SOURCE = "6";

    public static final String VALID_STATUS = "7";

    public static final String SYSTEM_CUSTOM = "8";

    public static final String SAVE_SYSTEM_CUSTOM = "9";

    public static final String SAVE_PORTAL_LAYOUT = "10";

    public static final String USERID = "11";

    public static final String COMPANY = "12";

    public static final String ZHIQI_COUNT = "13";

    public static final String ZHIQI_EMAIL_SUFFIX = "15";

    public static final String ZHIQI_CORP_ID = "16";

    public static final String ZHIQI_CORP_SECRET = "17";


    // 参数缺失
    public static final Integer PARAM_MISSING_ERROR = Integer.valueOf(SYSTEM + MODULE_COMMON + "01");

    // 参数不合法
    public static final Integer PARAM_ILLEGAL_ERROR = Integer.valueOf(SYSTEM + MODULE_COMMON + "02");

    // 参数长度不合法
    public static final Integer PARAM_LENGTH_ERROR = Integer.valueOf(SYSTEM + MODULE_COMMON + "03");

    // 系统异常
    public static final Integer SYSTEM_ERROR = Integer.valueOf(SYSTEM + MODULE_COMMON + "99");

    // 更新失败
    public static final Integer UPDATE_FAILED = Integer.valueOf(SYSTEM + MODULE_COMMON + "98");

    // 对接三方系统异常
    public static final Integer ADAPT_SYSTEM_ERROR = Integer.valueOf(SYSTEM + MODULE_COMMON + "97");

    // 参数缺失
    public static final Integer IAM_USER_TOKEN_INVALID = Integer.valueOf(SYSTEM + MODULE_EXTERNAL_CALL + "01");

    // 父目录不存在
    public static final Integer FOLDER_PARENT_NOT_EXISTS = Integer.valueOf(FOLDER + MODULE_COMMON + "01");
    // 目录层级错误
    public static final Integer FOLDER_LEVEL_ERROR = Integer.valueOf(FOLDER + MODULE_COMMON + "02");
    // 子目录创建错误
    public static final Integer FOLDER_CHILD_CREATE_ERROR = Integer.valueOf(FOLDER + MODULE_COMMON + "03");
    // 子目录创建错误
    public static final Integer FOLDER_CHILD_CREATE_NAME_ERROR = Integer.valueOf(FOLDER + MODULE_COMMON + "04");
    // 目录层级不能为空
    public static final Integer FOLDER_LEVEL_NOT_EXISTS = Integer.valueOf(FOLDER + MODULE_COMMON + "04");


    // 预设组件查询失败
    public static final Integer LABEL_SYSTEM_PRE = Integer.valueOf(SYSTEM_PRE + MODULE_COMMON + "05");

    // 更新数据源
    public static final Integer UPDATE_SYSTEM_DATA_SOURCE = Integer.valueOf(DATA_SOURCE + MODULE_COMMON + "06");

    // 更新启用停用状态
    public static final Integer UPDATE_SYSTEM_VALID_STATUS = Integer.valueOf(VALID_STATUS + MODULE_COMMON + "07");

    // 自定义组件查询失败
    public static final Integer LABEL_SYSTEM_CUSTOM = Integer.valueOf(SYSTEM_CUSTOM + MODULE_COMMON + "08");


    // 自定义组件保存失败
    public static final Integer SAVE_LABEL_SYSTEM_CUSTOM = Integer.valueOf(SAVE_SYSTEM_CUSTOM + MODULE_COMMON + "09");


    public static final Integer SAVE_PORTAL_LABEL = Integer.valueOf(SAVE_PORTAL_LAYOUT + MODULE_COMMON + "10");

    // 无工号提示code
    public static final Integer NO_USER_ID = Integer.valueOf(USERID + MODULE_COMMON + "11");

    // 公司名重复
    public static final Integer COMPANY_NAME_REPEAT = Integer.valueOf(COMPANY + MODULE_COMMON + "12");

    // 智奇邮件信息配置数量限制
    public static final Integer ZHIQI_EMAIL_COUNT = Integer.valueOf(ZHIQI_COUNT + MODULE_COMMON + "13");


    // 邮箱后缀
    public static final Integer EMAIL_SUFFIX = Integer.valueOf(ZHIQI_EMAIL_SUFFIX + MODULE_COMMON + "15");

    // corpId
    public static final Integer CORP_ID = Integer.valueOf(ZHIQI_CORP_ID + MODULE_COMMON + "16");

    // corpsecret
    public static final Integer CORP_SECRET = Integer.valueOf(ZHIQI_CORP_SECRET + MODULE_COMMON + "17");
    private ErrorCodeConstant() {
    }
}
